/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ai.hub.site.initializer.internal.workflow.kaleo.runtime.node;

import com.liferay.ai.hub.site.initializer.internal.workflow.kaleo.runtime.node.util.InputVariablesUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowNodeManager;
import com.liferay.portal.workflow.kaleo.definition.NodeType;
import com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoNode;
import com.liferay.portal.workflow.kaleo.model.KaleoNodeSetting;
import com.liferay.portal.workflow.kaleo.model.KaleoTransition;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.graph.PathElement;
import com.liferay.portal.workflow.kaleo.runtime.node.BaseNodeExecutor;
import com.liferay.portal.workflow.kaleo.runtime.node.NodeExecutor;
import com.liferay.portal.workflow.kaleo.service.KaleoNodeSettingLocalService;
import dev.langchain4j.agent.tool.P;
import dev.langchain4j.agent.tool.Tool;
import dev.langchain4j.invocation.InvocationParameters;
import dev.langchain4j.model.chat.StreamingChatModel;
import dev.langchain4j.model.vertexai.gemini.VertexAiGeminiStreamingChatModel;
import dev.langchain4j.service.AiServices;
import dev.langchain4j.service.TokenStream;
import dev.langchain4j.service.UserMessage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={NodeExecutor.class})
public class AIDecisionNodeExecutor
extends BaseNodeExecutor {
    @Reference
    private KaleoNodeSettingLocalService _kaleoNodeSettingLocalService;
    @Reference
    private WorkflowNodeManager _workflowNodeManager;

    public NodeType getNodeType() {
        return NodeType.AI_DECISION;
    }

    protected boolean doEnter(KaleoNode currentKaleoNode, ExecutionContext executionContext) {
        return true;
    }

    protected void doExecute(KaleoNode currentKaleoNode, ExecutionContext executionContext, List<PathElement> remainingPathElements) {
        HashMap<String, String> kaleoNodeSettingValues = new HashMap<String, String>();
        List kaleoNodeSettings = this._kaleoNodeSettingLocalService.getKaleoNodeSettings(currentKaleoNode.getKaleoNodeId());
        for (KaleoNodeSetting kaleoNodeSetting : kaleoNodeSettings) {
            kaleoNodeSettingValues.put(kaleoNodeSetting.getName(), kaleoNodeSetting.getValue());
        }
        VertexAiGeminiStreamingChatModel vertexAiGeminiStreamingChatModel = VertexAiGeminiStreamingChatModel.builder().project("ai-hub-liferay").location("us-central1").modelName("gemini-2.5-flash-lite").build();
        DecisionAssistant decisionAssistant = (DecisionAssistant)AiServices.builder(DecisionAssistant.class).systemMessageProvider(object -> InputVariablesUtil.applyInputVariables(executionContext, "prompt", kaleoNodeSettingValues)).streamingChatModel((StreamingChatModel)vertexAiGeminiStreamingChatModel).tools(new Object[]{new Tools()}).build();
        decisionAssistant.decide(InvocationParameters.from(Map.of("executionContext", executionContext, "permissionChecker", PermissionThreadLocal.getPermissionChecker())), InputVariablesUtil.applyInputVariables(executionContext, "userMessage", kaleoNodeSettingValues)).onCompleteResponse(response -> vertexAiGeminiStreamingChatModel.close()).onError(throwable -> vertexAiGeminiStreamingChatModel.close()).start();
    }

    protected void doExit(KaleoNode currentKaleoNode, ExecutionContext executionContext, List<PathElement> remainingPathElements) throws PortalException {
        KaleoTransition kaleoTransition = null;
        kaleoTransition = Validator.isNull((String)executionContext.getTransitionName()) ? currentKaleoNode.getDefaultKaleoTransition() : currentKaleoNode.getKaleoTransition(executionContext.getTransitionName());
        remainingPathElements.add(new PathElement(null, kaleoTransition.getTargetKaleoNode(), new ExecutionContext(executionContext.getKaleoInstanceToken(), executionContext.getWorkflowContext(), executionContext.getServiceContext())));
    }

    public static interface DecisionAssistant {
        public TokenStream decide(InvocationParameters var1, @UserMessage String var2);
    }

    public class Tools {
        @Tool(value={"Complete the workflow node by proceeding to the chosen transition"})
        public void completeWorkflowNode(@P(value="A brief, one-sentence justification for the chosen transition.") String reason, @P(value="Transition name") String transitionName, InvocationParameters parameters) throws PortalException {
            ExecutionContext executionContext = (ExecutionContext)parameters.get("executionContext");
            Map workflowContext = executionContext.getWorkflowContext();
            workflowContext.put("reason", reason);
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)((PermissionChecker)parameters.get("permissionChecker")));
            KaleoInstanceToken kaleoInstanceToken = executionContext.getKaleoInstanceToken();
            AIDecisionNodeExecutor.this._workflowNodeManager.completeWorkflowNode(kaleoInstanceToken.getCompanyId(), kaleoInstanceToken.getUserId(), kaleoInstanceToken.getKaleoInstanceTokenId(), transitionName, workflowContext, false);
        }
    }
}

