/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ai.hub.rest.internal.resource.v1_0;

import com.liferay.ai.hub.rest.dto.v1_0.Scope;
import com.liferay.ai.hub.rest.dto.v1_0.Task;
import com.liferay.ai.hub.rest.internal.resource.v1_0.BaseTaskResourceImpl;
import com.liferay.ai.hub.rest.resource.v1_0.TaskResource;
import com.liferay.ai.hub.rest.resource.v1_0.util.SseUtil;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupService;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.workflow.WorkflowInstance;
import com.liferay.portal.kernel.workflow.WorkflowInstanceManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.sse.Sse;
import jakarta.ws.rs.sse.SseEventSink;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/task.properties"}, scope=ServiceScope.PROTOTYPE, service={TaskResource.class})
public class TaskResourceImpl
extends BaseTaskResourceImpl {
    @Reference
    private GroupService _groupService;
    @Context
    private Sse _sse;
    @Reference
    private WorkflowInstanceManager _workflowInstanceManager;

    @Override
    public void getTaskSubscribe(SseEventSink sseEventSink) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-62272")) {
            throw new UnsupportedOperationException();
        }
        SseUtil.initialize((Sse)this._sse, (SseEventSink)sseEventSink);
    }

    @Override
    public Task postTask(final Task task) throws Exception {
        Group group;
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-62272")) {
            throw new UnsupportedOperationException();
        }
        long groupId = 0L;
        Scope scope = task.getScope();
        if (scope != null && (group = this._groupService.fetchGroupByExternalReferenceCode(scope.getExternalReferenceCode(), this.contextCompany.getCompanyId())) != null) {
            groupId = group.getGroupId();
        }
        final WorkflowInstance workflowInstance = this._workflowInstanceManager.startWorkflowInstance(this.contextCompany.getCompanyId(), groupId, this.contextUser.getUserId(), task.getType(), Integer.valueOf(1), null, this._toWorkflowContext(task));
        return new Task(){
            {
                this.setExternalReferenceCode(() -> String.valueOf(workflowInstance.getWorkflowInstanceId()));
                this.setScope(() -> ((Task)task).getScope());
                this.setType(() -> ((Task)task).getType());
            }
        };
    }

    private Map<String, Serializable> _toWorkflowContext(Task task) throws Exception {
        HashMap<String, Serializable> workflowContext = new HashMap<String, Serializable>();
        Map context = task.getContext();
        for (Map.Entry entry : context.entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof Serializable)) continue;
            workflowContext.put((String)entry.getKey(), (Serializable)value);
        }
        workflowContext.put("serviceContext", (Serializable)ServiceContextFactory.getInstance((HttpServletRequest)this.contextHttpServletRequest));
        workflowContext.put("broadcast", (BiConsumer<String, String> & Serializable)(data, id) -> SseUtil.broadcast((String)data, (String)id, (String)task.getType(), (Sse)this._sse));
        return workflowContext;
    }
}

