/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ai.hub.rest.resource.v1_0.util;

import com.liferay.portal.kernel.util.PortalRunMode;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import jakarta.ws.rs.sse.Sse;
import jakarta.ws.rs.sse.SseEventSink;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SseUtil {
    private static Map<String, SseEventSink> _sseEventSinks = new ConcurrentHashMap<String, SseEventSink>();

    public static void closeAll() {
        if (_sseEventSinks.isEmpty() || !PortalRunMode.isTestMode()) {
            return;
        }
        _sseEventSinks.forEach((__, sseEventSink) -> sseEventSink.close());
        _sseEventSinks = new ConcurrentHashMap<String, SseEventSink>();
    }

    public static SseEventSink getSSEEventSink(String sseEventSinkKey) {
        return _sseEventSinks.get(sseEventSinkKey);
    }

    public static Set<String> getSSEEventSinksKeys() {
        if (!PortalRunMode.isTestMode()) {
            return null;
        }
        return _sseEventSinks.keySet();
    }

    public static void initialize(Sse sse, SseEventSink sseEventSink) {
        String sseEventSinkKey = PortalUUIDUtil.generate();
        _sseEventSinks.put(sseEventSinkKey, sseEventSink);
        sseEventSink.send(sse.newEventBuilder().data(String.class, (Object)sseEventSinkKey).name("Subscribe").build());
    }
}

