/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.image.internal.convert.document.library;

import com.liferay.adaptive.media.image.internal.storage.AMStoreUtil;
import com.liferay.adaptive.media.image.service.AMImageEntryLocalService;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.kernel.store.Store;
import com.liferay.portal.convert.documentlibrary.DLStoreConvertProcess;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.util.MaintenanceUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DLStoreConvertProcess.class})
public class AMDLStoreConvertProcess
implements DLStoreConvertProcess {
    private static final Log _log = LogFactoryUtil.getLog(AMDLStoreConvertProcess.class);
    @Reference
    private AMImageEntryLocalService _amImageEntryLocalService;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private DLAppLocalService _dlAppLocalService;

    public void copy(Store sourceStore, Store targetStore) throws PortalException {
        this._transfer(sourceStore, targetStore, false);
    }

    public void move(Store sourceStore, Store targetStore) throws PortalException {
        this._transfer(sourceStore, targetStore, true);
    }

    private ActionableDynamicQuery _getActionableDynamicQuery(long companyId, Store sourceStore, Store targetStore, boolean delete) {
        ActionableDynamicQuery actionableDynamicQuery = this._amImageEntryLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"companyId", (Object)companyId)));
        actionableDynamicQuery.setPerformActionMethod(amImageEntry -> {
            FileVersion fileVersion = null;
            try {
                fileVersion = this._dlAppLocalService.getFileVersion(amImageEntry.getFileVersionId());
            }
            catch (PortalException portalException) {
                _log.error((Object)("Unable to migrate file version " + amImageEntry.getFileVersionId()), (Throwable)portalException);
            }
            if (fileVersion == null) {
                return;
            }
            String fileVersionPath = AMStoreUtil.getFileVersionPath(fileVersion, amImageEntry.getConfigurationUuid());
            for (String versionLabel : sourceStore.getFileVersions(amImageEntry.getCompanyId(), 0L, fileVersionPath)) {
                try {
                    this.transferFile(sourceStore, targetStore, amImageEntry.getCompanyId(), 0L, fileVersionPath, versionLabel, delete);
                }
                catch (Exception exception) {
                    _log.error((Object)("Unable to migrate " + fileVersionPath), (Throwable)exception);
                }
            }
        });
        return actionableDynamicQuery;
    }

    private long _getCount(long companyId) {
        DynamicQuery dynamicQuery = this._amImageEntryLocalService.dynamicQuery();
        dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"companyId", (Object)companyId));
        return this._amImageEntryLocalService.dynamicQueryCount(dynamicQuery);
    }

    private void _transfer(Store sourceStore, Store targetStore, boolean delete) throws PortalException {
        this._companyLocalService.forEachCompanyId(companyId -> {
            MaintenanceUtil.appendStatus((String)String.format("Migrating images in %d adaptive media image entries for company %d", this._getCount((long)companyId), companyId));
            ActionableDynamicQuery actionableDynamicQuery = this._getActionableDynamicQuery((long)companyId, sourceStore, targetStore, delete);
            actionableDynamicQuery.performActions();
        });
    }
}

