/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.adaptive.media.image.model.impl;

import com.liferay.adaptive.media.image.model.AMImageEntry;
import com.liferay.adaptive.media.image.service.AMImageEntryLocalServiceUtil;

/**
 * The extended model base implementation for the AMImageEntry service. Represents a row in the &quot;AMImageEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link AMImageEntryImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see AMImageEntryImpl
 * @see AMImageEntry
 * @generated
 */
public abstract class AMImageEntryBaseImpl
	extends AMImageEntryModelImpl implements AMImageEntry {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a am image entry model instance should use the <code>AMImageEntry</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			AMImageEntryLocalServiceUtil.addAMImageEntry(this);
		}
		else {
			AMImageEntryLocalServiceUtil.updateAMImageEntry(this);
		}
	}

}