/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.image.internal.change.tracking.spi.resolver;

import com.liferay.adaptive.media.image.model.AMImageEntry;
import com.liferay.adaptive.media.image.service.AMImageEntryLocalService;
import com.liferay.change.tracking.spi.resolver.ConstraintResolver;
import com.liferay.change.tracking.spi.resolver.context.ConstraintResolverContext;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import java.util.Locale;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ConstraintResolver.class})
public class AMImageEntryConstraintResolver
implements ConstraintResolver<AMImageEntry> {
    @Reference
    private AMImageEntryLocalService _amImageEntryLocalService;

    public String getConflictDescriptionKey() {
        return "duplicate-adaptive-media-image";
    }

    public Class<AMImageEntry> getModelClass() {
        return AMImageEntry.class;
    }

    public String getResolutionDescriptionKey() {
        return "duplicate-adaptive-media-image-was-removed";
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        return ResourceBundleUtil.getBundle((Locale)locale, this.getClass());
    }

    public String[] getUniqueIndexColumnNames() {
        return new String[]{"configurationUuid", "fileVersionId"};
    }

    public void resolveConflict(ConstraintResolverContext<AMImageEntry> constraintResolverContext) throws PortalException {
        AMImageEntry amImageEntry = (AMImageEntry)constraintResolverContext.getTargetCTModel();
        this._amImageEntryLocalService.deleteAMImageEntry(amImageEntry);
    }
}

