/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.document.library.thumbnails.internal.osgi.commands;

import com.liferay.adaptive.media.document.library.thumbnails.internal.osgi.commands.configuration.ThumbnailConfiguration;
import com.liferay.adaptive.media.image.configuration.AMImageConfigurationEntry;
import com.liferay.adaptive.media.image.configuration.AMImageConfigurationHelper;
import com.liferay.adaptive.media.image.mime.type.AMImageMimeTypeProvider;
import com.liferay.adaptive.media.image.model.AMImageEntry;
import com.liferay.adaptive.media.image.service.AMImageEntryLocalService;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.kernel.store.DLStoreUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.image.ImageBag;
import com.liferay.portal.kernel.image.ImageTool;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.CompanyModel;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"osgi.command.function=check", "osgi.command.function=cleanUp", "osgi.command.function=migrate", "osgi.command.scope=thumbnails"}, service={AMThumbnailsOSGiCommands.class})
public class AMThumbnailsOSGiCommands {
    private static final Log _log = LogFactoryUtil.getLog(AMThumbnailsOSGiCommands.class);
    @Reference
    private AMImageConfigurationHelper _amImageConfigurationHelper;
    @Reference
    private AMImageEntryLocalService _amImageEntryLocalService;
    @Reference
    private AMImageMimeTypeProvider _amImageMimeTypeProvider;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private ImageTool _imageTool;

    public void check(String ... companyIds) {
        System.out.println("Company ID\t# of thumbnails pending migration");
        System.out.println("-------------------------------------------------");
        AtomicInteger count = new AtomicInteger();
        this._companyLocalService.forEachCompanyId(companyId -> this._countPendingThumbnails((Long)companyId, count));
        System.out.printf("%nTOTAL: %d%n", count.get());
    }

    public void cleanUp(String ... companyIds) {
        this._companyLocalService.forEachCompanyId(companyId -> this._cleanUp((long)companyId), this._getCompanyIds(companyIds));
    }

    public void migrate(String ... companyIds) throws PortalException {
        this._companyLocalService.forEachCompanyId(companyId -> this._migrate((Long)companyId), this._getCompanyIds(companyIds));
    }

    private void _cleanUp(long companyId) {
        try {
            String[] fileNames;
            for (String fileName : fileNames = DLStoreUtil.getFileNames((long)companyId, (long)0L, (String)"document_thumbnail/")) {
                String actualFileName = StringUtil.replace((String)fileName, (String)"//", (String)"/");
                for (ThumbnailConfiguration thumbnailConfiguration : this._getThumbnailConfigurations()) {
                    FileVersion fileVersion = this._getFileVersion(thumbnailConfiguration.getFileVersionId(actualFileName));
                    if (fileVersion == null) continue;
                    DLStoreUtil.deleteFile((long)companyId, (long)0L, (String)actualFileName);
                }
            }
        }
        catch (PortalException portalException) {
            this._processException(companyId, portalException);
        }
    }

    private void _countPendingThumbnails(Long companyId, AtomicInteger count) {
        try {
            String[] fileNames = DLStoreUtil.getFileNames((long)companyId, (long)0L, (String)"document_thumbnail/");
            int companyTotal = 0;
            for (String fileName : fileNames) {
                String actualFileName = StringUtil.replace((String)fileName, (String)"//", (String)"/");
                for (ThumbnailConfiguration thumbnailConfiguration : this._getThumbnailConfigurations()) {
                    FileVersion fileVersion = this._getFileVersion(thumbnailConfiguration.getFileVersionId(actualFileName));
                    if (fileVersion == null) continue;
                    companyTotal = 1;
                }
            }
            System.out.printf("%d\t\t%d%n", companyId, companyTotal);
            count.addAndGet(companyTotal);
        }
        catch (PortalException portalException) {
            this._processException(companyId, portalException);
        }
    }

    private long[] _getCompanyIds(String ... companyIds) {
        if (companyIds.length == 0) {
            return ListUtil.toLongArray((List)this._companyLocalService.getCompanies(), CompanyModel::getCompanyId);
        }
        return ListUtil.toLongArray(Arrays.asList(companyIds), Long::parseLong);
    }

    private FileVersion _getFileVersion(long fileVersionId) {
        try {
            if (fileVersionId == 0L) {
                return null;
            }
            FileVersion fileVersion = this._dlAppLocalService.getFileVersion(fileVersionId);
            if (!this._isMimeTypeSupported(fileVersion)) {
                return null;
            }
            return fileVersion;
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
            return null;
        }
    }

    private ThumbnailConfiguration[] _getThumbnailConfigurations() {
        return new ThumbnailConfiguration[]{new ThumbnailConfiguration(PrefsPropsUtil.getInteger((String)"dl.file.entry.thumbnail.max.width"), PrefsPropsUtil.getInteger((String)"dl.file.entry.thumbnail.max.height"), Pattern.compile("document_thumbnail/\\d+/\\d+(?:/\\d+)+/(\\d+)(?:\\..+)?$")), new ThumbnailConfiguration(PrefsPropsUtil.getInteger((String)"dl.file.entry.thumbnail.custom1.max.width"), PrefsPropsUtil.getInteger((String)"dl.file.entry.thumbnail.custom1.max.height"), Pattern.compile("document_thumbnail/\\d+/\\d+(?:/\\d+)+/(\\d+)-1(?:\\..+)?$")), new ThumbnailConfiguration(PrefsPropsUtil.getInteger((String)"dl.file.entry.thumbnail.custom2.max.width"), PrefsPropsUtil.getInteger((String)"dl.file.entry.thumbnail.custom2.max.height"), Pattern.compile("document_thumbnail/\\d+/\\d+(?:/\\d+)+/(\\d+)-2(?:\\..+)?$"))};
    }

    private boolean _isMimeTypeSupported(FileVersion fileVersion) {
        return ArrayUtil.contains((Object[])this._amImageMimeTypeProvider.getSupportedMimeTypes(), (Object)fileVersion.getMimeType());
    }

    private boolean _isValidConfigurationEntries(Collection<AMImageConfigurationEntry> amImageConfigurationEntries) {
        for (ThumbnailConfiguration thumbnailConfiguration : this._getThumbnailConfigurations()) {
            for (AMImageConfigurationEntry amImageConfigurationEntry : amImageConfigurationEntries) {
                if (!thumbnailConfiguration.matches(amImageConfigurationEntry)) continue;
                return true;
            }
        }
        return false;
    }

    private void _migrate(Long companyId) throws PortalException {
        Collection amImageConfigurationEntries = this._amImageConfigurationHelper.getAMImageConfigurationEntries(companyId.longValue());
        if (!this._isValidConfigurationEntries(amImageConfigurationEntries)) {
            throw new PortalException("No valid Adaptive Media configuration found. Please refer to the upgrade documentation for the details.");
        }
        try {
            String[] fileNames;
            for (String fileName : fileNames = DLStoreUtil.getFileNames((long)companyId, (long)0L, (String)"document_thumbnail/")) {
                String actualFileName = StringUtil.replace((String)fileName, (String)"//", (String)"/");
                for (ThumbnailConfiguration thumbnailConfiguration : this._getThumbnailConfigurations()) {
                    Optional<AMImageConfigurationEntry> amImageConfigurationEntryOptional = thumbnailConfiguration.selectMatchingConfigurationEntry(amImageConfigurationEntries);
                    amImageConfigurationEntryOptional.ifPresent(amImageConfigurationEntry -> this._migrate(actualFileName, (AMImageConfigurationEntry)amImageConfigurationEntry, thumbnailConfiguration));
                }
            }
        }
        catch (PortalException portalException) {
            this._processException(companyId, portalException);
        }
    }

    private void _migrate(String fileName, AMImageConfigurationEntry amImageConfigurationEntry, ThumbnailConfiguration thumbnailConfiguration) {
        try {
            FileVersion fileVersion = this._getFileVersion(thumbnailConfiguration.getFileVersionId(fileName));
            if (fileVersion == null) {
                return;
            }
            AMImageEntry amImageEntry = this._amImageEntryLocalService.fetchAMImageEntry(amImageConfigurationEntry.getUUID(), fileVersion.getFileVersionId());
            if (amImageEntry != null) {
                return;
            }
            byte[] bytes = DLStoreUtil.getFileAsBytes((long)fileVersion.getCompanyId(), (long)0L, (String)fileName);
            ImageBag imageBag = this._imageTool.read(bytes);
            RenderedImage renderedImage = imageBag.getRenderedImage();
            this._amImageEntryLocalService.addAMImageEntry(amImageConfigurationEntry, fileVersion, renderedImage.getHeight(), renderedImage.getWidth(), (InputStream)new UnsyncByteArrayInputStream(bytes), (long)bytes.length);
        }
        catch (PortalException | IOException exception) {
            _log.error(exception);
        }
    }

    private void _processException(Long companyId, PortalException portalException) {
        _log.error((Object)StringBundler.concat((Object[])new Object[]{"Processing company ", companyId, " failed with: ", portalException.getMessage()}), (Throwable)portalException);
    }
}

