/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.document.library.thumbnails.internal.osgi.commands;

import com.liferay.adaptive.media.document.library.thumbnails.internal.osgi.commands.configuration.ThumbnailConfiguration;
import com.liferay.adaptive.media.image.configuration.AMImageConfigurationEntry;
import com.liferay.adaptive.media.image.configuration.AMImageConfigurationHelper;
import com.liferay.adaptive.media.image.mime.type.AMImageMimeTypeProvider;
import com.liferay.adaptive.media.image.model.AMImageEntry;
import com.liferay.adaptive.media.image.service.AMImageEntryLocalService;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.kernel.store.DLStoreUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.image.ImageBag;
import com.liferay.portal.kernel.image.ImageToolUtil;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.CompanyModel;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"osgi.command.function=check", "osgi.command.function=cleanUp", "osgi.command.function=migrate", "osgi.command.scope=thumbnails"}, service={AMThumbnailsOSGiCommands.class})
public class AMThumbnailsOSGiCommands {
    private static final Log _log = LogFactoryUtil.getLog(AMThumbnailsOSGiCommands.class);
    @Reference
    private AMImageConfigurationHelper _amImageConfigurationHelper;
    @Reference
    private AMImageEntryLocalService _amImageEntryLocalService;
    @Reference
    private AMImageMimeTypeProvider _amImageMimeTypeProvider;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private DLAppLocalService _dlAppLocalService;

    public void check(String ... companyIds) {
        System.out.println("Company ID\t# of thumbnails pending migration");
        System.out.println("-------------------------------------------------");
        int total = 0;
        for (long companyId : this._getCompanyIds(companyIds)) {
            try {
                String[] fileNames = DLStoreUtil.getFileNames((long)companyId, (long)0L, (String)"document_thumbnail/");
                int companyTotal = 0;
                for (String fileName : fileNames) {
                    String actualFileName = StringUtil.replace((String)fileName, (String)"//", (String)"/");
                    for (ThumbnailConfiguration thumbnailConfiguration : this._getThumbnailConfigurations()) {
                        FileVersion fileVersion = this._getFileVersion(thumbnailConfiguration.getFileVersionId(actualFileName));
                        if (fileVersion == null) continue;
                        ++companyTotal;
                    }
                }
                System.out.printf("%d\t\t%d%n", companyId, companyTotal);
                total += companyTotal;
            }
            catch (Exception exception) {
                _log.error((Object)exception, (Throwable)exception);
            }
        }
        System.out.printf("%nTOTAL: %d%n", total);
    }

    public void cleanUp(String ... companyIds) {
        for (long companyId : this._getCompanyIds(companyIds)) {
            try {
                String[] fileNames;
                for (String fileName : fileNames = DLStoreUtil.getFileNames((long)companyId, (long)0L, (String)"document_thumbnail/")) {
                    String actualFileName = StringUtil.replace((String)fileName, (String)"//", (String)"/");
                    for (ThumbnailConfiguration thumbnailConfiguration : this._getThumbnailConfigurations()) {
                        FileVersion fileVersion = this._getFileVersion(thumbnailConfiguration.getFileVersionId(actualFileName));
                        if (fileVersion == null) continue;
                        DLStoreUtil.deleteFile((long)companyId, (long)0L, (String)actualFileName);
                    }
                }
            }
            catch (Exception exception) {
                _log.error((Object)exception, (Throwable)exception);
            }
        }
    }

    public void migrate(String ... companyIds) throws PortalException {
        for (long companyId : this._getCompanyIds(companyIds)) {
            Collection amImageConfigurationEntries = this._amImageConfigurationHelper.getAMImageConfigurationEntries(companyId);
            if (!this._isValidConfigurationEntries(amImageConfigurationEntries)) {
                throw new PortalException("No valid Adaptive Media configuration found. Please refer to the upgrade documentation for the details.");
            }
            try {
                String[] fileNames;
                for (String fileName : fileNames = DLStoreUtil.getFileNames((long)companyId, (long)0L, (String)"document_thumbnail/")) {
                    String actualFileName = StringUtil.replace((String)fileName, (String)"//", (String)"/");
                    for (ThumbnailConfiguration thumbnailConfiguration : this._getThumbnailConfigurations()) {
                        Optional<AMImageConfigurationEntry> amImageConfigurationEntryOptional = thumbnailConfiguration.selectMatchingConfigurationEntry(amImageConfigurationEntries);
                        amImageConfigurationEntryOptional.ifPresent(amImageConfigurationEntry -> this._migrate(actualFileName, (AMImageConfigurationEntry)amImageConfigurationEntry, thumbnailConfiguration));
                    }
                }
            }
            catch (PortalException portalException) {
                _log.error((Object)portalException, (Throwable)portalException);
            }
        }
    }

    private Iterable<Long> _getCompanyIds(String ... companyIds) {
        if (companyIds.length == 0) {
            List companies = this._companyLocalService.getCompanies();
            Stream companyStream = companies.stream();
            return companyStream.map(CompanyModel::getCompanyId).collect(Collectors.toList());
        }
        Stream<String> companyIdStream = Arrays.stream(companyIds);
        return companyIdStream.map(Long::parseLong).collect(Collectors.toList());
    }

    private FileVersion _getFileVersion(long fileVersionId) {
        try {
            if (fileVersionId == 0L) {
                return null;
            }
            FileVersion fileVersion = this._dlAppLocalService.getFileVersion(fileVersionId);
            if (!this._isMimeTypeSupported(fileVersion)) {
                return null;
            }
            return fileVersion;
        }
        catch (PortalException portalException) {
            _log.error((Object)portalException, (Throwable)portalException);
            return null;
        }
    }

    private ThumbnailConfiguration[] _getThumbnailConfigurations() {
        return new ThumbnailConfiguration[]{new ThumbnailConfiguration(PrefsPropsUtil.getInteger((String)"dl.file.entry.thumbnail.max.width"), PrefsPropsUtil.getInteger((String)"dl.file.entry.thumbnail.max.height"), Pattern.compile("document_thumbnail/\\d+/\\d+(?:/\\d+)+/(\\d+)(?:\\..+)?$")), new ThumbnailConfiguration(PrefsPropsUtil.getInteger((String)"dl.file.entry.thumbnail.custom1.max.width"), PrefsPropsUtil.getInteger((String)"dl.file.entry.thumbnail.custom1.max.height"), Pattern.compile("document_thumbnail/\\d+/\\d+(?:/\\d+)+/(\\d+)-1(?:\\..+)?$")), new ThumbnailConfiguration(PrefsPropsUtil.getInteger((String)"dl.file.entry.thumbnail.custom2.max.width"), PrefsPropsUtil.getInteger((String)"dl.file.entry.thumbnail.custom2.max.height"), Pattern.compile("document_thumbnail/\\d+/\\d+(?:/\\d+)+/(\\d+)-2(?:\\..+)?$"))};
    }

    private boolean _isMimeTypeSupported(FileVersion fileVersion) {
        return ArrayUtil.contains((Object[])this._amImageMimeTypeProvider.getSupportedMimeTypes(), (Object)fileVersion.getMimeType());
    }

    private boolean _isValidConfigurationEntries(Collection<AMImageConfigurationEntry> amImageConfigurationEntries) {
        Stream<ThumbnailConfiguration> thumbnailConfigurationStream = Arrays.stream(this._getThumbnailConfigurations());
        return thumbnailConfigurationStream.anyMatch(thumbnailConfiguration -> {
            Stream amImageConfigurationEntryStream = amImageConfigurationEntries.stream();
            return amImageConfigurationEntryStream.anyMatch(thumbnailConfiguration::matches);
        });
    }

    private void _migrate(String fileName, AMImageConfigurationEntry amImageConfigurationEntry, ThumbnailConfiguration thumbnailConfiguration) {
        try {
            FileVersion fileVersion = this._getFileVersion(thumbnailConfiguration.getFileVersionId(fileName));
            if (fileVersion == null) {
                return;
            }
            AMImageEntry amImageEntry = this._amImageEntryLocalService.fetchAMImageEntry(amImageConfigurationEntry.getUUID(), fileVersion.getFileVersionId());
            if (amImageEntry != null) {
                return;
            }
            byte[] bytes = DLStoreUtil.getFileAsBytes((long)fileVersion.getCompanyId(), (long)0L, (String)fileName);
            ImageBag imageBag = ImageToolUtil.read((byte[])bytes);
            RenderedImage renderedImage = imageBag.getRenderedImage();
            this._amImageEntryLocalService.addAMImageEntry(amImageConfigurationEntry, fileVersion, renderedImage.getHeight(), renderedImage.getWidth(), (InputStream)new UnsyncByteArrayInputStream(bytes), (long)bytes.length);
        }
        catch (PortalException | IOException exception) {
            _log.error((Object)exception, exception);
        }
    }
}

