/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.xss;

import com.h3xstream.findsecbugs.FindSecBugsGlobalConfig;
import com.h3xstream.findsecbugs.common.InterfaceUtils;
import com.h3xstream.findsecbugs.injection.BasicInjectionDetector;
import com.h3xstream.findsecbugs.taintanalysis.Taint;
import com.h3xstream.findsecbugs.xss.XssJspDetector;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ba.ClassContext;
import org.apache.bcel.generic.ConstantPoolGen;

public class XssServletDetector
extends BasicInjectionDetector {
    private static final String XSS_SERVLET_TYPE = "XSS_SERVLET";
    private static final String[] REQUIRED_CLASSES = new String[]{"Ljavax/servlet/http/ServletResponse;", "Ljavax/servlet/http/ServletResponseWrapper;", "Ljavax/servlet/http/HttpServletResponse;", "Ljavax/servlet/http/HttpServletResponseWrapper;", "Lorg/apache/jetspeed/portlet/PortletResponse;", "Lorg/apache/jetspeed/portlet/PortletResponseWrapper;", "Ljavax/portlet/RenderResponse;", "Ljavax/portlet/MimeResponse;", "Ljavax/portlet/filter/RenderResponseWrapper;", "Ljavax/portlet/PortletResponse;", "Ljavax/portlet/ActionResponseWrapper;", "Ljavax/portlet/EventResponseWrapper;", "Ljavax/portlet/PortletResponseWrapper;", "Ljavax/portlet/RenderResponseWrapper;", "Ljavax/portlet/ResourceResponseWrapper;"};

    public XssServletDetector(BugReporter bugReporter) {
        super(bugReporter);
        this.loadConfiguredSinks("xss-servlet.txt", XSS_SERVLET_TYPE);
    }

    @Override
    protected int getPriority(Taint taint) {
        if (!taint.isSafe() && taint.hasTag(Taint.Tag.XSS_SAFE)) {
            if (FindSecBugsGlobalConfig.getInstance().isReportPotentialXssWrongContext()) {
                return 3;
            }
            return 5;
        }
        if (!taint.isSafe() && (taint.hasTag(Taint.Tag.QUOTE_ENCODED) || taint.hasTag(Taint.Tag.APOSTROPHE_ENCODED)) && taint.hasTag(Taint.Tag.LT_ENCODED)) {
            return 3;
        }
        return super.getPriority(taint);
    }

    @Override
    public boolean shouldAnalyzeClass(ClassContext classContext) {
        ConstantPoolGen constantPoolGen = classContext.getConstantPoolGen();
        for (String requiredClass : REQUIRED_CLASSES) {
            if (constantPoolGen.lookupUtf8(requiredClass) == -1) continue;
            String className = classContext.getClassDescriptor().getDottedClassName();
            return !InterfaceUtils.isSubtype(className, XssJspDetector.JSP_PARENT_CLASSES);
        }
        return false;
    }
}

