/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs;

import com.h3xstream.findsecbugs.common.ByteCode;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import java.util.Iterator;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.LDC;

public class PermissiveCORSDetector
implements Detector {
    private static final String PERMISSIVE_CORS = "PERMISSIVE_CORS";
    private BugReporter bugReporter;

    public PermissiveCORSDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        JavaClass javaClass = classContext.getJavaClass();
        for (Method m : methodList = javaClass.getMethods()) {
            try {
                this.analyzeMethod(m, classContext);
            }
            catch (CFGBuilderException cFGBuilderException) {
            }
            catch (DataflowAnalysisException dataflowAnalysisException) {
                // empty catch block
            }
        }
    }

    private void analyzeMethod(Method m, ClassContext classContext) throws CFGBuilderException, DataflowAnalysisException {
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        CFG cfg = classContext.getCFG(m);
        Iterator i = cfg.locationIterator();
        while (i.hasNext()) {
            LDC ldc;
            Location location = (Location)i.next();
            Instruction inst = location.getHandle().getInstruction();
            if (!(inst instanceof INVOKEINTERFACE)) continue;
            INVOKEINTERFACE invoke = (INVOKEINTERFACE)inst;
            String methodName = invoke.getMethodName(cpg);
            String className = invoke.getClassName(cpg);
            if (!className.equals("javax.servlet.http.HttpServletResponse") || !methodName.equals("addHeader") && !methodName.equals("setHeader") || (ldc = ByteCode.getPrevInstruction(location.getHandle().getPrev(), LDC.class)) == null) continue;
            String headerValue = ByteCode.getConstantLDC(location.getHandle().getPrev(), cpg, String.class);
            if (!"Access-Control-Allow-Origin".equalsIgnoreCase((String)ldc.getValue(cpg)) || !headerValue.contains("*") && !"null".equalsIgnoreCase(headerValue)) continue;
            JavaClass clz = classContext.getJavaClass();
            this.bugReporter.reportBug(new BugInstance((Detector)this, PERMISSIVE_CORS, 1).addClass(clz).addMethod(clz, m).addSourceLine(classContext, m, location));
        }
    }

    public void report() {
    }
}

