/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.taintanalysis;

import com.h3xstream.findsecbugs.FindSecBugsGlobalConfig;
import com.h3xstream.findsecbugs.taintanalysis.TaintAnalysis;
import com.h3xstream.findsecbugs.taintanalysis.TaintConfig;
import com.h3xstream.findsecbugs.taintanalysis.TaintDataflow;
import com.h3xstream.findsecbugs.taintanalysis.TaintMethodConfig;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.IMethodAnalysisEngine;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.io.IO;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.bcel.generic.MethodGen;

public class TaintDataflowEngine
implements IMethodAnalysisEngine<TaintDataflow> {
    private static final FindSecBugsGlobalConfig CONFIG = FindSecBugsGlobalConfig.getInstance();
    private static final Logger LOGGER = Logger.getLogger(TaintDataflowEngine.class.getName());
    private static final String TAINT_CONFIG_PATH = "taint-config/";
    private static final String[] TAINT_CONFIG_FILENAMES = new String[]{"java-lang.txt", "java-ee.txt", "collections.txt", "java-net.txt", "scala.txt", "logging.txt", "other.txt", "portlet.txt"};
    private static final String SAFE_ENCODERS_PATH = "safe-encoders/";
    private static final String[] SAFE_ENCODERS_FILENAMES = new String[]{"owasp.txt", "apache-commons.txt", "other.txt"};
    private final TaintConfig taintConfig = new TaintConfig();
    private static Writer writer = null;

    public TaintDataflowEngine() {
        String customConfigFile;
        for (String path : TAINT_CONFIG_FILENAMES) {
            this.loadTaintConfig(TAINT_CONFIG_PATH.concat(path), true);
        }
        for (String path : SAFE_ENCODERS_FILENAMES) {
            this.loadTaintConfig(SAFE_ENCODERS_PATH.concat(path), true);
        }
        this.loadTaintConfig(TAINT_CONFIG_PATH.concat("taint-sensitive-data.txt"), false);
        if (CONFIG.isTaintedSystemVariables()) {
            this.loadTaintConfig(TAINT_CONFIG_PATH.concat("tainted-system-variables.txt"), false);
            LOGGER.info("System variables are considered to be tainted");
        }
        if ((customConfigFile = CONFIG.getCustomConfigFile()) != null && !customConfigFile.isEmpty()) {
            for (String configFile : customConfigFile.split(File.pathSeparator)) {
                this.addCustomConfig(configFile);
            }
        }
        if (!CONFIG.isTaintedMainArgument()) {
            LOGGER.info("The argument of the main method is not considered tainted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTaintConfig(String path, boolean checkRewrite) {
        assert (path != null && !path.isEmpty());
        InputStream stream = null;
        try {
            stream = this.getClass().getClassLoader().getResourceAsStream(path);
            this.taintConfig.load(stream, checkRewrite);
        }
        catch (IOException ex) {
            block5: {
                try {
                    if ($assertionsDisabled) break block5;
                    throw new AssertionError((Object)ex.getMessage());
                }
                catch (Throwable throwable) {
                    IO.close(stream);
                    throw throwable;
                }
            }
            IO.close((InputStream)stream);
        }
        IO.close((InputStream)stream);
    }

    private void addCustomConfig(String path) {
        InputStream stream = null;
        try {
            File file = new File(path);
            stream = file.exists() ? new FileInputStream(file) : this.getClass().getClassLoader().getResourceAsStream(path);
            if (stream == null) {
                String message = String.format("Could not add custom config. Neither file %s nor resource matching %s found.", file.getAbsolutePath(), path);
                throw new IllegalArgumentException(message);
            }
            this.taintConfig.load(stream, false);
            LOGGER.log(Level.INFO, "Custom taint config loaded from {0}", path);
        }
        catch (IOException ex) {
            try {
                throw new RuntimeException("Cannot load custom taint config from " + path, ex);
            }
            catch (Throwable throwable) {
                IO.close(stream);
                throw throwable;
            }
        }
        IO.close((InputStream)stream);
    }

    public TaintDataflow analyze(IAnalysisCache cache, MethodDescriptor descriptor) throws CheckedAnalysisException {
        TaintMethodConfig derivedConfig;
        if (FindSecBugsGlobalConfig.getInstance().isDebugPrintInstructionVisited() || FindSecBugsGlobalConfig.getInstance().isDebugPrintInvocationVisited()) {
            System.out.println("==[ Method: " + descriptor.getName() + " ]==");
        }
        CFG cfg = (CFG)cache.getMethodAnalysis(CFG.class, descriptor);
        DepthFirstSearch dfs = (DepthFirstSearch)cache.getMethodAnalysis(DepthFirstSearch.class, descriptor);
        MethodGen methodGen = (MethodGen)cache.getMethodAnalysis(MethodGen.class, descriptor);
        TaintAnalysis analysis = new TaintAnalysis(methodGen, dfs, descriptor, this.taintConfig);
        TaintDataflow flow = new TaintDataflow(cfg, analysis);
        flow.execute();
        analysis.finishAnalysis();
        if (CONFIG.isDebugOutputTaintConfigs() && writer != null && (derivedConfig = (TaintMethodConfig)this.taintConfig.get(TaintDataflowEngine.getSlashedMethodName(methodGen))) != null) {
            try {
                writer.append(TaintDataflowEngine.getSlashedMethodName(methodGen) + ":" + derivedConfig + "\n");
                writer.flush();
            }
            catch (IOException ex) {
                AnalysisContext.logError((String)"Cannot write derived configs", (Exception)ex);
            }
        }
        return flow;
    }

    private static String getSlashedMethodName(MethodGen methodGen) {
        String methodNameWithSignature = methodGen.getName() + methodGen.getSignature();
        String slashedClassName = methodGen.getClassName().replace('.', '/');
        return slashedClassName + "." + methodNameWithSignature;
    }

    public void registerWith(IAnalysisCache iac) {
        iac.registerMethodAnalysisEngine(TaintDataflow.class, (IMethodAnalysisEngine)this);
    }

    static {
        if (CONFIG.isDebugOutputTaintConfigs()) {
            try {
                String fileName = "derived-config.txt";
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("derived-config.txt"), "utf-8"));
                LOGGER.info("Derived method configs will be output to derived-config.txt");
            }
            catch (UnsupportedEncodingException ex) {
                assert (false) : ex.getMessage();
            }
            catch (FileNotFoundException ex) {
                AnalysisContext.logError((String)"File for derived configs cannot be created or opened", (Exception)ex);
            }
        }
    }
}

