/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.common.matcher;

import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import java.util.ArrayList;
import java.util.List;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InvokeInstruction;

public class InvokeMatcherBuilder {
    private List<String> classesNames = new ArrayList<String>();
    private List<String> methodNames = new ArrayList<String>();
    private List<String> argSignatures = new ArrayList<String>();

    public InvokeMatcherBuilder atClass(String ... classesNames) {
        for (String clz : classesNames) {
            this.classesNames.add(clz.replace('/', '.'));
        }
        return this;
    }

    public InvokeMatcherBuilder atMethod(String ... methodNames) {
        for (String method : methodNames) {
            this.methodNames.add(method);
        }
        return this;
    }

    public InvokeMatcherBuilder withArgs(String ... argSignatures) {
        for (String method : argSignatures) {
            this.argSignatures.add(method);
        }
        return this;
    }

    public boolean matches(OpcodeStackDetector opcodeStackDetector) {
        if (this.classesNames.size() != 0 && !this.classesNames.contains(opcodeStackDetector.getClassConstantOperand().replace('/', '.'))) {
            return false;
        }
        if (this.methodNames.size() != 0 && !this.methodNames.contains(opcodeStackDetector.getNameConstantOperand())) {
            return false;
        }
        return this.argSignatures.size() == 0 || this.argSignatures.contains(opcodeStackDetector.getSigConstantOperand());
    }

    public boolean matches(Instruction instruction, ConstantPoolGen cpg) {
        if (instruction instanceof InvokeInstruction) {
            InvokeInstruction invokeInstruction = (InvokeInstruction)instruction;
            if (invokeInstruction != null) {
                if (this.classesNames.size() != 0 && !this.classesNames.contains(invokeInstruction.getClassName(cpg))) {
                    return false;
                }
                if (this.methodNames.size() != 0 && !this.methodNames.contains(invokeInstruction.getMethodName(cpg))) {
                    return false;
                }
                if (this.argSignatures.size() != 0 && !this.argSignatures.contains(invokeInstruction.getSignature(cpg))) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}

