/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.scala;

import com.h3xstream.findsecbugs.FindSecBugsGlobalConfig;
import com.h3xstream.findsecbugs.injection.BasicInjectionDetector;
import com.h3xstream.findsecbugs.taintanalysis.Taint;
import com.h3xstream.findsecbugs.taintanalysis.TaintFrame;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;

public class XssMvcApiDetector
extends BasicInjectionDetector {
    private static final String SCALA_XSS_MVC_API_TYPE = "SCALA_XSS_MVC_API";
    private final String VULNERABLE_CONTENT_TYPE = "text/html";

    public XssMvcApiDetector(BugReporter bugReporter) {
        super(bugReporter);
        this.loadConfiguredSinks("xss-scala-mvc-api.txt", SCALA_XSS_MVC_API_TYPE);
    }

    @Override
    protected int getPriorityFromTaintFrame(TaintFrame fact, int offset) throws DataflowAnalysisException {
        Taint parameterTaint;
        Taint mvcResultTaint = (Taint)fact.getStackValue(offset);
        if (!(mvcResultTaint.isSafe() || (parameterTaint = (Taint)fact.getStackValue(0)).isSafe() && !"text/html".equalsIgnoreCase(parameterTaint.getConstantValue()))) {
            return this.getPriority(mvcResultTaint);
        }
        return 5;
    }

    @Override
    protected int getPriority(Taint taint) {
        if (!taint.isSafe() && taint.hasTag(Taint.Tag.XSS_SAFE)) {
            if (FindSecBugsGlobalConfig.getInstance().isReportPotentialXssWrongContext()) {
                return 3;
            }
            return 5;
        }
        if (!taint.isSafe() && (taint.hasTag(Taint.Tag.QUOTE_ENCODED) || taint.hasTag(Taint.Tag.APOSTROPHE_ENCODED)) && taint.hasTag(Taint.Tag.LT_ENCODED)) {
            return 3;
        }
        return super.getPriority(taint);
    }
}

