/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.project.templates.client.extension.internal;

import com.liferay.blade.cli.util.BladeUtil;
import com.liferay.blade.cli.util.FileUtil;
import com.liferay.blade.cli.util.OSDetector;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public class LXCUtil {
    private static String _lxcVersion = "0.0.6";

    public static Path downloadLxc() throws Exception {
        Path bladeCachePath = BladeUtil.getBladeCachePath();
        String lxcURL = LXCUtil._getLxcURL();
        String lxcFileName = lxcURL.substring(lxcURL.lastIndexOf("/") + 1);
        Path lxcDownloadPath = bladeCachePath.resolve(lxcFileName);
        Path lxcDirPath = bladeCachePath.resolve("lxc");
        String lxcChecksumURL = lxcURL + ".checksum";
        String checksumFileName = lxcChecksumURL.substring(lxcChecksumURL.lastIndexOf("/") + 1);
        Path checksumDownloadPath = BladeUtil.downloadFile((String)lxcChecksumURL, (Path)bladeCachePath, (String)checksumFileName);
        if (Files.exists(lxcDirPath, new LinkOption[0]) && Files.exists(checksumDownloadPath, new LinkOption[0]) && Files.exists(lxcDownloadPath, new LinkOption[0]) && !LXCUtil._validChecksum(checksumDownloadPath, lxcDownloadPath)) {
            Files.delete(checksumDownloadPath);
            Files.delete(lxcDownloadPath);
            FileUtil.deleteDir((Path)lxcDirPath);
        }
        if (!(Files.exists(lxcDirPath, new LinkOption[0]) && LXCUtil._containsFiles(lxcDirPath) && Files.exists(checksumDownloadPath, new LinkOption[0]) && Files.exists(lxcDownloadPath, new LinkOption[0]))) {
            Files.createDirectories(lxcDirPath, new FileAttribute[0]);
            checksumDownloadPath = BladeUtil.downloadFile((String)lxcChecksumURL, (Path)bladeCachePath, (String)checksumFileName);
            lxcDownloadPath = BladeUtil.downloadFile((String)lxcURL, (Path)bladeCachePath, (String)lxcFileName);
            if (!LXCUtil._validChecksum(checksumDownloadPath, lxcDownloadPath)) {
                Files.delete(checksumDownloadPath);
                Files.delete(lxcDownloadPath);
                FileUtil.deleteDir((Path)lxcDirPath);
                throw new IOException("Downloaded checksum failed, please try again");
            }
            FileUtil.unpack((Path)lxcDownloadPath, (Path)lxcDirPath, (int)1);
            if (OSDetector.isWindows()) {
                Path lxcPath;
                try (Stream<Path> paths = Files.list(lxcDirPath);){
                    Optional<Path> findFirst = paths.findFirst();
                    lxcPath = findFirst.get();
                }
                paths = Files.list(lxcPath);
                var10_9 = null;
                try {
                    paths.forEach(path -> {
                        try {
                            Files.move(path, lxcDirPath.resolve(path.getFileName()), StandardCopyOption.REPLACE_EXISTING);
                        }
                        catch (IOException ioException) {
                            throw new RuntimeException(ioException);
                        }
                    });
                }
                catch (Throwable throwable) {
                    var10_9 = throwable;
                    throw throwable;
                }
                finally {
                    if (paths != null) {
                        if (var10_9 != null) {
                            try {
                                paths.close();
                            }
                            catch (Throwable throwable) {
                                var10_9.addSuppressed(throwable);
                            }
                        } else {
                            paths.close();
                        }
                    }
                }
                Files.delete(lxcPath);
            } else {
                Files.setPosixFilePermissions(lxcDirPath.resolve("lxc"), PosixFilePermissions.fromString("rwxrwxr--"));
                Files.setPosixFilePermissions(lxcDirPath.resolve("lxc"), PosixFilePermissions.fromString("rwxrwxr--"));
            }
        }
        return lxcDirPath.resolve("lxc");
    }

    public static int run(Path dir, String[] args, Map<String, String> env, boolean quiet) throws Exception {
        Path lxcPath = LXCUtil.downloadLxc();
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.directory(dir.toFile());
        ArrayList<String> commands = new ArrayList<String>();
        if (OSDetector.isWindows()) {
            commands.add("cmd.exe");
            commands.add("/c");
            commands.add(lxcPath.toString());
            for (String arg : args) {
                commands.add(arg);
            }
        } else {
            commands.add("sh");
            commands.add("-c");
            StringBuilder command = new StringBuilder();
            command.append("\"");
            command.append(lxcPath.toString());
            command.append("\" ");
            for (String arg : args) {
                command.append("\"");
                command.append(arg);
                command.append("\" ");
            }
            commands.add(command.toString());
        }
        processBuilder.command(commands);
        if (!quiet) {
            processBuilder.inheritIO();
        }
        if (dir != null && Files.exists(dir, new LinkOption[0])) {
            processBuilder.directory(dir.toFile());
        }
        env.forEach(processBuilder.environment()::put);
        Process process = processBuilder.start();
        OutputStream outputStream = process.getOutputStream();
        outputStream.close();
        return process.waitFor();
    }

    private static boolean _containsFiles(Path path) throws Exception {
        try (Stream<Path> files = Files.list(path);){
            if (files.count() > 0L) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    private static String _createSha256(File file) throws Exception {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            byte[] buffer = new byte[8192];
            int read = 0;
            while (read != -1) {
                read = ((InputStream)fileInputStream).read(buffer);
                if (read <= 0) continue;
                messageDigest.update(buffer, 0, read);
            }
        }
        BigInteger bigInteger = new BigInteger(1, messageDigest.digest());
        return bigInteger.toString(16);
    }

    private static String _getLxcURL() {
        StringBuilder sb = new StringBuilder();
        sb.append("https://github.com/ipeychev/lxc-cli-release/releases/download/");
        sb.append(_lxcVersion);
        sb.append("/lxc-");
        String os = "linux";
        if (OSDetector.isApple()) {
            os = "macos";
        } else if (OSDetector.isWindows()) {
            os = "win";
        }
        sb.append(os);
        sb.append(".tgz");
        return sb.toString();
    }

    private static boolean _validChecksum(Path checksumPath, Path downloadPath) throws Exception {
        String content = FileUtil.read((File)checksumPath.toFile());
        String checksum = content.trim();
        String sha256 = LXCUtil._createSha256(downloadPath.toFile());
        return checksum.equals(sha256);
    }
}

