/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.project.templates.client.extension.internal;

import com.liferay.blade.cli.gradle.GradleWorkspaceProvider;
import com.liferay.blade.cli.util.BladeUtil;
import com.liferay.blade.cli.util.ProductInfo;
import com.liferay.project.templates.client.extension.internal.ClientExtensionProjectTemplatesArgsExt;
import com.liferay.project.templates.client.extension.internal.LXCUtil;
import com.liferay.project.templates.extensions.ProjectTemplateCustomizer;
import com.liferay.project.templates.extensions.ProjectTemplatesArgs;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.maven.archetype.ArchetypeGenerationRequest;
import org.apache.maven.archetype.ArchetypeGenerationResult;
import org.json.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.parser.Parser;

public class ClientExtensionProjectTemplateCustomizer
implements ProjectTemplateCustomizer {
    private static final String _BASE_BOM_URL = "https://repository.liferay.com/nexus/content/groups/public/com/liferay/portal/";

    public static Optional<String> getExtensionMetadataFile(File destinationDir) throws IOException {
        GradleWorkspaceProvider gradleWorkspaceProvider = new GradleWorkspaceProvider();
        if (gradleWorkspaceProvider.isWorkspace(destinationDir)) {
            File workspaceDir = gradleWorkspaceProvider.getWorkspaceDir(destinationDir);
            String product = gradleWorkspaceProvider.getProduct(workspaceDir);
            return Optional.ofNullable(gradleWorkspaceProvider.getGradleProperties(workspaceDir)).map(properties -> properties.getProperty("liferay.workspace.product")).map(ClientExtensionProjectTemplateCustomizer::_getTargetPlatformVersionFromProduct).map(targetPlatformVersion -> "https://repository.liferay.com/nexus/content/groups/public/com/liferay/portal/release." + product + ".bom/" + targetPlatformVersion + "/release." + product + ".bom-" + targetPlatformVersion + ".pom").map(ClientExtensionProjectTemplateCustomizer::_getCETAPIJarFromBom);
        }
        return Optional.empty();
    }

    public String getTemplateName() {
        return "client-extension";
    }

    public void onAfterGenerateProject(ProjectTemplatesArgs projectTemplatesArgs, File destinationDir, ArchetypeGenerationResult archetypeGenerationResult) throws Exception {
    }

    public void onBeforeGenerateProject(ProjectTemplatesArgs projectTemplatesArgs, ArchetypeGenerationRequest archetypeGenerationRequest) throws Exception {
        String extensionType;
        String projectName = projectTemplatesArgs.getName();
        ArrayList<String> args = new ArrayList<String>();
        args.add("generate");
        args.add("-i");
        args.add(projectName);
        ClientExtensionProjectTemplatesArgsExt clientExtensionTemplateExt = (ClientExtensionProjectTemplatesArgsExt)projectTemplatesArgs.getProjectTemplatesArgsExt();
        String extensionName = clientExtensionTemplateExt.getExtensionName();
        if (extensionName != null) {
            args.add("-n");
            args.add(extensionName);
        }
        if ((extensionType = clientExtensionTemplateExt.getExtensionType()) != null) {
            args.add("-t");
            args.add(extensionType);
        }
        File destinationDir = projectTemplatesArgs.getDestinationDir();
        Optional<String> extensionMetadataFile = ClientExtensionProjectTemplateCustomizer.getExtensionMetadataFile(destinationDir);
        LXCUtil.run(destinationDir.toPath(), args.toArray(new String[0]), extensionMetadataFile.map(value -> Collections.singletonMap("EXTENSION_METADATA_FILE", value)).orElse(Collections.emptyMap()), false);
    }

    private static String _getCETAPIJarFromBom(String bomUrl) {
        try {
            String version = Jsoup.connect((String)bomUrl).parser(Parser.xmlParser()).get().select("artifactId:contains(com.liferay.client.extension.type.api)").last().parent().select("version").last().text();
            return "https://repository-cdn.liferay.com/nexus/service/local/repositories/liferay-public-releases/content/com/liferay/com.liferay.client.extension.type.api/" + version + "/com.liferay.client.extension.type.api-" + version + ".jar";
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String _getTargetPlatformVersionFromProduct(String productKey) {
        try {
            File userHomeDir = new File(System.getProperty("user.home"));
            userHomeDir = userHomeDir.getCanonicalFile();
            Path userHomePath = userHomeDir.toPath();
            Path productInfoPath = userHomePath.resolve(".liferay/workspace/.product_info.json");
            if (!Files.exists(productInfoPath, new LinkOption[0])) {
                Map productInfos = BladeUtil.getProductInfos();
                ProductInfo productInfo = new ProductInfo((Map)productInfos.get(productKey));
                return productInfo.getTargetPlatformVersion();
            }
            JSONObject jsonObject = new JSONObject(new String(Files.readAllBytes(productInfoPath.normalize())));
            return Optional.ofNullable(jsonObject.get(productKey)).map(JSONObject.class::cast).map(info -> info.get("targetPlatformVersion")).map(Object::toString).orElse(null);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

