/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.provider.model.internal;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.Project;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.internal.Factory;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.tooling.provider.model.ParameterizedToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;
import org.gradle.tooling.provider.model.UnknownModelException;

public class DefaultToolingModelBuilderRegistry
implements ToolingModelBuilderRegistry {
    private final ToolingModelBuilderRegistry parent;
    private final List<ToolingModelBuilder> builders = new ArrayList<ToolingModelBuilder>();
    private final BuildOperationExecutor buildOperationExecutor;
    private final ProjectStateRegistry projectStateRegistry;

    public DefaultToolingModelBuilderRegistry(BuildOperationExecutor buildOperationExecutor, ProjectStateRegistry projectStateRegistry) {
        this(buildOperationExecutor, projectStateRegistry, null);
        this.register(new VoidToolingModelBuilder());
    }

    public DefaultToolingModelBuilderRegistry(BuildOperationExecutor buildOperationExecutor, ProjectStateRegistry projectStateRegistry, ToolingModelBuilderRegistry parent) {
        this.buildOperationExecutor = buildOperationExecutor;
        this.projectStateRegistry = projectStateRegistry;
        this.parent = parent;
    }

    @Override
    public void register(ToolingModelBuilder builder) {
        this.builders.add(builder);
    }

    @Override
    public ToolingModelBuilder getBuilder(String modelName) throws UnsupportedOperationException {
        ToolingModelBuilder match = null;
        for (ToolingModelBuilder builder : this.builders) {
            if (!builder.canBuild(modelName)) continue;
            if (match != null) {
                throw new UnsupportedOperationException(String.format("Multiple builders are available to build a model of type '%s'.", modelName));
            }
            match = builder;
        }
        if (match != null) {
            if (match instanceof ParameterizedToolingModelBuilder) {
                return new ParameterizedBuildOperationWrappingToolingModelBuilder((ParameterizedToolingModelBuilder)match);
            }
            return new BuildOperationWrappingToolingModelBuilder(match);
        }
        if (this.parent != null) {
            return this.parent.getBuilder(modelName);
        }
        throw new UnknownModelException(String.format("No builders are available to build a model of type '%s'.", modelName));
    }

    private static class VoidToolingModelBuilder
    implements ToolingModelBuilder {
        private VoidToolingModelBuilder() {
        }

        @Override
        public boolean canBuild(String modelName) {
            return modelName.equals(Void.class.getName());
        }

        @Override
        public Object buildAll(String modelName, Project project) {
            return null;
        }
    }

    private class ParameterizedBuildOperationWrappingToolingModelBuilder<T>
    extends BuildOperationWrappingToolingModelBuilder
    implements ParameterizedToolingModelBuilder<T> {
        private final ParameterizedToolingModelBuilder<T> delegate;

        private ParameterizedBuildOperationWrappingToolingModelBuilder(ParameterizedToolingModelBuilder delegate) {
            super(delegate);
            this.delegate = delegate;
        }

        @Override
        public boolean canBuild(String modelName) {
            return this.delegate.canBuild(modelName);
        }

        @Override
        public Object buildAll(final String modelName, final T parameter, final Project project) {
            return DefaultToolingModelBuilderRegistry.this.buildOperationExecutor.call(new CallableBuildOperation<Object>(){

                @Override
                public Object call(BuildOperationContext context) {
                    return DefaultToolingModelBuilderRegistry.this.projectStateRegistry.withLenientState((Factory)new Factory<Object>(){

                        @Override
                        @Nullable
                        public Object create() {
                            return ParameterizedBuildOperationWrappingToolingModelBuilder.this.delegate.buildAll(modelName, parameter, project);
                        }
                    });
                }

                @Override
                public BuildOperationDescriptor.Builder description() {
                    return BuildOperationDescriptor.displayName("Build parameterized model '" + modelName + "' for " + project.getDisplayName()).progressDisplayName("Building parameterized model '" + modelName + "'");
                }
            });
        }

        @Override
        public Class<T> getParameterType() {
            return this.delegate.getParameterType();
        }
    }

    private class BuildOperationWrappingToolingModelBuilder
    implements ToolingModelBuilder {
        private final ToolingModelBuilder delegate;

        private BuildOperationWrappingToolingModelBuilder(ToolingModelBuilder delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean canBuild(String modelName) {
            return this.delegate.canBuild(modelName);
        }

        @Override
        public Object buildAll(final String modelName, final Project project) {
            return DefaultToolingModelBuilderRegistry.this.buildOperationExecutor.call(new CallableBuildOperation<Object>(){

                @Override
                public Object call(BuildOperationContext context) {
                    return DefaultToolingModelBuilderRegistry.this.projectStateRegistry.withLenientState((Factory)new Factory<Object>(){

                        @Override
                        @Nullable
                        public Object create() {
                            return BuildOperationWrappingToolingModelBuilder.this.delegate.buildAll(modelName, project);
                        }
                    });
                }

                @Override
                public BuildOperationDescriptor.Builder description() {
                    return BuildOperationDescriptor.displayName("Build model '" + modelName + "' for " + project.getDisplayName()).progressDisplayName("Building model '" + modelName + "'");
                }
            });
        }
    }
}

