/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.gradle.internal.classpath.AccessTrackingSet;
import org.gradle.internal.classpath.AccessTrackingUtils;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.impldep.com.google.common.collect.ForwardingMap;

class AccessTrackingEnvMap
extends ForwardingMap<String, String> {
    private final Map<String, String> delegate;
    private final BiConsumer<? super String, ? super String> onAccess;

    public AccessTrackingEnvMap(BiConsumer<String, String> onAccess) {
        this(System.getenv(), onAccess);
    }

    @VisibleForTesting
    AccessTrackingEnvMap(Map<String, String> delegate, BiConsumer<? super String, ? super String> onAccess) {
        this.delegate = delegate;
        this.onAccess = onAccess;
    }

    @Override
    public String get(@Nullable Object key) {
        return this.getAndReport(key);
    }

    @Override
    public String getOrDefault(@Nullable Object key, String defaultValue) {
        String value = this.getAndReport(key);
        if (value == null && !this.delegate.containsKey(key)) {
            return defaultValue;
        }
        return value;
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        return this.getAndReport(key) != null;
    }

    @Override
    public Set<String> keySet() {
        return new AccessTrackingSet<String>(super.keySet(), this.trackingListener());
    }

    private String getAndReport(@Nullable Object key) {
        String result = this.delegate.get(key);
        this.onAccess.accept((String)key, result);
        return result;
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return new AccessTrackingSet<Map.Entry<String, String>>(this.delegate.entrySet(), this.entrySetTrackingListener());
    }

    private void onAccessEntrySetElement(@Nullable Object potentialEntry) {
        Map.Entry<String, String> entry = AccessTrackingUtils.tryConvertingToTrackableEntry(potentialEntry);
        if (entry != null) {
            this.getAndReport(entry.getKey());
        }
    }

    @Override
    public void forEach(BiConsumer<? super String, ? super String> action) {
        this.reportAggregatingAccess();
        this.delegate.forEach(action);
    }

    @Override
    public int size() {
        this.reportAggregatingAccess();
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        this.reportAggregatingAccess();
        return this.delegate.isEmpty();
    }

    @Override
    public boolean equals(@Nullable Object object) {
        this.reportAggregatingAccess();
        return this.delegate.equals(object);
    }

    @Override
    public int hashCode() {
        this.reportAggregatingAccess();
        return this.delegate.hashCode();
    }

    @Override
    protected Map<String, String> delegate() {
        return this.delegate;
    }

    private void reportAggregatingAccess() {
        this.delegate.forEach(this.onAccess);
    }

    private AccessTrackingSet.Listener trackingListener() {
        return new AccessTrackingSet.Listener(){

            @Override
            public void onAccess(Object o) {
                AccessTrackingEnvMap.this.getAndReport(o);
            }

            @Override
            public void onAggregatingAccess() {
                AccessTrackingEnvMap.this.reportAggregatingAccess();
            }

            @Override
            public void onRemove(Object object) {
            }

            @Override
            public void onClear() {
            }
        };
    }

    private AccessTrackingSet.Listener entrySetTrackingListener() {
        return new AccessTrackingSet.Listener(){

            @Override
            public void onAccess(Object o) {
                AccessTrackingEnvMap.this.onAccessEntrySetElement(o);
            }

            @Override
            public void onAggregatingAccess() {
                AccessTrackingEnvMap.this.reportAggregatingAccess();
            }

            @Override
            public void onRemove(Object object) {
            }

            @Override
            public void onClear() {
            }
        };
    }
}

