/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.command;

import com.liferay.blade.cli.BladeCLI;
import com.liferay.blade.cli.command.BaseArgs;
import com.liferay.blade.cli.command.BaseCommand;
import com.liferay.blade.cli.command.OutputsArgs;
import com.liferay.blade.cli.gradle.GradleTooling;
import com.liferay.blade.gradle.tooling.ProjectInfo;
import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;

public class OutputsCommand
extends BaseCommand<OutputsArgs> {
    @Override
    public void execute() throws Exception {
        BladeCLI bladeCLI = this.getBladeCLI();
        BaseArgs args = bladeCLI.getArgs();
        File base = args.getBase();
        ProjectInfo projectInfo = GradleTooling.loadProjectInfo(base.toPath());
        Map<String, Set<File>> projectOutputFiles = projectInfo.getProjectOutputFiles();
        for (Map.Entry<String, Set<File>> entry : projectOutputFiles.entrySet()) {
            String projectPath = entry.getKey();
            bladeCLI.out(projectPath);
            Set<File> outputFiles = entry.getValue();
            for (File output : outputFiles) {
                Path outputPath = output.toPath();
                bladeCLI.out("\t" + outputPath);
            }
            bladeCLI.out("\n");
        }
    }

    @Override
    public Class<OutputsArgs> getArgsClass() {
        return OutputsArgs.class;
    }
}

