/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.MissingCommandException;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterDescription;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.WrappedParameter;
import com.liferay.blade.cli.BladeCLIDefaultProvider;
import com.liferay.blade.cli.BladeSettings;
import com.liferay.blade.cli.Extensions;
import com.liferay.blade.cli.ExtensionsClassLoaderSupplier;
import com.liferay.blade.cli.StringPrintStream;
import com.liferay.blade.cli.WorkspaceProvider;
import com.liferay.blade.cli.command.BaseArgs;
import com.liferay.blade.cli.command.BaseCommand;
import com.liferay.blade.cli.command.BladeProfile;
import com.liferay.blade.cli.command.CommandType;
import com.liferay.blade.cli.command.UpdateArgs;
import com.liferay.blade.cli.command.UpdateCommand;
import com.liferay.blade.cli.command.VersionCommand;
import com.liferay.blade.cli.command.validator.ParameterDepdendencyValidator;
import com.liferay.blade.cli.command.validator.ParameterPossibleValues;
import com.liferay.blade.cli.command.validator.ParameterValidator;
import com.liferay.blade.cli.command.validator.ValidatorFunctionPredicate;
import com.liferay.blade.cli.gradle.GradleExecutionException;
import com.liferay.blade.cli.util.ArrayUtil;
import com.liferay.blade.cli.util.CombinedClassLoader;
import com.liferay.blade.cli.util.FileUtil;
import com.liferay.blade.cli.util.Pair;
import com.liferay.blade.cli.util.ProcessesUtil;
import com.liferay.blade.cli.util.Prompter;
import com.liferay.blade.cli.util.ReleaseUtil;
import com.liferay.release.util.ReleaseEntry;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Scanner;
import java.util.ServiceLoader;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.commons.lang3.StringUtils;
import org.fusesource.jansi.AnsiConsole;

public class BladeCLI {
    public static BladeCLI instance;
    private static final String _BLADE_PROPERTIES = ".blade.properties";
    private static final String _LAST_UPDATE_CHECK_KEY = "lastUpdateCheck";
    private static final String _MESSAGE_OPTION_IS_REQUIRED = "The following option is required: ";
    private static final String _MESSAGE_OPTIONS_ARE_REQUIRED = "The following options are required: ";
    private static final File _USER_HOME_DIR;
    private static final Pattern _parameterDescriptionPattern;
    private static final Formatter _tracer;
    private BaseArgs _args = new BaseArgs();
    private BaseCommand<?> _baseCommand;
    private String _command;
    private Map<String, BaseCommand<? extends BaseArgs>> _commands;
    private final PrintStream _error;
    private Extensions _extensions;
    private ExtensionsClassLoaderSupplier _extensionsClassLoaderSupplier;
    private final InputStream _in;
    private JCommander _jCommander;
    private PrintStream _out;
    private Collection<WorkspaceProvider> _workspaceProviders = null;

    public static Map<String, BaseCommand<? extends BaseArgs>> getCommandMapByClassLoader(String profileName, ClassLoader classLoader) throws IllegalAccessException, InstantiationException {
        Collection allCommands = BladeCLI._getCommandsByClassLoader(classLoader);
        TreeMap commandMap = new TreeMap();
        ArrayList commandsToRemove = new ArrayList();
        boolean profileNameIsPresent = false;
        if (profileName != null && profileName.length() > 0) {
            profileNameIsPresent = true;
        }
        for (BaseCommand<?> baseCommand : allCommands) {
            Collection<String> profileNames = BladeCLI._getBladeProfiles(baseCommand.getClass());
            if (profileNameIsPresent && profileNames.contains(profileName)) {
                BladeCLI._addCommand(commandMap, baseCommand);
                commandsToRemove.add(baseCommand);
                continue;
            }
            if (profileNames == null || profileNames.isEmpty()) continue;
            commandsToRemove.add(baseCommand);
        }
        allCommands.removeAll(commandsToRemove);
        for (BaseCommand<?> baseCommand : allCommands) {
            BladeCLI._addCommand(commandMap, baseCommand);
        }
        return commandMap;
    }

    public static void main(String[] args) {
        BladeCLI bladeCLI = new BladeCLI();
        try {
            bladeCLI.run(args);
        }
        catch (GradleExecutionException gradleExecutionException) {
            System.exit(gradleExecutionException.getReturnCode());
        }
        catch (Throwable th) {
            bladeCLI.error("Unexpected error occured.");
            th.printStackTrace(bladeCLI._error);
            System.exit(1);
        }
    }

    public BladeCLI() {
        this(System.out, System.err, System.in);
    }

    public BladeCLI(PrintStream out, PrintStream error, InputStream in) {
        AnsiConsole.systemInstall();
        this._out = out;
        this._error = error;
        this._in = in;
        instance = this;
    }

    public void addErrors(String prefix, Collection<String> data) {
        PrintStream error = this.error();
        error.println("Error: " + prefix);
        data.forEach(error::println);
    }

    public PrintStream error() {
        return this._error;
    }

    public void error(String message) {
        this._error.println(message);
    }

    public void error(String string, String name, String message) {
        this.error(string + " [" + name + "]");
        this.error(message);
    }

    public void error(Throwable error) {
        this.error(error.getMessage());
        error.printStackTrace(this.error());
    }

    public BaseArgs getArgs() {
        return this._args;
    }

    public BladeSettings getBladeSettings() throws IOException {
        File settingsBaseDir = this._getSettingsBaseDir();
        File settingsFile = new File(settingsBaseDir, ".blade/settings.properties");
        if (settingsFile.exists() && Objects.equals(settingsFile.getName(), "settings.properties")) {
            this._migrateBladeSettingsFile(settingsFile);
        }
        settingsFile = new File(settingsBaseDir, _BLADE_PROPERTIES);
        return new BladeSettings(settingsFile);
    }

    public BaseCommand<?> getCommand() {
        return this._baseCommand;
    }

    public Extensions getExtensions() {
        if (this._extensions == null) {
            ClassLoader classLoader = this._getClassLoader();
            this._extensions = new Extensions(classLoader);
        }
        return this._extensions;
    }

    public Path getExtensionsPath() {
        Path userBladePath = this.getUserBladePath();
        Path extensions = userBladePath.resolve("extensions");
        try {
            if (Files.notExists(extensions, new LinkOption[0])) {
                Files.createDirectories(extensions, new FileAttribute[0]);
            } else if (!Files.isDirectory(extensions, new LinkOption[0])) {
                throw new IOException(".blade/extensions is not a directory!");
            }
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        return extensions;
    }

    public Path getUserBladePath() {
        Path userHomePath = _USER_HOME_DIR.toPath();
        Path userBladePath = userHomePath.resolve(".blade");
        try {
            if (Files.notExists(userBladePath, new LinkOption[0])) {
                Files.createDirectories(userBladePath, new FileAttribute[0]);
            } else if (!Files.isDirectory(userBladePath, new LinkOption[0])) {
                throw new IOException(userBladePath + " is not a directory.");
            }
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        return userBladePath;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public WorkspaceProvider getWorkspaceProvider(File dir) {
        try {
            Collection<WorkspaceProvider> providers = this._getWorkspaceProviders();
            for (WorkspaceProvider provider : providers) {
                try {
                    boolean workspace = provider.isWorkspace(dir);
                    if (!workspace) continue;
                    return provider;
                }
                catch (Throwable throwable) {
                    throw new RuntimeException("_getWorkspaceProvider error", throwable);
                    return null;
                }
            }
        }
        catch (Throwable throwable) {
            throw new RuntimeException("_getWorkspaceProvider error", throwable);
        }
    }

    public InputStream in() {
        return this._in;
    }

    public boolean isWorkspace() {
        BaseArgs baseArgs = this.getArgs();
        return this.getWorkspaceProvider(baseArgs.getBase()) != null;
    }

    public boolean isWorkspaceDir(File dir) {
        try {
            Collection<WorkspaceProvider> providers = this._getWorkspaceProviders();
            for (WorkspaceProvider provider : providers) {
                try {
                    boolean workspace = provider.isWorkspace(dir);
                    if (!workspace) continue;
                    return true;
                }
                catch (Throwable throwable) {
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public PrintStream out() {
        return this._out;
    }

    public void out(String msg) {
        this.out().println(msg);
    }

    public void postRunCommand() {
        if (this._shouldCheckForUpdates()) {
            try {
                this._writeLastUpdateCheck();
                this._printUpdateIfAvailable();
            }
            catch (IOException ioException) {
                this.error(ioException);
            }
        }
    }

    public void printUsage() {
        StringBuilder sb = new StringBuilder();
        CommandType ignoreCommandType = CommandType.WORKSPACE_ONLY;
        if (this.isWorkspace()) {
            ignoreCommandType = CommandType.NON_WORKSPACE;
        }
        JCommander jCommander = new JCommander();
        jCommander.setProgramName("blade");
        for (String command : this._commands.keySet()) {
            BaseCommand<? extends BaseArgs> baseCommand = this._commands.get(command);
            BaseArgs baseArgs = baseCommand.getArgs();
            CommandType commandType = baseArgs.getCommandType();
            if (commandType.equals((Object)ignoreCommandType) || commandType.equals((Object)CommandType.HIDDEN)) continue;
            jCommander.addCommand(baseArgs);
        }
        jCommander.getUsageFormatter().usage(sb);
        try (Scanner scanner = new Scanner(sb.toString());){
            StringBuilder simplifiedUsageString = new StringBuilder();
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (line.contains("Options:")) {
                    while (scanner.hasNextLine() && !(line = scanner.nextLine()).equals("")) {
                    }
                }
                simplifiedUsageString.append(line + System.lineSeparator());
            }
            if (!this.isWorkspace()) {
                simplifiedUsageString.append("To see more command options, run \"blade init\" to create a workspace");
            }
            String output = simplifiedUsageString.toString();
            this.out(output);
        }
    }

    public void printUsage(String command) {
        this._jCommander.getUsageFormatter().usage(command);
    }

    public void printUsage(String command, String message) {
        this.out(message);
        this._jCommander.getUsageFormatter().usage(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run(String[] args) throws Exception {
        try {
            if (ArrayUtil.contains(args, "--trace")) {
                // empty if block
            }
            if (ArrayUtil.contains(args, "init") || ArrayUtil.contains(args, "--refresh-releases")) {
                System.out.println("Checking for new releases...");
                ReleaseUtil.initialize(0L);
            }
            this._removeOutDatedTempDir();
            Extensions extensions = this.getExtensions();
            String basePath = this._extractBasePath(args);
            String profileName = this._extractProfileName(args);
            File baseDir = new File(basePath);
            baseDir = baseDir.getAbsoluteFile();
            this._args.setBase(baseDir);
            System.setOut(this.out());
            System.setErr(this.error());
            BladeSettings bladeSettings = this.getBladeSettings();
            if (profileName != null) {
                bladeSettings.setProfileName(profileName);
                bladeSettings.migrateWorkspaceIfNecessary(this, profileName);
            } else {
                bladeSettings.migrateWorkspaceIfNecessary(this);
            }
            this._commands = extensions.getCommands(bladeSettings.getProfileName());
            args = Extensions.sortArgs(this._commands, args);
            this._jCommander = this._buildJCommanderWithCommandMap(args, this._commands);
            if (args.length == 1 && args[0].equals("--help")) {
                this.printUsage();
                return;
            }
            try (CloseShieldInputStream closeShieldInputStream = new CloseShieldInputStream(this.in());
                 BufferedReader reader = new BufferedReader(new InputStreamReader(closeShieldInputStream));){
                ParameterException parameterException1 = null;
                try {
                    this._jCommander.parse(args);
                }
                catch (ParameterException parameterException2) {
                    String parameterExceptionMessage = parameterException2.getMessage();
                    if (parameterExceptionMessage.contains("Only one main parameter allowed")) {
                        throw parameterException2;
                    }
                    parameterException1 = parameterException2;
                }
                String command = this._jCommander.getParsedCommand();
                Map<String, JCommander> jCommands = this._jCommander.getCommands();
                JCommander jCommander = jCommands.get(command);
                if (jCommander != null) {
                    List<Object> objects = jCommander.getObjects();
                    Object commandArgs = objects.get(0);
                    BaseArgs baseArgs = (BaseArgs)commandArgs;
                    this._validateParameters(baseArgs);
                    String parameterMessage = null;
                    if (parameterException1 != null) {
                        parameterMessage = parameterException1.getMessage();
                        if (!parameterMessage.contains("Main parameters are required") && !parameterMessage.contains(_MESSAGE_OPTIONS_ARE_REQUIRED) && !parameterMessage.contains(_MESSAGE_OPTION_IS_REQUIRED)) throw parameterException1;
                        System.out.println("Error: The command " + command + " is missing required parameters.");
                    } else {
                        this._validateParameterDependency((BaseArgs)commandArgs);
                        this._command = command;
                        this._args = (BaseArgs)commandArgs;
                        this._args.setProfileName(profileName);
                        this._args.setBase(baseDir);
                        try {
                            this.runCommand();
                            this.postRunCommand();
                        }
                        catch (ParameterException parameterException2) {
                            parameterException1 = parameterException2;
                        }
                    }
                    while (parameterException1 != null) {
                        parameterMessage = parameterException1.getMessage();
                        ArrayList<String> fixedArgs = new ArrayList<String>(Arrays.asList(args));
                        if (parameterMessage.contains(_MESSAGE_OPTIONS_ARE_REQUIRED) || parameterMessage.contains(_MESSAGE_OPTION_IS_REQUIRED)) {
                            parameterMessage = parameterMessage.replace(_MESSAGE_OPTIONS_ARE_REQUIRED, "");
                            parameterMessage = parameterMessage.replace(_MESSAGE_OPTION_IS_REQUIRED, "");
                            Matcher matcher = _parameterDescriptionPattern.matcher(parameterMessage);
                            String missingParameterDescription = null;
                            if (matcher.matches()) {
                                parameterMessage = matcher.group(1);
                                missingParameterDescription = matcher.group(2);
                            }
                            String[] missingParameters = parameterMessage.split(", ");
                            String value = null;
                            for (String missingParameter : missingParameters) {
                                missingParameter = this._getMissingParameterUnformatted(missingParameter);
                                value = this._promptForMissingParameter(commandArgs, Optional.of(missingParameter), Optional.ofNullable(missingParameterDescription), reader, profileName);
                                fixedArgs.add(1, missingParameter);
                                fixedArgs.add(2, value);
                            }
                            args = fixedArgs.toArray(new String[0]);
                            args = Extensions.sortArgs(this._commands, args);
                        } else {
                            if (!parameterMessage.contains("Main parameters are required")) throw parameterException1;
                            String value = this._promptForMissingParameter(commandArgs, Optional.empty(), Optional.empty(), reader, profileName);
                            fixedArgs.add(value);
                            args = fixedArgs.toArray(new String[0]);
                            args = Extensions.sortArgs(this._commands, args);
                        }
                        try {
                            parameterException1 = null;
                            this._jCommander = this._buildJCommanderWithCommandMap(args, this._commands);
                            this._jCommander.parse(args);
                        }
                        catch (ParameterException parameterException2) {
                            parameterException1 = parameterException2;
                            continue;
                        }
                        jCommands = this._jCommander.getCommands();
                        jCommander = jCommands.get(command);
                        if (jCommander == null) {
                            this.printUsage();
                            return;
                        }
                        objects = jCommander.getObjects();
                        commandArgs = objects.get(0);
                        if (parameterException1 != null) continue;
                        this._command = command;
                        this._args = (BaseArgs)commandArgs;
                        this._args.setProfileName(profileName);
                        this._args.setBase(baseDir);
                        try {
                            this._validateParameterDependency(this._args);
                            this.runCommand();
                            this.postRunCommand();
                        }
                        catch (ParameterException parameterException2) {
                            parameterException1 = parameterException2;
                        }
                    }
                    return;
                }
                this.printUsage();
                return;
            }
            catch (MissingCommandException missingCommandException) {
                this.error("Error");
                StringBuilder stringBuilder = new StringBuilder("0. No such command");
                for (String arg : args) {
                    stringBuilder.append(" " + arg);
                }
                this.error(stringBuilder.toString());
                this.printUsage();
                return;
            }
            catch (ParameterException parameterException) {
                this.error("Error");
                this.error(this._jCommander.getParsedCommand() + ": " + parameterException.getMessage());
            }
            return;
        }
        catch (GradleExecutionException gradleExecutionException) {
            throw gradleExecutionException;
        }
        catch (Throwable throwable) {
            this.error(throwable);
            return;
        }
        finally {
            if (this._extensionsClassLoaderSupplier != null) {
                this._extensionsClassLoaderSupplier.close();
            }
            if (this._extensions != null) {
                this._extensions.close();
            }
        }
    }

    public void runCommand() throws Exception {
        if (this._args.isHelp()) {
            if (Objects.isNull(this._command) || this._command.length() == 0) {
                this.printUsage();
            } else {
                this.printUsage(this._command);
            }
        } else if (this._args != null) {
            this._runCommand();
        } else {
            this._jCommander.usage();
        }
    }

    public void trace(String s, Object ... args) {
        if (this._args.isTrace() && _tracer != null) {
            _tracer.format("# " + s + "%n", args);
            _tracer.flush();
        }
    }

    private static void _addCommand(Map<String, BaseCommand<?>> map, BaseCommand<?> baseCommand) throws IllegalAccessException, InstantiationException {
        Arrays.stream(BladeCLI._getCommandNames(baseCommand)).forEach(commandName -> map.putIfAbsent((String)commandName, baseCommand));
    }

    private static Collection<String> _getBladeProfiles(Class<?> commandClass) {
        return Stream.of(commandClass.getAnnotationsByType(BladeProfile.class)).filter(Objects::nonNull).map(BladeProfile::value).collect(Collectors.toList());
    }

    private static String[] _getCommandNames(BaseCommand<?> baseCommand) throws IllegalAccessException, InstantiationException {
        Class<?> baseArgsClass = baseCommand.getArgsClass();
        BaseArgs baseArgs = (BaseArgs)baseArgsClass.newInstance();
        baseCommand.setArgs(baseArgs);
        Parameters parameters = baseArgsClass.getAnnotation(Parameters.class);
        if (parameters == null) {
            throw new IllegalArgumentException("Loaded base command class that does not have a Parameters annotation " + baseArgsClass.getName());
        }
        return parameters.commandNames();
    }

    private static Collection<BaseCommand<?>> _getCommandsByClassLoader(ClassLoader classLoader) {
        ArrayList allCommands = new ArrayList();
        ServiceLoader<BaseCommand> serviceLoader = ServiceLoader.load(BaseCommand.class, classLoader);
        Iterator<BaseCommand> baseCommandIterator = serviceLoader.iterator();
        while (baseCommandIterator.hasNext()) {
            try {
                BaseCommand baseCommand = baseCommandIterator.next();
                baseCommand.setClassLoader(classLoader);
                allCommands.add(baseCommand);
            }
            catch (Throwable throwable) {
                Class<?> throwableClass = throwable.getClass();
                System.err.println("Exception thrown while loading extension." + System.lineSeparator() + "Exception: " + throwableClass.getName() + ": " + throwable.getMessage() + System.lineSeparator());
                Throwable cause = throwable.getCause();
                if (cause == null) continue;
                Class<?> throwableCauseClass = cause.getClass();
                System.err.print(throwableCauseClass.getName() + ": " + cause.getMessage() + System.lineSeparator());
            }
        }
        return allCommands;
    }

    private JCommander _buildJCommanderWithCommandMap(String[] args, Map<String, BaseCommand<? extends BaseArgs>> commandMap) {
        JCommander.Builder builder = JCommander.newBuilder();
        builder.programName("blade");
        for (Map.Entry<String, BaseCommand<? extends BaseArgs>> entry : commandMap.entrySet()) {
            BaseCommand<? extends BaseArgs> value = entry.getValue();
            try {
                builder.addCommand(entry.getKey(), value.getArgs(), new String[0]);
            }
            catch (ParameterException parameterException) {
                System.err.println(parameterException.getMessage());
            }
        }
        builder.defaultProvider(new BladeCLIDefaultProvider(args));
        JCommander build = builder.build();
        build.setParameterDescriptionComparator((Comparator<? super ParameterDescription>)new Comparator<ParameterDescription>(){

            @Override
            public int compare(ParameterDescription parameterDescription0, ParameterDescription parameterDescription1) {
                Parameter parameterAnnotation0 = parameterDescription0.getParameterAnnotation();
                Parameter parameterAnnotation1 = parameterDescription1.getParameterAnnotation();
                WrappedParameter wrappedParameter0 = parameterDescription0.getParameter();
                WrappedParameter wrappedParameter1 = parameterDescription1.getParameter();
                String[] names0 = wrappedParameter0.names();
                String[] names1 = wrappedParameter1.names();
                String name0 = Arrays.stream(names0).filter(name -> name.startsWith("-") && !name.startsWith("--")).findFirst().orElse(names0.length > 0 ? names0[0] : "").toLowerCase().replace("-", "");
                String name1 = Arrays.stream(names1).filter(name -> name.startsWith("-") && !name.startsWith("--")).findFirst().orElse(names1.length > 0 ? names1[0] : "").toLowerCase().replace("-", "");
                if (parameterAnnotation0 != null && parameterAnnotation0.order() != -1 && parameterAnnotation1 != null && parameterAnnotation1.order() != -1) {
                    return Integer.compare(parameterAnnotation0.order(), parameterAnnotation1.order());
                }
                if (parameterAnnotation0 != null && parameterAnnotation0.order() != -1) {
                    return -1;
                }
                if (parameterAnnotation1 != null && parameterAnnotation1.order() != -1) {
                    return 1;
                }
                if (!name0.isEmpty() || !name1.isEmpty()) {
                    return name0.compareTo(name1);
                }
                String longestName0 = parameterDescription0.getLongestName();
                String longestName1 = parameterDescription1.getLongestName();
                return longestName0.compareTo(longestName1);
            }
        });
        return build;
    }

    private Map<String, String> _buildMavenPossibleValuesMap(Class<? extends Supplier<List<String>>> supplierValidator) {
        try {
            Constructor<? extends Supplier<List<String>>> declaredConstructor = supplierValidator.getDeclaredConstructor(new Class[0]);
            Supplier<List<String>> instance = declaredConstructor.newInstance(new Object[0]);
            List<String> options = instance.get();
            Iterator<String> it = options.iterator();
            LinkedHashMap<String, String> optionsMap = new LinkedHashMap<String, String>();
            int x = 1;
            while (it.hasNext()) {
                String option = it.next();
                ReleaseEntry releaseEntry = ReleaseUtil.getReleaseEntry(option);
                optionsMap.put(String.valueOf(x), releaseEntry.getTargetPlatformVersion());
                ++x;
            }
            return optionsMap;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private Map<String, String> _buildPossibleValuesMap(Class<? extends Supplier<List<String>>> supplierValidator) {
        try {
            Supplier<List<String>> instance = supplierValidator.newInstance();
            List<String> options = instance.get();
            Iterator<String> it = options.iterator();
            LinkedHashMap<String, String> optionsMap = new LinkedHashMap<String, String>();
            int x = 1;
            while (it.hasNext()) {
                String option = it.next();
                optionsMap.put(String.valueOf(x), option);
                ++x;
            }
            return optionsMap;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private String _extractBasePath(String[] args) {
        String defaultBasePath = ".";
        if (args.length > 2) {
            for (int x = 0; x < args.length; ++x) {
                String arg = args[x];
                if (!arg.equals("--base")) continue;
                if (x + 1 == args.length || args[x + 1].startsWith("-")) {
                    this.error("Error: The parameter for base path is mising.");
                    System.exit(0);
                }
                defaultBasePath = args[x + 1];
            }
        }
        return defaultBasePath;
    }

    private String _extractProfileName(String[] args) {
        ArrayList<String> argsList = new ArrayList<String>();
        List<String> originalArgsList = Arrays.asList(args);
        argsList.addAll(originalArgsList);
        for (int x = 0; x < argsList.size(); ++x) {
            String arg = (String)argsList.get(x);
            if (!Objects.equals(arg, "--base")) continue;
            argsList.remove(x);
            argsList.remove(x);
            break;
        }
        try {
            return this._getCommandProfile(argsList.toArray(new String[0]));
        }
        catch (MissingCommandException missingCommandException) {
            this.error(missingCommandException.getMessage());
            System.exit(0);
            return null;
        }
    }

    private ClassLoader _getClassLoader() {
        if (this._extensionsClassLoaderSupplier == null) {
            this._extensionsClassLoaderSupplier = new ExtensionsClassLoaderSupplier(this.getExtensionsPath());
        }
        return this._extensionsClassLoaderSupplier.get();
    }

    private String _getCommandProfile(String[] args) throws MissingCommandException {
        HashSet profileFlags = new HashSet();
        try {
            Field field = BaseArgs.class.getDeclaredField("_profileName");
            Parameter parameters = field.getAnnotation(Parameter.class);
            Collections.addAll(profileFlags, parameters.names());
        }
        catch (Exception field) {
            // empty catch block
        }
        String profile = null;
        ArrayList<String> argsCollection = new ArrayList<String>();
        for (String arg : args) {
            String[] argSplit;
            for (String argEach : argSplit = arg.split(" ")) {
                argsCollection.add(argEach);
            }
        }
        String[] argsArray = argsCollection.toArray(new String[0]);
        for (int x = 0; x < argsArray.length; ++x) {
            String arg = argsArray[x];
            if (!profileFlags.contains(arg)) continue;
            if (x + 1 == argsArray.length || argsArray[x + 1].startsWith("-")) {
                throw new MissingCommandException("Error: The parameter for profile name is missing");
            }
            profile = argsArray[x + 1];
            break;
        }
        return profile;
    }

    private String _getMessageFromPossibleValues(Map<String, String> optionsMap) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : optionsMap.entrySet()) {
            sb.append(System.lineSeparator());
            sb.append(entry.getKey() + ": " + entry.getValue());
        }
        return sb.toString();
    }

    private String _getMissingParameterUnformatted(String missingParameter) {
        if (missingParameter.contains(" | ")) {
            missingParameter = missingParameter.split(" | ")[0];
        }
        if (missingParameter.startsWith("[")) {
            missingParameter = missingParameter.substring(1);
        }
        if (missingParameter.endsWith("]")) {
            missingParameter = missingParameter.substring(0, missingParameter.length() - 1);
        }
        return missingParameter;
    }

    private String _getParameterNames(List<String> parameterNamesList) {
        StringBuilder missingOptionSb = new StringBuilder();
        for (int x = 0; x < parameterNamesList.size(); ++x) {
            String missingParameterArgument = parameterNamesList.get(x);
            if (x == 0) {
                missingOptionSb.append("[");
            }
            missingOptionSb.append(missingParameterArgument);
            if (x + 1 <= parameterNamesList.size() - 1) {
                missingOptionSb.append(" | ");
                continue;
            }
            missingOptionSb.append("]");
        }
        return missingOptionSb.toString();
    }

    private Map<String, String> _getPossibleDefaultValuesMap(Field field, StringBuilder sb, String profileName) {
        Class<? extends Supplier<List<String>>> possibleValuesSupplier;
        Map<String, String> possibleValuesMap = null;
        ParameterPossibleValues possibleValuesAnnotation = field.getDeclaredAnnotation(ParameterPossibleValues.class);
        if (possibleValuesAnnotation != null && (possibleValuesSupplier = possibleValuesAnnotation.value()) != null) {
            if (Objects.equals(profileName, "maven")) {
                possibleValuesMap = this._buildMavenPossibleValuesMap(possibleValuesSupplier);
                sb.append(this._getMessageFromPossibleValues(possibleValuesMap));
                return possibleValuesMap;
            }
            possibleValuesMap = this._buildPossibleValuesMap(possibleValuesSupplier);
            sb.append(this._getMessageFromPossibleValues(possibleValuesMap));
        }
        return possibleValuesMap;
    }

    private Map<String, String> _getPossibleMoreValuesMap(Field field, StringBuilder sb, String profileName) {
        Class<? extends Supplier<List<String>>> possibleValuesSupplier;
        Map<String, String> possibleValuesMap = null;
        ParameterPossibleValues possibleValuesAnnotation = field.getDeclaredAnnotation(ParameterPossibleValues.class);
        if (possibleValuesAnnotation != null && (possibleValuesSupplier = possibleValuesAnnotation.more()) != null) {
            if (Objects.equals(profileName, "maven")) {
                possibleValuesMap = this._buildMavenPossibleValuesMap(possibleValuesSupplier);
                sb.append(this._getMessageFromPossibleValues(possibleValuesMap));
                return possibleValuesMap;
            }
            possibleValuesMap = this._buildPossibleValuesMap(possibleValuesSupplier);
            sb.append(this._getMessageFromPossibleValues(possibleValuesMap));
        }
        return possibleValuesMap;
    }

    private File _getSettingsBaseDir() {
        File baseDir = this._args.getBase();
        WorkspaceProvider workspaceProvider = this.getWorkspaceProvider(baseDir);
        File settingsBaseDir = workspaceProvider != null ? workspaceProvider.getWorkspaceDir(baseDir) : _USER_HOME_DIR;
        return settingsBaseDir;
    }

    private Path _getUpdateCheckPath() throws IOException {
        Path userBladePath = this.getUserBladePath();
        return userBladePath.resolve("updateCheck.properties");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<String> _getUpdateVersionIfAvailable(boolean snapshots) {
        UpdateArgs updateArgs = new UpdateArgs();
        updateArgs.setCheckOnly(true);
        UpdateCommand updateCommand = new UpdateCommand();
        updateCommand.setArgs(updateArgs);
        updateCommand.setBlade(this);
        StringPrintStream stdOut = StringPrintStream.newInstance();
        PrintStream currentStdOut = System.out;
        try {
            System.setOut(stdOut);
            this._out = System.out;
            updateCommand.execute();
        }
        finally {
            System.setOut(currentStdOut);
            this._out = System.out;
        }
        if (snapshots) {
            Optional<String> snapshotUpdateVersionOpt = updateCommand.getSnapshotUpdateVersion();
            if (!snapshotUpdateVersionOpt.isPresent()) {
                return Optional.empty();
            }
            String snapshotUpdateVersion = snapshotUpdateVersionOpt.get();
            snapshotUpdateVersion = snapshotUpdateVersion.substring(0, 14) + snapshotUpdateVersion.substring(15, 19);
            snapshotUpdateVersion = snapshotUpdateVersion.replace('-', '.');
            return Optional.of(snapshotUpdateVersion.trim());
        }
        return updateCommand.getReleaseUpdateVersion();
    }

    private Collection<WorkspaceProvider> _getWorkspaceProviders() throws Exception {
        if (this._workspaceProviders == null) {
            this._workspaceProviders = new ArrayList<WorkspaceProvider>();
            ServiceLoader<WorkspaceProvider> serviceLoader = ServiceLoader.load(WorkspaceProvider.class, this._getClassLoader());
            Iterator<WorkspaceProvider> workspaceProviderIterator = serviceLoader.iterator();
            while (workspaceProviderIterator.hasNext()) {
                try {
                    WorkspaceProvider workspaceProvider = workspaceProviderIterator.next();
                    this._workspaceProviders.add(workspaceProvider);
                }
                catch (Throwable throwable) {
                    Class<?> throwableClass = throwable.getClass();
                    System.err.println("Exception thrown while loading WorkspaceProvider." + System.lineSeparator() + "Exception: " + throwableClass.getName() + ": " + throwable.getMessage());
                    Throwable cause = throwable.getCause();
                    if (cause == null) continue;
                    Class<?> throwableCauseClass = cause.getClass();
                    System.err.print(throwableCauseClass.getName() + ": " + cause.getMessage());
                }
            }
            return this._workspaceProviders;
        }
        return this._workspaceProviders;
    }

    private void _migrateBladeSettingsFile(File settingsFile) throws IOException {
        Path settingsPath = settingsFile.toPath();
        Path settingsParentPath = settingsPath.getParent();
        if (settingsParentPath.endsWith(".blade")) {
            Path settingsParentParentPath = settingsParentPath.getParent();
            Path newSettingsPath = settingsParentParentPath.resolve(_BLADE_PROPERTIES);
            Files.move(settingsPath, newSettingsPath, new CopyOption[0]);
            try (Stream<Path> filesStream = Files.list(settingsParentPath);){
                if (filesStream.count() == 0L) {
                    Files.delete(settingsParentPath);
                }
            }
        }
    }

    private void _printUpdateIfAvailable() throws IOException {
        Optional<String> releaseUpdateVersion = this._getUpdateVersionIfAvailable(false);
        String currentVersion = VersionCommand.getBladeCLIVersion();
        boolean currentVersionIsSnapshot = currentVersion.contains("SNAPSHOT");
        currentVersion = currentVersion.replace("SNAPSHOT", "");
        if (!currentVersionIsSnapshot) {
            currentVersion = currentVersion.substring(0, 5);
        }
        if (currentVersionIsSnapshot) {
            Optional<String> snapshotUpdateVersion = this._getUpdateVersionIfAvailable(true);
            if (releaseUpdateVersion.isPresent() && snapshotUpdateVersion.isPresent()) {
                this.out("Updates available to the installed version: " + currentVersion);
                this.out("-> (Snapshot) " + snapshotUpdateVersion + "\t Run `blade update` to install");
                this.out("-> (Release) " + releaseUpdateVersion + "\t\t\t Run `blade update -r` to install");
            } else if (snapshotUpdateVersion.isPresent()) {
                this.out("Update available " + currentVersion + " -> " + snapshotUpdateVersion.get());
                this.out("Run `blade update` to install");
            } else if (releaseUpdateVersion.isPresent()) {
                this.out("Update available " + currentVersion + " -> " + releaseUpdateVersion.get());
                this.out("Run `blade update -r` to install");
            }
        } else if (releaseUpdateVersion.isPresent()) {
            this.out("Update available " + currentVersion + " -> " + releaseUpdateVersion.get());
            this.out("Run `blade update` to install");
        }
    }

    private String _promptForMissingParameter(Object commandArgs, Optional<String> missingParameterOptional, Optional<String> missingParameterDescription, BufferedReader reader, String profileName) {
        String value = null;
        Class<?> commandArgsClass = commandArgs.getClass();
        for (Field field : commandArgsClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Parameter.class)) continue;
            Parameter parameterAnnotation = field.getDeclaredAnnotation(Parameter.class);
            String description = parameterAnnotation.description();
            String[] parameterAnnotationNames = parameterAnnotation.names();
            List<String> parameterNamesList = Arrays.asList(parameterAnnotationNames);
            StringBuilder sb = null;
            String missingParametersFormatted = null;
            boolean found = false;
            if (missingParameterOptional.isPresent() && parameterNamesList.contains(missingParameterOptional.get())) {
                sb = new StringBuilder(_MESSAGE_OPTION_IS_REQUIRED);
                missingParametersFormatted = this._getParameterNames(parameterNamesList);
                sb.append(missingParametersFormatted);
                if (missingParameterDescription.isPresent()) {
                    sb.append(" " + missingParameterDescription.get());
                } else if (!description.isEmpty()) {
                    sb.append(" " + description);
                }
                found = true;
            } else if (!(missingParameterOptional.isPresent() || parameterAnnotationNames != null && parameterAnnotationNames.length != 0)) {
                sb = new StringBuilder("The main parameter is required: ");
                if (parameterAnnotation.description() != null) {
                    sb.append(" (" + parameterAnnotation.description() + ")");
                }
                missingParametersFormatted = "the main parameter";
                found = true;
            }
            if (!found) continue;
            Map<String, String> optionsMap = this._getPossibleDefaultValuesMap(field, sb, profileName);
            String message = sb.toString();
            value = this._promptForValueWithOptions(field, sb, missingParametersFormatted, optionsMap, message, reader, this.out(), profileName);
            break;
        }
        return value;
    }

    private String _promptForValueWithOptions(Field field, StringBuilder sb, String missingParametersFormatted, Map<String, String> optionsMap, String message, BufferedReader reader, PrintStream printStream, String profileName) {
        String value = Prompter.promptString(message, reader, printStream);
        if (optionsMap != null && !optionsMap.isEmpty()) {
            while (!(optionsMap.containsKey(value) || optionsMap.containsValue(value) || Objects.equals(value, "more"))) {
                System.out.println("Please enter a valid value for " + missingParametersFormatted);
                value = Prompter.promptString("", reader, printStream);
            }
            if (optionsMap.containsKey(value)) {
                value = optionsMap.get(value);
            } else if (Objects.equals(value, "more")) {
                StringBuilder more = new StringBuilder();
                Map<String, String> moreOptionsMap = this._getPossibleMoreValuesMap(field, more, profileName);
                value = this._promptForValueWithOptions(field, sb, missingParametersFormatted, moreOptionsMap, more.toString(), reader, this.out(), profileName);
            }
        }
        return value;
    }

    private void _removeOutDatedTempDir() {
        final List<Long> processIdList = ProcessesUtil.getAllProcessIds();
        String tmpdir = System.getProperty("java.io.tmpdir");
        final File tmpFile = new File(tmpdir);
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    Stream.of(tmpFile.listFiles()).filter(file -> {
                        String fileName = file.getName();
                        if (fileName.startsWith("blade-extensions-") || fileName.startsWith("blade-templates-")) {
                            String[] segments = fileName.split("-");
                            String pid = segments[2];
                            return !processIdList.contains(Long.parseLong(pid));
                        }
                        return false;
                    }).forEach(file -> {
                        try {
                            FileUtil.deleteDirIfExists(file.toPath());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        thread.start();
    }

    private void _runCommand() throws Exception {
        BaseCommand<? extends BaseArgs> command = null;
        if (this._commands.containsKey(this._command)) {
            command = this._commands.get(this._command);
        }
        if (command != null) {
            this._baseCommand = command;
            command.setArgs(this._args);
            command.setBlade(this);
            Thread thread = Thread.currentThread();
            ClassLoader currentClassLoader = thread.getContextClassLoader();
            CombinedClassLoader combinedClassLoader = new CombinedClassLoader(currentClassLoader, command.getClassLoader());
            try {
                thread.setContextClassLoader(combinedClassLoader);
                if (this._args.getProfileName() == null) {
                    this._args.setProfileName("gradle");
                }
                command.execute();
            }
            catch (ParameterException parameterException) {
                throw parameterException;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (command instanceof AutoCloseable) {
                    AutoCloseable autoCloseable = (AutoCloseable)((Object)command);
                    autoCloseable.close();
                }
                thread.setContextClassLoader(currentClassLoader);
            }
        } else {
            this.printUsage();
        }
    }

    private boolean _shouldCheckForUpdates() {
        try {
            if (this._command.contains("update")) {
                return false;
            }
            BaseArgs baseArgs = this.getArgs();
            if (baseArgs.isQuiet()) {
                return false;
            }
            Path updateCheckPath = this._getUpdateCheckPath();
            if (!Files.exists(updateCheckPath, new LinkOption[0])) {
                return true;
            }
            Properties properties = new Properties();
            try (InputStream inputStream = Files.newInputStream(updateCheckPath, new OpenOption[0]);){
                properties.load(inputStream);
            }
            Instant lastUpdateCheck = Instant.ofEpochMilli(Long.parseLong(properties.getProperty(_LAST_UPDATE_CHECK_KEY)));
            Instant now = Instant.now();
            Instant yesterday = now.minus(1L, ChronoUnit.DAYS);
            if (yesterday.isAfter(lastUpdateCheck)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private <T extends BaseArgs> void _validateParameterDependency(T args) throws IllegalArgumentException {
        try {
            Class<?> argsClass = args.getClass();
            Field[] classFields = argsClass.getDeclaredFields();
            ArrayList<Pair<ParameterDepdendencyValidator, Field>> validatorPairs = new ArrayList<Pair<ParameterDepdendencyValidator, Field>>();
            for (Field field : classFields) {
                ParameterDepdendencyValidator validator = field.getAnnotation(ParameterDepdendencyValidator.class);
                if (Objects.isNull(validator)) continue;
                validatorPairs.add(new Pair<ParameterDepdendencyValidator, Field>(validator, field));
            }
            Collections.sort(validatorPairs, new Comparator<Pair<ParameterDepdendencyValidator, Field>>(){

                @Override
                public int compare(Pair<ParameterDepdendencyValidator, Field> pair1, Pair<ParameterDepdendencyValidator, Field> pair2) {
                    ParameterDepdendencyValidator firstValidator = pair1.first();
                    ParameterDepdendencyValidator secondeValidator = pair2.first();
                    return firstValidator.order() - secondeValidator.order();
                }
            });
            for (Pair pair : validatorPairs) {
                ValidatorFunctionPredicate<?> validatorFunction;
                ParameterDepdendencyValidator validator = (ParameterDepdendencyValidator)pair.first();
                Class<ValidatorFunctionPredicate<?>> predicateClass = validator.value();
                if (predicateClass == null || (validatorFunction = predicateClass.newInstance()).test(args)) continue;
                Field field = (Field)pair.second();
                List possibleValues = (List)validatorFunction.apply(args);
                String possibleValueString = StringUtils.join(possibleValues, "|");
                Parameter parameterAnnotation = field.getAnnotation(Parameter.class);
                if (!possibleValues.isEmpty()) {
                    throw new IllegalArgumentException("Parameter validataion failed for " + parameterAnnotation.names()[0] + ", possible value are " + possibleValueString);
                }
                throw new IllegalArgumentException("Parameter validataion failed for " + parameterAnnotation.names()[0]);
            }
        }
        catch (Exception exception) {
            Class<?> argsClass = args.getClass();
            throw new IllegalArgumentException("Parameter's depdendency Validation failed for " + argsClass.getSimpleName(), exception);
        }
    }

    private <T extends BaseArgs> void _validateParameters(T args) throws IllegalArgumentException {
        try {
            ParameterValidator[] validateParameters;
            Class<?> argsClass = args.getClass();
            for (ParameterValidator parameterValidator : validateParameters = (ParameterValidator[])argsClass.getAnnotationsByType(ParameterValidator.class)) {
                Predicate<?> predicate;
                Class<Predicate<?>> predicateClass = parameterValidator.value();
                if (predicateClass == null || (predicate = predicateClass.newInstance()).test(args)) continue;
                throw new IllegalArgumentException();
            }
        }
        catch (Exception exception) {
            Class<?> argsClass = args.getClass();
            throw new IllegalArgumentException("Validation failed for " + argsClass.getSimpleName(), exception);
        }
    }

    private void _writeLastUpdateCheck() throws IOException {
        Path updateCheckPath = this._getUpdateCheckPath();
        Properties properties = new Properties();
        Instant now = Instant.now();
        properties.put(_LAST_UPDATE_CHECK_KEY, String.valueOf(now.toEpochMilli()));
        try (OutputStream outputStream = Files.newOutputStream(updateCheckPath, new OpenOption[0]);){
            properties.store(outputStream, null);
        }
    }

    static {
        _USER_HOME_DIR = new File(System.getProperty("user.home"));
        _parameterDescriptionPattern = Pattern.compile("(.*]) (.*)");
        _tracer = new Formatter(System.out);
    }
}

