/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.NonNullApi;
import org.gradle.internal.classpath.ClassData;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.org.objectweb.asm.MethodVisitor;
import org.gradle.internal.instrumentation.api.jvmbytecode.JvmBytecodeCallInterceptor;
import org.gradle.internal.instrumentation.api.metadata.InstrumentationMetadata;
import org.gradle.internal.lazy.Lazy;

@NonNullApi
public interface JvmBytecodeInterceptorSet {
    public static final JvmBytecodeInterceptorSet DEFAULT = new ClassLoaderSourceJvmBytecodeInterceptorSet(JvmBytecodeInterceptorSet.class.getClassLoader());

    public Collection<JvmBytecodeCallInterceptor> getInterceptors(MethodVisitor var1, ClassData var2);

    default public JvmBytecodeInterceptorSet plus(JvmBytecodeInterceptorSet other) {
        return new CompositeJvmBytecodeInterceptorSet(this, other);
    }

    @NonNullApi
    public static class CompositeJvmBytecodeInterceptorSet
    implements JvmBytecodeInterceptorSet {
        private final JvmBytecodeInterceptorSet first;
        private final JvmBytecodeInterceptorSet second;

        public CompositeJvmBytecodeInterceptorSet(JvmBytecodeInterceptorSet first, JvmBytecodeInterceptorSet second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public Collection<JvmBytecodeCallInterceptor> getInterceptors(MethodVisitor methodVisitor, ClassData classData) {
            return Stream.of(this.first.getInterceptors(methodVisitor, classData), this.second.getInterceptors(methodVisitor, classData)).flatMap(Collection::stream).collect(Collectors.toMap(interceptor -> interceptor.getClass().getName(), p -> p, (p, q) -> p, LinkedHashMap::new)).values();
        }
    }

    @NonNullApi
    public static class ClassLoaderSourceJvmBytecodeInterceptorSet
    implements JvmBytecodeInterceptorSet {
        private final Lazy<List<JvmBytecodeCallInterceptor.Factory>> factories = Lazy.locking().of(() -> ClassLoaderSourceJvmBytecodeInterceptorSet.loadFactories(classLoader, forPackage));

        public ClassLoaderSourceJvmBytecodeInterceptorSet(ClassLoader classLoader) {
            this(classLoader, "org.gradle");
        }

        @VisibleForTesting
        public ClassLoaderSourceJvmBytecodeInterceptorSet(ClassLoader classLoader, String forPackage) {
        }

        private static List<JvmBytecodeCallInterceptor.Factory> loadFactories(ClassLoader classLoader, String forPackage) {
            ImmutableList.Builder factories = ImmutableList.builder();
            for (JvmBytecodeCallInterceptor.Factory factory : ServiceLoader.load(JvmBytecodeCallInterceptor.Factory.class, classLoader)) {
                if (!factory.getClass().getPackage().getName().startsWith(forPackage)) continue;
                factories.add(factory);
            }
            return factories.build();
        }

        @Override
        public Collection<JvmBytecodeCallInterceptor> getInterceptors(MethodVisitor methodVisitor, ClassData classData) {
            ImmutableList.Builder interceptors = ImmutableList.builder();
            for (JvmBytecodeCallInterceptor.Factory factory : (List)this.factories.get()) {
                interceptors.add(factory.create(methodVisitor, (InstrumentationMetadata)classData));
            }
            return interceptors.build();
        }
    }
}

