/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.release.util.internal;

import com.liferay.release.util.ReleaseEntry;
import com.liferay.release.util.ResourceUtil;
import com.liferay.release.util.internal.ReleaseEntryImpl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ReleaseProvider {
    private final File _cacheDir;
    private final List<ReleaseEntry> _releaseEntries = new ArrayList<ReleaseEntry>();
    private final Map<String, ReleaseEntry> _releaseEntryMap = new HashMap<String, ReleaseEntry>();
    private final List<String> _releasesMirrors = new ArrayList<String>();

    public ReleaseProvider(long maxAge, List<String> releasesMirrors, File cacheDir) {
        this._cacheDir = cacheDir;
        for (String releasesMirror : releasesMirrors) {
            this._releasesMirrors.add(this._normalizeReleasesMirror(releasesMirror));
        }
        File releasesJsonFile = new File(this._cacheDir, "releases.json");
        ReleaseEntryList releaseEntries = ResourceUtil.readJSON(ReleaseEntryList.class, ResourceUtil.getLocalFileResolver(releasesJsonFile, maxAge, ChronoUnit.DAYS));
        if (releaseEntries == null) {
            String releasesMirror;
            Iterator<String> iterator = this._releasesMirrors.iterator();
            while (iterator.hasNext() && (releaseEntries = ResourceUtil.readJSON(ReleaseEntryList.class, ResourceUtil.getURLResolver(cacheDir, (releasesMirror = iterator.next()) + "/releases.json"))) == null) {
            }
        }
        if (releaseEntries == null && (releaseEntries = ResourceUtil.readJSON(ReleaseEntryList.class, ResourceUtil.getLocalFileResolver(releasesJsonFile))) != null) {
            try {
                Files.setLastModifiedTime(releasesJsonFile.toPath(), FileTime.from(Instant.now()));
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException.getMessage());
            }
        }
        if (releaseEntries == null) {
            ResourceUtil.Resolver classLoaderResolver = ResourceUtil.getClassLoaderResolver("/releases.json");
            releaseEntries = ResourceUtil.readJSON(ReleaseEntryList.class, classLoaderResolver);
            try (InputStream inputStream = classLoaderResolver.resolve();){
                Files.copy(inputStream, releasesJsonFile.toPath(), new CopyOption[0]);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
        }
        if (releaseEntries == null) {
            throw new RuntimeException("Unable to read releases.json");
        }
        for (ReleaseEntryImpl releaseEntryImpl : releaseEntries) {
            releaseEntryImpl.setPropertiesSupplier(() -> this._createReleaseProperties(releaseEntryImpl.getReleaseKey()));
            this._releaseEntries.add(releaseEntryImpl);
            this._releaseEntryMap.put(releaseEntryImpl.getReleaseKey(), releaseEntryImpl);
        }
    }

    public List<ReleaseEntry> getReleaseEntries() {
        return this._releaseEntries;
    }

    public Map<String, ReleaseEntry> getReleaseEntryMap() {
        return this._releaseEntryMap;
    }

    private Properties _createReleaseProperties(String releaseKey) {
        ReleaseEntry releaseEntry = this._releaseEntryMap.get(releaseKey);
        if (releaseEntry == null) {
            return new Properties();
        }
        String product = releaseEntry.getProduct();
        File productReleasePropertiesCacheDir = new File(new File(this._cacheDir, "releaseProperties"), String.format("%s/%s", product, releaseKey));
        Properties properties = ResourceUtil.readProperties(ResourceUtil.getLocalFileResolver(new File(productReleasePropertiesCacheDir, "release.properties")));
        if (properties == null) {
            String releasesCDNURL = releaseEntry.getURL() + "/release.properties";
            URI cdnURI = URI.create(releasesCDNURL);
            String cdnURIPath = cdnURI.getPath();
            for (String releasesMirror : this._releasesMirrors) {
                String fullMirrorPath = releasesMirror + cdnURIPath;
                properties = ResourceUtil.readProperties(ResourceUtil.getURLResolver(productReleasePropertiesCacheDir, fullMirrorPath));
                if (properties == null) continue;
                break;
            }
        }
        if (properties == null) {
            throw new RuntimeException("No release properties found for product key " + releaseKey);
        }
        return properties;
    }

    private String _normalizeReleasesMirror(String releasesMirror) {
        if (releasesMirror.endsWith("/")) {
            return releasesMirror.substring(0, releasesMirror.length() - 1);
        }
        return releasesMirror;
    }

    private static class ReleaseEntryList
    extends ArrayList<ReleaseEntryImpl> {
        private ReleaseEntryList() {
        }
    }
}

