/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.command;

import com.liferay.blade.cli.BladeCLI;
import com.liferay.blade.cli.command.BaseArgs;
import com.liferay.blade.cli.command.BaseCommand;
import com.liferay.blade.cli.command.UninstallExtensionArgs;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Objects;

public class UninstallExtensionCommand
extends BaseCommand<UninstallExtensionArgs> {
    @Override
    public void execute() throws Exception {
        UninstallExtensionArgs uninstallExtensionArgs = (UninstallExtensionArgs)this.getArgs();
        String name = uninstallExtensionArgs.getName();
        if (!Objects.nonNull(name) || name.length() <= 0 || !name.endsWith(".jar")) {
            throw new Exception("Invalid extension specified: " + name);
        }
        this._removeExtension(name);
    }

    @Override
    public Class<UninstallExtensionArgs> getArgsClass() {
        return UninstallExtensionArgs.class;
    }

    private void _removeExtension(String name) throws Exception {
        BladeCLI bladeCLI = this.getBladeCLI();
        Path extensionsHome = bladeCLI.getExtensionsPath();
        Path extensionPath = extensionsHome.resolve(name);
        Files.delete(extensionPath);
        BaseArgs baseArgs = bladeCLI.getArgs();
        if (!baseArgs.isQuiet()) {
            bladeCLI.out("The extension " + name + " has been uninstalled successfully.");
        }
    }
}

