/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.command;

import com.liferay.blade.cli.BladeCLI;
import com.liferay.blade.cli.command.BaseCommand;
import com.liferay.blade.cli.command.LocalServer;
import com.liferay.blade.cli.command.ServerStartArgs;
import com.liferay.blade.cli.util.BladeUtil;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ServerStartCommand
extends BaseCommand<ServerStartArgs> {
    @Override
    public void execute() throws Exception {
        Path logPath;
        BladeCLI bladeCLI = this.getBladeCLI();
        LocalServer localServer = this.newLocalServer(bladeCLI);
        Path liferayHomePath = localServer.getLiferayHomePath();
        if (Files.notExists(liferayHomePath, new LinkOption[0]) || BladeUtil.isDirEmpty(liferayHomePath)) {
            bladeCLI.error("Liferay home directory does not exist. Execute 'blade server init' to create it.");
            return;
        }
        String serverType = localServer.getServerType();
        if (!localServer.isSupported()) {
            bladeCLI.error(serverType + " directory cannot be found. Execute 'blade server init' to create it.");
            return;
        }
        ProcessBuilder processBuilder = localServer.newLocalServerProcess();
        List<String> commands = processBuilder.command();
        ServerStartArgs serverStartArgs = (ServerStartArgs)this.getArgs();
        Map<String, String> processBuilderEnvironment = processBuilder.environment();
        boolean tomcat = serverType.equals("tomcat");
        boolean wildfly = false;
        if (serverType.equals("jboss") || serverType.equals("wildfly")) {
            wildfly = true;
        }
        if (tomcat) {
            commands.add("start");
        } else if (wildfly) {
            processBuilderEnvironment.put("LAUNCH_JBOSS_IN_BACKGROUND", "1");
        }
        if (serverStartArgs.isDebug()) {
            String optsOriginal = null;
            if (tomcat) {
                optsOriginal = processBuilderEnvironment.getOrDefault("CATALINA_OPTS", "");
            } else if (wildfly) {
                optsOriginal = processBuilderEnvironment.getOrDefault("JAVA_OPTS", "");
            }
            if (optsOriginal != null) {
                StringBuilder opts = new StringBuilder(optsOriginal);
                if (opts.length() > 0) {
                    opts.append(" ");
                }
                String debugPortString = this._getDebugPortString(serverType);
                String suspendValue = serverStartArgs.isSuspend() ? "y" : "n";
                if (tomcat) {
                    opts.append("-agentlib:jdwp=transport=dt_socket,address=" + debugPortString + ",server=y,suspend=" + suspendValue);
                    processBuilderEnvironment.put("JAVA_OPTS", opts.toString());
                } else if (wildfly) {
                    opts.append("-Xrunjdwp:transport=dt_socket,address=" + debugPortString + ",server=y,suspend=" + suspendValue);
                    processBuilderEnvironment.put("JAVA_OPTS", opts.toString());
                }
            }
        }
        Stream stream = commands.stream();
        String shellCommand = stream.collect(Collectors.joining(" "));
        BladeUtil.setShell(processBuilder, shellCommand);
        Process process = processBuilder.start();
        BladeUtil.readProcessStream(process.getInputStream(), bladeCLI.out());
        BladeUtil.readProcessStream(process.getErrorStream(), bladeCLI.error());
        OutputStream outputStream = process.getOutputStream();
        outputStream.close();
        Optional<Path> log = localServer.getLogPath();
        boolean quiet = serverStartArgs.isQuiet();
        if (serverType.equals("tomcat")) {
            process.waitFor();
        } else {
            if (log.isPresent() && !Files.exists(logPath = log.get(), new LinkOption[0])) {
                Files.createFile(logPath, new FileAttribute[0]);
            }
            if (!quiet) {
                bladeCLI.out(serverType + " started.");
            }
        }
        if (serverStartArgs.isTail()) {
            if (log.isPresent()) {
                BladeUtil.tail(log.get(), bladeCLI.out());
            }
        } else if (log.isPresent() && !quiet) {
            logPath = log.get();
            bladeCLI.out("To view the log execute 'tail -f " + logPath.toString() + "'");
        }
    }

    @Override
    public Class<ServerStartArgs> getArgsClass() {
        return ServerStartArgs.class;
    }

    protected LocalServer newLocalServer(BladeCLI bladeCLI) {
        return new LocalServer(bladeCLI);
    }

    private String _getDebugPortString(String serverType) {
        ServerStartArgs serverStartArgs = (ServerStartArgs)this.getArgs();
        int debugPort = serverStartArgs.getDebugPort();
        if (debugPort == -1) {
            if (serverType.equals("tomcat")) {
                debugPort = 8000;
            } else if (serverType.equals("jboss") || serverType.equals("wildfly")) {
                debugPort = 8787;
            }
        }
        return String.valueOf(debugPort);
    }
}

