/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli;

import com.liferay.blade.cli.Extensions;
import com.liferay.blade.cli.util.CombinedClassLoader;
import com.liferay.blade.cli.util.FileUtil;
import com.liferay.blade.cli.util.ProcessesUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ExtensionsClassLoaderSupplier
implements AutoCloseable,
Supplier<ClassLoader> {
    private final Path _extensionsPath;
    private ClassLoader _serviceLoaderClassLoader = null;
    private Path _tempExtensionsDirectory;

    public ExtensionsClassLoaderSupplier(Path extensionsPath) {
        this._extensionsPath = extensionsPath;
    }

    @Override
    public void close() throws Exception {
        if (this._serviceLoaderClassLoader != null && this._serviceLoaderClassLoader instanceof Closeable) {
            Closeable closeable = (Closeable)((Object)this._serviceLoaderClassLoader);
            closeable.close();
        }
        if (this._tempExtensionsDirectory != null && Files.exists(this._tempExtensionsDirectory, new LinkOption[0])) {
            try {
                FileUtil.deleteDirIfExists(this._tempExtensionsDirectory);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public ClassLoader get() {
        try {
            if (this._serviceLoaderClassLoader == null) {
                long pid = ProcessesUtil.getCurrentProcessId();
                this._tempExtensionsDirectory = Files.createTempDirectory("blade-extensions-" + pid + "-", new FileAttribute[0]);
                FileUtil.copyDir(this._extensionsPath, this._tempExtensionsDirectory);
                this._extractBladeExtensions(this._tempExtensionsDirectory);
                URL[] jarUrls = this._getJarUrls(this._tempExtensionsDirectory);
                Thread thread = Thread.currentThread();
                ClassLoader currentClassLoader = thread.getContextClassLoader();
                URLClassLoader urlClassLoader = new URLClassLoader(jarUrls, this.getClass().getClassLoader());
                this._serviceLoaderClassLoader = new CombinedClassLoader(currentClassLoader, urlClassLoader);
            }
            return this._serviceLoaderClassLoader;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    private static URL _convertUriToUrl(URI uri) {
        try {
            return uri.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private void _extractBladeExtensions(Path extensionsDirectory) throws IOException {
        try (InputStream inputStream = Extensions.class.getResourceAsStream("/blade-extensions-versions.properties");){
            if (inputStream == null) {
                return;
            }
            Properties properties = new Properties();
            properties.load(inputStream);
            Set<Object> keySet = properties.keySet();
            ClassLoader classLoader = Extensions.class.getClassLoader();
            try {
                HashSet<String> extensions = new HashSet<String>();
                for (Object key : keySet) {
                    String extension = key.toString() + "-" + properties.getProperty(key.toString()) + ".jar";
                    if (extension.startsWith("com.liferay.project.templates")) continue;
                    if (classLoader.getResource(extension) != null) {
                        extensions.add(extension);
                        continue;
                    }
                    System.err.println("Warning: Unable to locate " + extension);
                }
                for (String extension : extensions) {
                    try {
                        InputStream extensionInputStream = classLoader.getResourceAsStream(extension);
                        Throwable throwable = null;
                        try {
                            Path extensionPath = extensionsDirectory.resolve(extension);
                            Files.copy(extensionInputStream, extensionPath, StandardCopyOption.REPLACE_EXISTING);
                        }
                        catch (Throwable extensionPath) {
                            throwable = extensionPath;
                            throw extensionPath;
                        }
                        finally {
                            if (extensionInputStream == null) continue;
                            if (throwable != null) {
                                try {
                                    extensionInputStream.close();
                                }
                                catch (Throwable extensionPath) {
                                    throwable.addSuppressed(extensionPath);
                                }
                                continue;
                            }
                            extensionInputStream.close();
                        }
                    }
                    catch (Throwable throwable) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("Error encountered while loading custom extensions.");
                        sb.append(System.lineSeparator());
                        sb.append(throwable.getMessage());
                        sb.append(System.lineSeparator());
                        sb.append("Not loading extension " + extension + ".");
                        sb.append(System.lineSeparator());
                        String errorString = sb.toString();
                        System.err.println(errorString);
                    }
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                StringBuilder sb = new StringBuilder();
                sb.append("Error encountered while loading custom extensions.");
                sb.append(System.lineSeparator());
                sb.append(noSuchElementException.getMessage());
                sb.append(System.lineSeparator());
                sb.append("Only built-in commands will be recognized.");
                sb.append(System.lineSeparator());
                String errorString = sb.toString();
                System.err.println(errorString);
            }
            catch (Throwable throwable) {
                String errorMessage = "Error encountered while loading custom extensions." + System.lineSeparator();
                throw new RuntimeException(errorMessage, throwable);
            }
        }
    }

    private URL[] _getJarUrls(Path jarsPath) throws IOException {
        try (Stream<Path> files = Files.list(jarsPath);){
            URL[] uRLArray = files.filter(path -> {
                String file = path.toString();
                return file.endsWith(".jar");
            }).map(Path::toUri).map(ExtensionsClassLoaderSupplier::_convertUriToUrl).filter(url -> url != null).collect(Collectors.toSet()).toArray(new URL[0]);
            return uRLArray;
        }
    }
}

