/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.command;

import com.liferay.blade.cli.TestUtil;
import java.io.File;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class DeployCommandTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File _extensionsDir = null;

    @Before
    public void setUp() throws Exception {
        this._extensionsDir = this.temporaryFolder.newFolder(new String[]{".blade", "extensions"});
    }

    @Test
    public void testInstallJar() throws Exception {
        File workspaceDir = this.temporaryFolder.newFolder();
        String[] args = new String[]{"--base", workspaceDir.getPath(), "init", "-v", "portal-7.4-ga107"};
        TestUtil.runBlade(workspaceDir, this._extensionsDir, args);
        args = new String[]{"--base", workspaceDir.getPath(), "server", "init"};
        TestUtil.runBlade(workspaceDir, this._extensionsDir, args);
        File bundlesDirectory = new File(workspaceDir.getPath(), "bundles");
        Assert.assertTrue((boolean)bundlesDirectory.exists());
        File osgiDirectory = new File(bundlesDirectory, "osgi");
        Assert.assertTrue((boolean)osgiDirectory.exists());
        File osgiModulesDirectory = new File(osgiDirectory, "modules");
        Assert.assertTrue((boolean)osgiModulesDirectory.exists());
        String[] osgiModulesDirectoryList = osgiModulesDirectory.list();
        int filesCount = osgiModulesDirectoryList.length;
        Assert.assertEquals((long)0L, (long)filesCount);
        File modulesDirectory = new File(workspaceDir, "modules");
        Assert.assertTrue((boolean)modulesDirectory.exists());
        args = new String[]{"--base", modulesDirectory.getAbsolutePath(), "create", "-t", "mvc-portlet", "foo"};
        TestUtil.runBlade(workspaceDir, this._extensionsDir, args);
        File projectDirectory = new File(modulesDirectory, "foo");
        Assert.assertTrue((boolean)projectDirectory.exists());
        args = new String[]{"--base", projectDirectory.getAbsolutePath(), "deploy"};
        TestUtil.runBlade(workspaceDir, this._extensionsDir, args);
        osgiModulesDirectoryList = osgiModulesDirectory.list();
        filesCount = osgiModulesDirectoryList.length;
        Assert.assertEquals((long)1L, (long)filesCount);
    }

    @Test
    public void testInstallWar() throws Exception {
        File workspaceDir = this.temporaryFolder.newFolder();
        String[] args = new String[]{"--base", workspaceDir.getPath(), "init", "-v", "portal-7.4-ga107"};
        TestUtil.runBlade(workspaceDir, this._extensionsDir, args);
        args = new String[]{"--base", workspaceDir.getPath(), "server", "init"};
        TestUtil.runBlade(workspaceDir, this._extensionsDir, args);
        File bundlesDirectory = new File(workspaceDir.getPath(), "bundles");
        Assert.assertTrue((boolean)bundlesDirectory.exists());
        File deployDirectory = new File(bundlesDirectory, "deploy");
        Assert.assertTrue((boolean)deployDirectory.exists());
        String[] deployDirectoryList = deployDirectory.list();
        int filesCount = deployDirectoryList.length;
        Assert.assertEquals((long)0L, (long)filesCount);
        File modulesDirectory = new File(workspaceDir, "modules");
        Assert.assertTrue((boolean)modulesDirectory.exists());
        args = new String[]{"create", "--base", workspaceDir.getAbsolutePath(), "-t", "war-mvc-portlet", "foo"};
        TestUtil.runBlade(modulesDirectory, this._extensionsDir, args);
        File projectDirectory = new File(modulesDirectory, "foo");
        Assert.assertTrue((boolean)projectDirectory.exists());
        args = new String[]{"--base", projectDirectory.getAbsolutePath(), "deploy"};
        TestUtil.runBlade(workspaceDir, this._extensionsDir, args);
        deployDirectoryList = deployDirectory.list();
        filesCount = deployDirectoryList.length;
        Assert.assertEquals((long)1L, (long)filesCount);
    }
}

