/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.internal.impldep.com.google.common.collect.ForwardingSet;
import org.gradle.internal.impldep.com.google.common.collect.Iterators;

class AccessTrackingSet<E>
extends ForwardingSet<E> {
    private final Set<? extends E> delegate;
    private final Listener listener;
    private final Function<E, E> factory;

    public AccessTrackingSet(Set<? extends E> delegate, Listener listener) {
        this(delegate, listener, Function.identity());
    }

    public AccessTrackingSet(Set<? extends E> delegate, Listener listener, Function<E, E> factory) {
        this.delegate = delegate;
        this.listener = listener;
        this.factory = factory;
    }

    @Override
    public boolean contains(@Nullable Object o) {
        boolean result = this.delegate.contains(o);
        this.listener.onAccess(o);
        return result;
    }

    @Override
    public boolean containsAll(@Nonnull Collection<?> collection) {
        boolean result = this.delegate.containsAll(collection);
        for (Object o : collection) {
            this.listener.onAccess(o);
        }
        return result;
    }

    @Override
    public boolean remove(Object o) {
        this.listener.onAccess(o);
        this.listener.onRemove(o);
        return this.delegate.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        for (Object o : collection) {
            this.listener.onAccess(o);
            this.listener.onRemove(o);
        }
        return this.delegate.removeAll(collection);
    }

    @Override
    public void clear() {
        this.delegate.clear();
        this.listener.onClear();
    }

    @Override
    public Iterator<E> iterator() {
        this.reportAggregatingAccess();
        return Iterators.transform(this.delegate().iterator(), this.factory::apply);
    }

    @Override
    public int size() {
        this.reportAggregatingAccess();
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        this.reportAggregatingAccess();
        return this.delegate.isEmpty();
    }

    @Override
    public boolean equals(@Nullable Object object) {
        this.reportAggregatingAccess();
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        this.reportAggregatingAccess();
        return super.hashCode();
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[0]);
    }

    @Override
    public <T> T[] toArray(T[] array) {
        this.reportAggregatingAccess();
        T[] result = this.delegate().toArray(array);
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.factory.apply(result[i]);
        }
        return result;
    }

    @Override
    protected Set<E> delegate() {
        return this.delegate;
    }

    private void reportAggregatingAccess() {
        this.listener.onAggregatingAccess();
    }

    public static interface Listener {
        public void onAccess(Object var1);

        public void onAggregatingAccess();

        public void onRemove(Object var1);

        public void onClear();
    }
}

