/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.JavaVersion;
import org.gradle.api.internal.ClassPathProvider;
import org.gradle.api.internal.classpath.Module;
import org.gradle.api.internal.classpath.ModuleRegistry;
import org.gradle.api.internal.classpath.PluginModuleRegistry;
import org.gradle.api.specs.Spec;
import org.gradle.internal.classpath.ClassPath;

public class DynamicModulesClassPathProvider
implements ClassPathProvider {
    private final ModuleRegistry moduleRegistry;
    private final PluginModuleRegistry pluginModuleRegistry;
    private final JavaVersion javaVersion;
    private static final String[] GRADLE_EXTENSION_MODULES = new String[]{"gradle-workers", "gradle-dependency-management", "gradle-plugin-use"};
    private static final String[] GRADLE_OPTIONAL_EXTENSION_MODULES = new String[]{"gradle-kotlin-dsl-provider-plugins", "gradle-kotlin-dsl-tooling-builders"};

    public DynamicModulesClassPathProvider(ModuleRegistry moduleRegistry, PluginModuleRegistry pluginModuleRegistry) {
        this(moduleRegistry, pluginModuleRegistry, JavaVersion.current());
    }

    @VisibleForTesting
    protected DynamicModulesClassPathProvider(ModuleRegistry moduleRegistry, PluginModuleRegistry pluginModuleRegistry, JavaVersion javaVersion) {
        this.moduleRegistry = moduleRegistry;
        this.pluginModuleRegistry = pluginModuleRegistry;
        this.javaVersion = javaVersion;
    }

    @Override
    public ClassPath findClassPath(String name) {
        if (name.equals("GRADLE_EXTENSIONS")) {
            return this.gradleExtensionsWithout("gradle-core");
        }
        if (name.equals("GRADLE_WORKER_EXTENSIONS")) {
            return this.gradleExtensionsWithout("gradle-core", "gradle-workers", "gradle-dependency-management");
        }
        return null;
    }

    private ClassPath gradleExtensionsWithout(String ... modulesToExclude) {
        Set<Module> coreModules = this.allRequiredModulesOf(modulesToExclude);
        ClassPath classpath = ClassPath.EMPTY;
        for (String moduleName : GRADLE_EXTENSION_MODULES) {
            Set<Module> extensionModules = this.allRequiredModulesOf(moduleName);
            classpath = this.plusExtensionModules(classpath, extensionModules, coreModules);
        }
        for (String moduleName : GRADLE_OPTIONAL_EXTENSION_MODULES) {
            Set<Module> optionalExtensionModules = this.allRequiredModulesOfOptional(moduleName);
            classpath = this.plusExtensionModules(classpath, optionalExtensionModules, coreModules);
        }
        for (Module pluginModule : this.pluginModuleRegistry.getApiModules()) {
            classpath = classpath.plus(pluginModule.getClasspath());
        }
        for (Module pluginModule : this.pluginModuleRegistry.getImplementationModules()) {
            classpath = classpath.plus(pluginModule.getClasspath());
        }
        return this.removeJaxbIfIncludedInCurrentJdk(classpath);
    }

    private ClassPath removeJaxbIfIncludedInCurrentJdk(ClassPath classpath) {
        if (!this.javaVersion.isJava9Compatible()) {
            return classpath.removeIf((Spec<? super File>)new Spec<File>(){

                @Override
                public boolean isSatisfiedBy(File file) {
                    return file.getName().startsWith("jaxb-impl-");
                }
            });
        }
        return classpath;
    }

    private Set<Module> allRequiredModulesOf(String ... names) {
        HashSet modules = Sets.newHashSet();
        for (String name : names) {
            modules.addAll(this.moduleRegistry.getModule(name).getAllRequiredModules());
        }
        return modules;
    }

    private Set<Module> allRequiredModulesOfOptional(String moduleName) {
        Module optionalModule = this.moduleRegistry.findModule(moduleName);
        if (optionalModule != null) {
            return optionalModule.getAllRequiredModules();
        }
        return Collections.emptySet();
    }

    private ClassPath plusExtensionModules(ClassPath classpath, Set<Module> extensionModules, Set<Module> coreModules) {
        for (Module module : extensionModules) {
            if (coreModules.contains(module)) continue;
            classpath = classpath.plus(module.getClasspath());
        }
        return classpath;
    }
}

