/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.gradle.tooling;

import com.liferay.blade.gradle.tooling.DefaultModel;
import com.liferay.blade.gradle.tooling.ProjectInfo;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.PublishArtifactSet;
import org.gradle.api.file.FileCollection;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.tasks.TaskOutputs;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public class ProjectInfoPlugin
implements Plugin<Project> {
    private final ToolingModelBuilderRegistry _toolingModelBuilderRegistry;

    @Inject
    public ProjectInfoPlugin(ToolingModelBuilderRegistry toolingModelBuilderRegistry) {
        this._toolingModelBuilderRegistry = toolingModelBuilderRegistry;
    }

    @Override
    public void apply(Project project) {
        this._toolingModelBuilderRegistry.register(new ProjectInfoBuilder());
    }

    private static class ProjectInfoBuilder
    implements ToolingModelBuilder {
        private ProjectInfoBuilder() {
        }

        @Override
        public Object buildAll(String modelName, Project project) {
            HashSet<String> pluginClassNames = new HashSet<String>();
            for (Plugin plugin : project.getPlugins()) {
                Class<?> clazz = plugin.getClass();
                pluginClassNames.add(clazz.getName());
            }
            Set<Task> buildTasks = project.getTasksByName("build", true);
            Set<Task> jarTasks = project.getTasksByName("jar", true);
            HashSet<Task> tasks = new HashSet<Task>();
            tasks.addAll(buildTasks);
            tasks.addAll(jarTasks);
            HashMap<String, Set<File>> projectOutputFiles = new HashMap<String, Set<File>>();
            for (Task task : tasks) {
                Project taskProject = task.getProject();
                String projectPath = taskProject.getPath();
                TaskOutputs outputs = task.getOutputs();
                FileCollection fileCollection = outputs.getFiles();
                Set files = fileCollection.getFiles();
                Set outputFiles = projectOutputFiles.computeIfAbsent(projectPath, p -> new HashSet());
                outputFiles.addAll(files);
            }
            ExtensionContainer liferayExtensionContainer = project.getExtensions();
            Object liferayExtension = liferayExtensionContainer.findByName("liferay");
            String liferayHome = null;
            String deployDir = null;
            if (Objects.nonNull(liferayExtension)) {
                liferayHome = this._getExtensionProperty(liferayExtension, "liferayHome");
                deployDir = this._getExtensionProperty(liferayExtension, "deployDir");
            }
            Project rootProject = project.getRootProject();
            Gradle workspaceExtensionAware = rootProject.getGradle();
            ExtensionContainer workspaceExtensionContainer = workspaceExtensionAware.getExtensions();
            Object workspaceExtension = workspaceExtensionContainer.findByName("liferayWorkspace");
            String dockerImageLiferay = null;
            String dockerImageId = null;
            String dockerContainerId = null;
            if (Objects.nonNull(workspaceExtension)) {
                dockerImageLiferay = this._getExtensionProperty(workspaceExtension, "dockerImageLiferay");
                dockerImageId = this._getExtensionProperty(workspaceExtension, "dockerImageId");
                dockerContainerId = this._getExtensionProperty(workspaceExtension, "dockerContainerId");
            }
            try {
                ConfigurationContainer configurations = project.getConfigurations();
                Configuration archivesConfiguration = configurations.getByName("archives");
                PublishArtifactSet artifacts = archivesConfiguration.getArtifacts();
                FileCollection fileCollection = artifacts.getFiles();
                Set files = fileCollection.getFiles();
                Set outputFiles = projectOutputFiles.computeIfAbsent(project.getPath(), p -> new HashSet());
                outputFiles.addAll(files);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new DefaultModel(pluginClassNames, projectOutputFiles, deployDir, liferayHome, dockerImageLiferay, dockerImageId, dockerContainerId);
        }

        @Override
        public boolean canBuild(String modelName) {
            return modelName.equals(ProjectInfo.class.getName());
        }

        private String _getExtensionProperty(Object extension, String property) {
            if (extension != null) {
                Class<?> clazz = extension.getClass();
                try {
                    BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
                    for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
                        String propertyDescriptorName = propertyDescriptor.getName();
                        Method method = propertyDescriptor.getReadMethod();
                        if (method == null || !property.equals(propertyDescriptorName)) continue;
                        Object value = method.invoke(extension, new Object[0]);
                        return String.valueOf(value);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

