/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.util;

import com.liferay.release.util.ReleaseEntry;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ReleaseUtil
extends com.liferay.release.util.ReleaseUtil {
    public static ReleaseEntry getReleaseEntry(String version) {
        return ReleaseUtil.getReleaseEntry(null, version);
    }

    public static ReleaseEntry getReleaseEntry(String product, String version) {
        Predicate<ReleaseEntry> productGroupVersionPredicate = releaseEntry -> Objects.equals(releaseEntry.getProductGroupVersion(), version);
        Predicate<ReleaseEntry> productPredicate = releaseEntry -> Objects.equals(releaseEntry.getProduct(), product);
        Predicate<ReleaseEntry> targetPlatformVersionPredicate = releaseEntry -> Objects.equals(releaseEntry.getTargetPlatformVersion(), version);
        ArrayList<Predicate<ReleaseEntry>> predicates = new ArrayList<Predicate<ReleaseEntry>>();
        predicates.add(releaseEntry -> Objects.equals(releaseEntry.getReleaseKey(), version));
        predicates.add(productPredicate.and(targetPlatformVersionPredicate));
        predicates.add(productPredicate.and(productGroupVersionPredicate));
        predicates.add(targetPlatformVersionPredicate);
        predicates.add(productGroupVersionPredicate);
        for (Predicate predicate : predicates) {
            Optional<ReleaseEntry> first = ReleaseUtil.getReleaseEntryStream().filter(predicate).findFirst();
            if (!first.isPresent()) continue;
            return first.get();
        }
        return null;
    }
}

