/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.util;

import java.io.PrintStream;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.fusesource.jansi.Ansi;

public class AnsiLinePrinter {
    private static final Pattern[] _BRIGHT_GREEN_LINE_PATTERNS = new Pattern[]{Pattern.compile(".*STOPPED.*")};
    private static final Pattern[] _BRIGHT_RED_LINE_PATTERNS = new Pattern[]{Pattern.compile("^Error.*"), Pattern.compile(".*ERROR.*"), Pattern.compile(".*FATAL.*")};
    private static final Pattern[] _GREEN_LINE_PATTERNS = new Pattern[]{Pattern.compile(".*STARTED.*")};
    private static final Pattern[] _YELLOW_LINE_PATTERNS = new Pattern[]{Pattern.compile(".*WARN.*")};

    public static void println(PrintStream printStream, String line) {
        AtomicBoolean printed = new AtomicBoolean(false);
        Consumer<Ansi> println = ansi -> {
            printed.set(true);
            printStream.println(ansi);
        };
        AnsiLinePrinter._print(_BRIGHT_RED_LINE_PATTERNS, line, AnsiLinePrinter._toAnsiColor(Ansi::fgBrightRed), println);
        AnsiLinePrinter._print(_BRIGHT_GREEN_LINE_PATTERNS, line, AnsiLinePrinter._toAnsiColor(Ansi::fgBrightGreen), println);
        AnsiLinePrinter._print(_YELLOW_LINE_PATTERNS, line, AnsiLinePrinter._toAnsiColor(Ansi::fgYellow), println);
        AnsiLinePrinter._print(_GREEN_LINE_PATTERNS, line, AnsiLinePrinter._toAnsiColor(Ansi::fgGreen), println);
        if (!printed.get()) {
            printStream.println(line);
        }
    }

    private static void _print(Pattern[] patterns, String line, Function<? super String, ? extends Ansi> toAnsi, Consumer<? super Ansi> println) {
        Stream.of(patterns).map(pattern -> pattern.matcher(line)).filter(Matcher::matches).findAny().map(matcher -> line).map(toAnsi).ifPresent(println);
    }

    private static Function<? super String, ? extends Ansi> _toAnsiColor(Function<Ansi, Ansi> colorizer) {
        return line -> ((Ansi)colorizer.apply(Ansi.ansi())).a((String)line).reset();
    }
}

