/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.jmx;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.function.Consumer;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class JMXLocalConnector {
    protected MBeanServerConnection mBeanServerConnection;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLocalConnectorAddress(String objName, Consumer<String> logger) {
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        ClassLoader toolsClassLoader = null;
        try {
            toolsClassLoader = JMXLocalConnector._getToolsClassLoader(classLoader);
            if (toolsClassLoader != null) {
                thread.setContextClassLoader(toolsClassLoader);
                logger.accept("Trying to load VirtualMachine class...");
                Class<?> vmClass = toolsClassLoader.loadClass("com.sun.tools.attach.VirtualMachine");
                Method listMethod = vmClass.getMethod("list", new Class[0]);
                List vmds = (List)listMethod.invoke(null, new Object[0]);
                logger.accept("Found " + vmds.size() + " vms on this machine.");
                for (Object vmd : vmds) {
                    String localConnectorAddress = JMXLocalConnector._attach(toolsClassLoader, vmClass, vmd, objName, logger);
                    if (localConnectorAddress != null) {
                        logger.accept("Using localConnectorAddress=" + localConnectorAddress);
                        String string = localConnectorAddress;
                        return string;
                    }
                    logger.accept("Could not find " + objName + " in this vm.");
                }
            }
        }
        catch (Exception nl) {
        }
        finally {
            thread.setContextClassLoader(classLoader);
            try {
                if (toolsClassLoader != null) {
                    Field nl = ClassLoader.class.getDeclaredField("nativeLibraries");
                    nl.setAccessible(true);
                    Vector nativeLibs = (Vector)nl.get(toolsClassLoader);
                    for (Object nativeLib : nativeLibs) {
                        Class<?> clazz = nativeLib.getClass();
                        Field nameField = clazz.getDeclaredField("name");
                        nameField.setAccessible(true);
                        String name = (String)nameField.get(nativeLib);
                        File nativeLibFile = new File(name);
                        String nativeLibFileName = nativeLibFile.getName();
                        if (!nativeLibFileName.contains("attach")) continue;
                        Method f = clazz.getDeclaredMethod("finalize", new Class[0]);
                        f.setAccessible(true);
                        f.invoke(nativeLib, new Object[0]);
                    }
                }
            }
            catch (Exception nl) {}
        }
        return null;
    }

    public JMXLocalConnector(int port) throws MalformedURLException {
        this(new JMXServiceURL("service:jmx:rmi:///jndi/rmi://:" + port + "/jmxrmi"));
    }

    public JMXLocalConnector(JMXServiceURL serviceUrl) {
        try {
            JMXConnector jmxConnector = JMXConnectorFactory.connect(serviceUrl, null);
            this.mBeanServerConnection = jmxConnector.getMBeanServerConnection();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Unable to get JMX connection", exception);
        }
    }

    public JMXLocalConnector(String objectName, Consumer<String> logger) throws MalformedURLException {
        this(new JMXServiceURL(JMXLocalConnector.getLocalConnectorAddress(objectName, logger)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String _attach(ClassLoader toolsClassLoader, Class<?> vmClass, Object vmd, String name, Consumer<String> logger) {
        try {
            Class<?> vmdClass = toolsClassLoader.loadClass("com.sun.tools.attach.VirtualMachineDescriptor");
            Method idMethod = vmdClass.getMethod("id", new Class[0]);
            String id = (String)idMethod.invoke(vmd, new Object[0]);
            logger.accept("Found vm id of " + id + ". Trying to attach...");
            Method attachMethod = vmClass.getMethod("attach", String.class);
            Object vm = attachMethod.invoke(null, id);
            logger.accept("Attached to vm = " + vm);
            try {
                Method getAgentProperties = vmClass.getMethod("getAgentProperties", new Class[0]);
                Properties agentProperties = (Properties)getAgentProperties.invoke(vm, new Object[0]);
                String localConnectorAddress = agentProperties.getProperty("com.sun.management.jmxremote.localConnectorAddress");
                logger.accept("Trying to get localConnectorAddress=" + localConnectorAddress);
                if (localConnectorAddress == null) {
                    logger.accept("localConnectorAdress is null, trying to load management-agent.jar.");
                    File agentJar = JMXLocalConnector._findJdkJar("management-agent.jar");
                    if (agentJar != null) {
                        logger.accept("Found agent jar = " + agentJar);
                        Method loadAgent = vmClass.getMethod("loadAgent", String.class);
                        logger.accept("Invoking loadAgent...");
                        loadAgent.invoke(vm, agentJar.getCanonicalPath());
                        logger.accept("Managemet agent loaded, trying to find localConnectorAddress");
                        agentProperties = (Properties)getAgentProperties.invoke(vm, new Object[0]);
                        localConnectorAddress = agentProperties.getProperty("com.sun.management.jmxremote.localConnectorAddress");
                    } else {
                        logger.accept("Could not find management-agent.jar at location " + agentJar);
                    }
                }
                if (localConnectorAddress == null) return null;
                logger.accept("Found localConnectorAddress=" + localConnectorAddress);
                JMXServiceURL jmxServiceURL = new JMXServiceURL(localConnectorAddress);
                JMXConnector jmxConnector = JMXConnectorFactory.connect(jmxServiceURL, null);
                logger.accept("Getting mbean server connection...");
                MBeanServerConnection mBeanServerConnection = jmxConnector.getMBeanServerConnection();
                if (mBeanServerConnection == null) return null;
                logger.accept("querying for objectname " + name);
                ObjectName objectName = JMXLocalConnector._getObjectName(name, mBeanServerConnection);
                logger.accept("found objectName = " + objectName);
                if (objectName == null) return null;
                String string = localConnectorAddress;
                return string;
            }
            catch (Exception detachMethod222) {
                return null;
            }
            finally {
                Method detachMethod = vmClass.getMethod("detach", new Class[0]);
                detachMethod.invoke(vm, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static File _findJdkJar(String jar) throws IOException {
        File retval = null;
        String jarPath = File.separator + "lib" + File.separator + jar;
        String javaHome = System.getProperty("java.home");
        File jarFile = new File(javaHome + jarPath);
        if (jarFile.exists()) {
            retval = jarFile;
        } else {
            jarFile = new File(javaHome + "/.." + jarPath);
            if (jarFile.exists()) {
                retval = jarFile.getCanonicalFile();
            }
        }
        return retval;
    }

    private static ObjectName _getObjectName(String objectNameValue, MBeanServerConnection mBeanServerConnection) throws IOException, MalformedObjectNameException {
        ObjectName objectName = new ObjectName(objectNameValue);
        Set<ObjectName> objectNames = mBeanServerConnection.queryNames(objectName, null);
        if (objectNames != null && !objectNames.isEmpty()) {
            Iterator<ObjectName> iterator = objectNames.iterator();
            return iterator.next();
        }
        return null;
    }

    private static ClassLoader _getToolsClassLoader(ClassLoader parent) throws IOException {
        File toolsJar = JMXLocalConnector._findJdkJar("tools.jar");
        if (toolsJar != null && toolsJar.exists()) {
            URL toolsURL = null;
            try {
                URI toolsURI = toolsJar.toURI();
                toolsURL = toolsURI.toURL();
            }
            catch (MalformedURLException toolsURI) {
                // empty catch block
            }
            URL[] urls = new URL[]{toolsURL};
            return new URLClassLoader(urls, parent);
        }
        throw new IOException("Could not find tools.jar in JDK at this location: " + toolsJar);
    }
}

