/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.command;

import com.liferay.blade.cli.BladeCLI;
import com.liferay.blade.cli.command.BaseCommand;
import com.liferay.blade.cli.command.VersionArgs;
import com.liferay.blade.cli.util.BladeUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.Objects;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class VersionCommand
extends BaseCommand<VersionArgs> {
    public static String getBladeCLIVersion() throws IOException {
        block29: {
            Path path = BladeUtil.getBladeJarPath();
            if (Files.isDirectory(path, new LinkOption[0])) {
                Path manifestPath = path.resolve("META-INF/MANIFEST.MF");
                try (InputStream inputStream = Files.newInputStream(manifestPath, new OpenOption[0]);){
                    Manifest manifest = new Manifest(inputStream);
                    String version = VersionCommand._getVersionFromManifest(manifest);
                    if (version != null) {
                        String string = version;
                        return string;
                    }
                    break block29;
                }
            }
            ClassLoader classLoader = BladeCLI.class.getClassLoader();
            Enumeration<URL> resources = classLoader.getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                InputStream inputStream = url.openStream();
                Throwable throwable = null;
                try {
                    Manifest manifest = new Manifest(inputStream);
                    String version = VersionCommand._getVersionFromManifest(manifest);
                    if (version == null) continue;
                    String string = version;
                    return string;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
        }
        return null;
    }

    public VersionCommand() {
    }

    public VersionCommand(BladeCLI bladeCLI) {
        this.setBlade(bladeCLI);
    }

    @Override
    public void execute() throws Exception {
        BladeCLI bladeCLI = this.getBladeCLI();
        String bladeCLIVersion = VersionCommand.getBladeCLIVersion();
        if (bladeCLIVersion == null) {
            bladeCLI.error("Could not determine version.");
        } else {
            bladeCLI.out("blade version " + bladeCLIVersion);
        }
    }

    @Override
    public Class<VersionArgs> getArgsClass() {
        return VersionArgs.class;
    }

    private static String _getVersionFromManifest(Manifest manifest) {
        Attributes attributes = manifest.getMainAttributes();
        String bundleSymbolicName = attributes.getValue("Bundle-SymbolicName");
        if (Objects.equals(bundleSymbolicName, "com.liferay.blade.cli")) {
            return attributes.getValue("Bundle-Version");
        }
        return null;
    }
}

