/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.command;

import com.liferay.blade.cli.BladeCLI;
import com.liferay.blade.cli.WorkspaceProvider;
import com.liferay.blade.cli.command.BaseCommand;
import com.liferay.blade.cli.command.DeployArgs;
import com.liferay.blade.cli.gradle.GradleExec;
import com.liferay.blade.cli.gradle.ProcessResult;
import java.io.File;
import java.util.Collections;

public class DeployCommand
extends BaseCommand<DeployArgs> {
    @Override
    public void execute() throws Exception {
        BladeCLI bladeCLI = this.getBladeCLI();
        GradleExec gradleExec = new GradleExec(bladeCLI);
        DeployArgs deployArgs = (DeployArgs)this.getArgs();
        File baseDir = deployArgs.getBase();
        WorkspaceProvider workspaceProvider = bladeCLI.getWorkspaceProvider(baseDir);
        if (workspaceProvider != null) {
            this._deploy(gradleExec, "deploy");
        } else {
            this._deploy(gradleExec, "clean deploy");
        }
    }

    @Override
    public Class<DeployArgs> getArgsClass() {
        return DeployArgs.class;
    }

    private void _addError(String msg) {
        BladeCLI bladeCLI = this.getBladeCLI();
        bladeCLI.addErrors("deploy", Collections.singleton(msg));
    }

    private void _deploy(GradleExec gradle, String command) throws Exception {
        DeployArgs deployArgs = (DeployArgs)this.getArgs();
        File baseDir = deployArgs.getBase();
        ProcessResult processResult = gradle.executeTask(command, baseDir, false);
        int resultCode = processResult.getResultCode();
        if (resultCode > 0) {
            this._addError("Gradle \"" + command + "\" task failed.");
            return;
        }
        if (!deployArgs.isQuiet()) {
            String output = "Gradle \"" + command + "\" task succeeded.";
            BladeCLI bladeCLI = this.getBladeCLI();
            bladeCLI.out(output);
        }
    }
}

