/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.jvm;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.gradle.api.JavaVersion;
import org.gradle.internal.FileUtils;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.impldep.com.google.common.base.Optional;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.jvm.JavaHomeException;
import org.gradle.internal.jvm.JavaInfo;
import org.gradle.internal.os.OperatingSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jvm
implements JavaInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(Jvm.class);
    private static final HashSet<String> VENDOR_PROPERTIES = Sets.newHashSet("java.vendor", "java.vm.vendor");
    private static final AtomicReference<Jvm> CURRENT = new AtomicReference();
    private static final Pattern APP_NAME_REGEX = Pattern.compile("APP_NAME_\\d+");
    private static final Pattern JAVA_MAIN_CLASS_REGEX = Pattern.compile("JAVA_MAIN_CLASS_\\d+");
    private final OperatingSystem os;
    private final File javaBase;
    private final File javaHome;
    private final boolean userSupplied;
    private final String implementationJavaVersion;
    private final JavaVersion javaVersion;
    private File javaExecutable;
    private File javacExecutable;
    private File javadocExecutable;
    private Optional<File> toolsJar;
    private Boolean jdk;

    public static Jvm current() {
        Jvm jvm = CURRENT.get();
        if (jvm == null) {
            CURRENT.compareAndSet(null, new Jvm(OperatingSystem.current()));
            jvm = CURRENT.get();
        }
        return jvm;
    }

    private static Jvm create(File javaBase, @Nullable String implementationJavaVersion, @Nullable JavaVersion javaVersion) {
        Jvm jvm = new Jvm(OperatingSystem.current(), javaBase, implementationJavaVersion, javaVersion);
        Jvm current = Jvm.current();
        return jvm.getJavaHome().equals(current.getJavaHome()) ? current : jvm;
    }

    Jvm(OperatingSystem os) {
        this(os, FileUtils.canonicalize(new File(System.getProperty("java.home"))), System.getProperty("java.version"), JavaVersion.current(), false);
    }

    Jvm(OperatingSystem os, File suppliedJavaBase, String implementationJavaVersion, JavaVersion javaVersion) {
        this(os, suppliedJavaBase, implementationJavaVersion, javaVersion, true);
    }

    private Jvm(OperatingSystem os, File suppliedJavaBase, String implementationJavaVersion, JavaVersion javaVersion, boolean userSupplied) {
        this.os = os;
        this.javaBase = suppliedJavaBase;
        this.implementationJavaVersion = implementationJavaVersion;
        this.javaVersion = javaVersion;
        this.userSupplied = userSupplied;
        this.javaHome = this.findJavaHome(suppliedJavaBase);
    }

    public static JavaInfo forHome(File javaHome) throws JavaHomeException, IllegalArgumentException {
        if (javaHome == null || !javaHome.isDirectory()) {
            throw new IllegalArgumentException("Supplied javaHome must be a valid directory. You supplied: " + javaHome);
        }
        Jvm jvm = Jvm.create(javaHome, null, null);
        jvm.getJavaExecutable();
        return jvm;
    }

    public static Jvm discovered(File javaHome, String implementationJavaVersion, JavaVersion javaVersion) {
        return Jvm.create(javaHome, implementationJavaVersion, javaVersion);
    }

    public String toString() {
        if (this.userSupplied) {
            return "User-supplied java: " + this.javaBase;
        }
        return SystemProperties.getInstance().getJavaVersion() + " (" + System.getProperty("java.vm.vendor") + " " + System.getProperty("java.vm.version") + ")";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Jvm other = (Jvm)obj;
        return other.javaHome.equals(this.javaHome);
    }

    public int hashCode() {
        return this.javaHome.hashCode();
    }

    public boolean isJdk() {
        if (this.jdk == null) {
            this.jdk = this.findExecutableInJavaHome("javac") != null;
        }
        return this.jdk;
    }

    @Nullable
    private File findExecutableInJavaHome(String command) {
        File executable = this.commandLocation(command);
        if (executable.isFile()) {
            return executable;
        }
        return null;
    }

    private File commandLocation(String command) {
        File exec = new File(this.getJavaHome(), "bin/" + command);
        return new File(this.os.getExecutableName(exec.getAbsolutePath()));
    }

    private File findExecutable(String command) {
        File executable = this.commandLocation(command);
        if (executable.isFile()) {
            return executable;
        }
        if (this.userSupplied) {
            throw new JavaHomeException(String.format("The supplied javaHome seems to be invalid. I cannot find the %s executable. Tried location: %s", command, executable.getAbsolutePath()));
        }
        File pathExecutable = this.os.findInPath(command);
        if (pathExecutable != null) {
            LOGGER.info(String.format("Unable to find the '%s' executable using home: %s. We found it on the PATH: %s.", command, this.getJavaHome(), pathExecutable));
            return pathExecutable;
        }
        LOGGER.warn("Unable to find the '{}' executable. Tried the java home: {} and the PATH. We will assume the executable can be run in the current working folder.", (Object)command, (Object)this.getJavaHome());
        return new File(this.os.getExecutableName(command));
    }

    @Override
    public File getJavaExecutable() throws JavaHomeException {
        if (this.javaExecutable != null) {
            return this.javaExecutable;
        }
        this.javaExecutable = this.findExecutable("java");
        return this.javaExecutable;
    }

    @Override
    public File getJavacExecutable() throws JavaHomeException {
        if (this.javacExecutable != null) {
            return this.javacExecutable;
        }
        this.javacExecutable = this.findExecutable("javac");
        return this.javacExecutable;
    }

    @Override
    public File getJavadocExecutable() throws JavaHomeException {
        if (this.javadocExecutable != null) {
            return this.javadocExecutable;
        }
        this.javadocExecutable = this.findExecutable("javadoc");
        return this.javadocExecutable;
    }

    @Override
    public File getExecutable(String name) throws JavaHomeException {
        return this.findExecutable(name);
    }

    @Nullable
    public JavaVersion getJavaVersion() {
        return this.javaVersion;
    }

    @Override
    public File getJavaHome() {
        return this.javaHome;
    }

    private File findJavaHome(File javaBase) {
        Optional<File> toolsJar = this.findToolsJar(javaBase);
        if (toolsJar.isPresent()) {
            return toolsJar.get().getParentFile().getParentFile();
        }
        if (javaBase.getName().equalsIgnoreCase("jre") && new File(javaBase.getParentFile(), "bin/java").exists()) {
            return javaBase.getParentFile();
        }
        return javaBase;
    }

    @Override
    public File getToolsJar() {
        if (this.toolsJar != null) {
            return this.toolsJar.orNull();
        }
        this.toolsJar = this.findToolsJar(this.javaHome);
        return this.toolsJar.orNull();
    }

    @Nullable
    public File getStandaloneJre() {
        File jreDir;
        if (this.javaVersion.isJava9Compatible()) {
            return null;
        }
        if (this.os.isWindows() && (jreDir = this.javaVersion.isJava5() ? new File(this.javaHome.getParentFile(), "jre" + this.implementationJavaVersion) : new File(this.javaHome.getParentFile(), "jre" + this.javaVersion.getMajorVersion())).isDirectory()) {
            return jreDir;
        }
        return null;
    }

    @Nullable
    public File getEmbeddedJre() {
        File jreDir = new File(this.javaHome, "jre");
        if (jreDir.isDirectory()) {
            return jreDir;
        }
        return null;
    }

    @Nullable
    public File getJre() {
        File standaloneJre = this.getStandaloneJre();
        if (standaloneJre != null) {
            return standaloneJre;
        }
        return this.getEmbeddedJre();
    }

    private Optional<File> findToolsJar(File javaHome) {
        File toolsJar = new File(javaHome, "lib/tools.jar");
        if (toolsJar.exists()) {
            return Optional.of(toolsJar);
        }
        if (javaHome.getName().equalsIgnoreCase("jre") && (toolsJar = new File(javaHome = javaHome.getParentFile(), "lib/tools.jar")).exists()) {
            return Optional.of(toolsJar);
        }
        if (this.os.isWindows()) {
            String version = this.implementationJavaVersion;
            if ((javaHome.getName().matches("jre\\d+") || javaHome.getName().equals("jre" + version)) && (toolsJar = new File(javaHome = new File(javaHome.getParentFile(), "jdk" + version), "lib/tools.jar")).exists()) {
                return Optional.of(toolsJar);
            }
        }
        return Optional.absent();
    }

    public static Map<String, ?> getInheritableEnvironmentVariables(Map<String, ?> envVars) {
        HashMap vars = new HashMap();
        for (Map.Entry<String, ?> entry : envVars.entrySet()) {
            if (APP_NAME_REGEX.matcher(entry.getKey()).matches() || JAVA_MAIN_CLASS_REGEX.matcher(entry.getKey()).matches() || entry.getKey().equals("TERM_SESSION_ID") || entry.getKey().equals("ITERM_SESSION_ID")) continue;
            vars.put(entry.getKey(), entry.getValue());
        }
        return vars;
    }

    public boolean isIbmJvm() {
        for (String vendorProperty : VENDOR_PROPERTIES) {
            if (!System.getProperties().containsKey(vendorProperty) || !System.getProperty(vendorProperty).toLowerCase().startsWith("ibm corporation")) continue;
            return true;
        }
        return false;
    }
}

