/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.gradle;

import com.liferay.blade.cli.LiferayBundleDeployer;
import com.liferay.gogo.shell.client.GogoShellClient;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.framework.dto.BundleDTO;

public class LiferayBundleDeployerImpl
implements LiferayBundleDeployer {
    private static final FileSystem _FILE_SYSTEM = FileSystems.getDefault();
    private static final PathMatcher _WAR_FILE_GLOB = _FILE_SYSTEM.getPathMatcher("glob:**.war");
    private static final String _WAR_STRING_TEMPLATE = "webbundle:%s?Bundle-SymbolicName=%s&Web-ContextPath=/%s";
    private static final Pattern _installResponse = Pattern.compile(".*Bundle ID: (.*$).*", 40);
    private static final Pattern _versionPattern = Pattern.compile("-[\\d]+((\\.[\\d]+)+(-.+)*)\\.war$");
    private GogoShellClient _client;

    public LiferayBundleDeployerImpl(String host, int port) throws IOException {
        this._client = new GogoShellClient(host, port);
    }

    @Override
    public void close() throws Exception {
        if (this._client != null) {
            this._client.close();
        }
    }

    @Override
    public BundleDTO getBundle(long id) throws Exception {
        String response = this._client.send("lb -s -u | grep '" + id + "\\|'");
        String[] lines = this._parseGogoResponse(response);
        return Stream.of(lines).skip(1L).limit(1L).map(LiferayBundleDeployerImpl::_parseGogoLine).filter(x -> x.id == id).findAny().orElseThrow(() -> new NoSuchElementException("No bundle matching the specified ID " + id));
    }

    @Override
    public long getBundleId(Collection<BundleDTO> bundles, String bsn) throws Exception {
        long bundleId;
        if (Objects.nonNull(bsn)) {
            Stream<BundleDTO> stream = bundles.stream();
            bundleId = stream.filter(Objects::nonNull).filter(bundle -> Objects.equals(bundle.symbolicName, bsn)).map(bundle -> bundle.id).findAny().orElse(-1L);
        } else {
            bundleId = -1L;
        }
        return bundleId;
    }

    @Override
    public Collection<BundleDTO> getBundles() throws Exception {
        return this._getBundles(this._client);
    }

    @Override
    public long install(URI uri) throws Exception {
        Path uriPath = Paths.get(uri);
        String installString = _WAR_FILE_GLOB.matches(uriPath) ? "install " + this._getWarString(uriPath) : "install " + uri.toASCIIString();
        String response = this._sendGogo(installString);
        try {
            Matcher matcher = _installResponse.matcher(response);
            matcher.matches();
            return Integer.parseInt(matcher.group(1));
        }
        catch (Exception exception) {
            throw new Exception("Unable to install bundle.  Unexpected response: \n" + response, exception);
        }
    }

    @Override
    public void refresh(long id) throws Exception {
        this._sendGogo(String.format("refresh %s", id));
    }

    @Override
    public void start(long id) throws Exception {
        String request = String.format("start %s", id);
        String response = this._sendGogo(request);
        this._verify(request, response);
    }

    @Override
    public void stop(long id) throws Exception {
        this._sendGogo(String.format("stop %s", id));
    }

    @Override
    public void uninstall(long id) throws Exception {
        this._sendGogo(String.format("uninstall %s", id));
    }

    @Override
    public void update(long id, URI uri) throws Exception {
        Path uriPath = Paths.get(uri);
        String installString = _WAR_FILE_GLOB.matches(uriPath) ? "update " + this._getWarString(uriPath) : this._sendGogo(String.format("update %s %s", id, uri.toASCIIString()));
        this._sendGogo(installString);
    }

    private static final int _getState(String state) {
        String bundleState = state.toUpperCase();
        if (Objects.equals(bundleState, "ACTIVE")) {
            return 32;
        }
        if (Objects.equals(bundleState, "INSTALLED")) {
            return 2;
        }
        if (Objects.equals(bundleState, "RESOLVED")) {
            return 4;
        }
        if (Objects.equals(bundleState, "STARTING")) {
            return 8;
        }
        if (Objects.equals(bundleState, "STOPPING")) {
            return 16;
        }
        if (Objects.equals(bundleState, "UNINSTALLED")) {
            return 1;
        }
        return 0;
    }

    private static final BundleDTO _newBundleDTO(Long id, int state, String symbolicName) {
        BundleDTO bundle = new BundleDTO();
        bundle.id = id;
        bundle.state = state;
        bundle.symbolicName = symbolicName;
        return bundle;
    }

    private static final BundleDTO _parseGogoLine(String line) {
        String[] fields = line.split("\\|");
        Long id = Long.parseLong(fields[0].trim());
        int state = LiferayBundleDeployerImpl._getState(fields[1].trim());
        String symbolicName = fields[3];
        return LiferayBundleDeployerImpl._newBundleDTO(id, state, symbolicName);
    }

    private List<BundleDTO> _getBundles(GogoShellClient client) throws Exception {
        String response = client.send("lb -s -u");
        String[] lines = this._parseGogoResponse(response);
        return Stream.of(lines).skip(3L).map(LiferayBundleDeployerImpl::_parseGogoLine).collect(Collectors.toList());
    }

    private String _getWarString(Path path) throws Exception {
        if (!_WAR_FILE_GLOB.matches(path)) {
            throw new IllegalArgumentException("Must provide a valid WAR file");
        }
        String fileNameString = String.valueOf(path.getFileName());
        Matcher matcher = _versionPattern.matcher(fileNameString);
        if (matcher.find()) {
            fileNameString = matcher.replaceFirst(".war");
        }
        URI uri = path.toUri();
        return String.format(_WAR_STRING_TEMPLATE, uri.toASCIIString(), fileNameString, fileNameString);
    }

    private final String[] _parseGogoResponse(String response) {
        return response.split("\\r?\\n");
    }

    private String _sendGogo(String data) throws Exception {
        return this._client.send(data);
    }

    private void _verify(String request, String response) throws Exception {
        String[] responseSplit;
        Objects.requireNonNull(request, "Request cannot be null");
        Objects.requireNonNull(request, "Response cannot be null");
        request = request.trim();
        response = response.trim();
        String requestWithoutBreaks = request.replace(System.lineSeparator(), "");
        String responseWithoutBreaks = response.replace(System.lineSeparator(), "");
        int requestLineBreakCount = request.length() - requestWithoutBreaks.length();
        int responseLineBreakCount = response.length() - responseWithoutBreaks.length();
        if (requestLineBreakCount != responseLineBreakCount) {
            String exceptionString = "Unexpected Exception exceptionncountered while processing command \"" + request + "\":" + System.lineSeparator() + response;
            throw new Exception(exceptionString);
        }
        String[] requestSplit = request.split(" ");
        if (requestSplit.length != (responseSplit = response.split(" ")).length) {
            String exceptionString = "Unexpected response encountered while processing command \"" + request + "\":" + System.lineSeparator() + response;
            throw new Exception(exceptionString);
        }
        for (int x = 0; x < requestSplit.length; ++x) {
            if (Objects.equals(requestSplit[0], responseSplit[0])) continue;
            String exceptionString = "Unexpected response encountered while processing command \"" + request + "\":" + System.lineSeparator() + response;
            throw new Exception(exceptionString);
        }
    }
}

