/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.liferay.blade.cli.BladeCLI;
import com.liferay.blade.cli.command.BaseArgs;
import com.liferay.blade.cli.command.BaseCommand;
import com.liferay.blade.cli.util.FileUtil;
import com.liferay.blade.cli.util.ProcessesUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Extensions
implements Closeable {
    public static final String TEMP_EXTENSIONS_PREFIX = "blade-extensions-";
    public static final String TEMP_TEMPLATES_PREFIX = "blade-templates-";
    private Map<String, BaseCommand<? extends BaseArgs>> _commands;
    private Path _embeddedTemplatesPath = null;
    private ClassLoader _serviceLoaderClassLoader = null;

    public static Collection<String> getCommandNames(Collection<Class<? extends BaseArgs>> argsClass) {
        Stream<Class<? extends BaseArgs>> stream = argsClass.stream();
        return stream.map(clazz -> clazz.getAnnotation(Parameters.class)).filter(Objects::nonNull).map(Parameters::commandNames).map(Arrays::asList).flatMap(Collection::stream).collect(Collectors.toList());
    }

    /*
     * Could not resolve type clashes
     */
    public static String[] sortArgs(Map<String, BaseCommand<? extends BaseArgs>> commands, String[] args) throws Exception {
        String s;
        int x2;
        ArrayList<String> argsList = new ArrayList<String>(Arrays.asList(args));
        ArrayList addLast = new ArrayList();
        HashSet argList = new HashSet();
        Collection<BaseCommand<? extends BaseArgs>> values = commands.values();
        Stream<BaseCommand<? extends BaseArgs>> valuesStream = values.stream();
        valuesStream.map(command -> command.getArgs()).forEach(argList::add);
        Stream argStream = argList.stream();
        Collection<String> commandNames = Extensions.getCommandNames(argStream.map(Object::getClass).collect(Collectors.toSet()));
        Stream<String> commandNamesStream = commandNames.stream();
        Collection spaceCommandCollection = commandNamesStream.filter(x -> x.contains(" ")).collect(Collectors.toSet());
        ArrayList spaceCommandSplitCollection = new ArrayList();
        Stream spaceCommandStream = spaceCommandCollection.stream();
        spaceCommandStream.map(x -> x.split(" ")).forEach(spaceCommandSplitCollection::add);
        Collection<String> flagsWithArgs = Extensions._getFlags(BaseArgs.class, true);
        Collection<String> flagsWithoutArgs = Extensions._getFlags(BaseArgs.class, false);
        for (x2 = 0; x2 < argsList.size(); ++x2) {
            s = (String)argsList.get(x2);
            if (!flagsWithArgs.contains(s)) continue;
            addLast.add(argsList.remove(x2));
            addLast.add(argsList.remove(x2));
            --x2;
        }
        for (x2 = 0; x2 < argsList.size(); ++x2) {
            s = (String)argsList.get(x2);
            if (!flagsWithoutArgs.contains(s)) continue;
            addLast.add(argsList.remove(x2));
        }
        for (x2 = 0; x2 < argsList.size(); ++x2) {
            if (spaceCommandSplitCollection.isEmpty()) continue;
            String[] foundStrArray = null;
            for (String[] strArray : spaceCommandSplitCollection) {
                if (argsList.size() < x2 + strArray.length || foundStrArray != null) continue;
                boolean mismatch = false;
                if (strArray.length == 0) {
                    mismatch = true;
                }
                for (int y = 0; y < strArray.length; ++y) {
                    if (Objects.equals(strArray[y], argsList.get(x2 + y))) continue;
                    mismatch = true;
                }
                if (mismatch) continue;
                foundStrArray = strArray;
                break;
            }
            if (foundStrArray == null) continue;
            ArrayList<void> commandParts = new ArrayList<void>();
            for (int y = 0; y < foundStrArray.length; ++y) {
                if (!Objects.equals(foundStrArray[y], argsList.get(x2 + y))) continue;
                commandParts.add(foundStrArray[y]);
            }
            StringBuilder newCommand = new StringBuilder();
            for (String commandPart : commandParts) {
                if (!Objects.equals(commandPart, argsList.get(x2))) continue;
                int len = newCommand.length();
                if (len > 0) {
                    newCommand.append(" ");
                }
                newCommand.append((String)argsList.remove(x2));
            }
            argsList.add(x2, newCommand.toString());
        }
        argsList.addAll(addLast);
        return argsList.toArray(new String[0]);
    }

    public Extensions(ClassLoader classLoader) {
        this._serviceLoaderClassLoader = classLoader;
    }

    @Override
    public void close() throws IOException {
        if (this._embeddedTemplatesPath != null && Files.exists(this._embeddedTemplatesPath, new LinkOption[0])) {
            try {
                FileUtil.deleteDirIfExists(this._embeddedTemplatesPath);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Map<String, BaseCommand<? extends BaseArgs>> getCommands() throws Exception {
        return this._getCommands(null);
    }

    public Map<String, BaseCommand<? extends BaseArgs>> getCommands(String profileName) throws Exception {
        if (profileName == null) {
            profileName = "gradle";
        }
        return this._getCommands(profileName);
    }

    public Path getTemplatesPath() throws IOException {
        block29: {
            if (this._embeddedTemplatesPath == null) {
                long pid = ProcessesUtil.getCurrentProcessId();
                this._embeddedTemplatesPath = Files.createTempDirectory(TEMP_TEMPLATES_PREFIX + pid + "-", new FileAttribute[0]);
                try (InputStream inputStream = Extensions.class.getResourceAsStream("/blade-extensions-versions.properties");){
                    if (inputStream == null) break block29;
                    Properties properties = new Properties();
                    properties.load(inputStream);
                    HashSet<String> templates = new HashSet<String>();
                    ClassLoader classLoader = Extensions.class.getClassLoader();
                    for (Object key : properties.keySet()) {
                        String jarResource = key.toString() + "-" + properties.getProperty(key.toString()) + ".jar";
                        if (!jarResource.startsWith("com.liferay.project.templates") || classLoader.getResource(jarResource) == null) continue;
                        templates.add(jarResource);
                    }
                    for (String template : templates) {
                        try {
                            InputStream extensionInputStream = classLoader.getResourceAsStream(template);
                            Throwable throwable = null;
                            try {
                                Path extensionPath = this._embeddedTemplatesPath.resolve(template);
                                Files.copy(extensionInputStream, extensionPath, StandardCopyOption.REPLACE_EXISTING);
                            }
                            catch (Throwable extensionPath) {
                                throwable = extensionPath;
                                throw extensionPath;
                            }
                            finally {
                                if (extensionInputStream == null) continue;
                                if (throwable != null) {
                                    try {
                                        extensionInputStream.close();
                                    }
                                    catch (Throwable extensionPath) {
                                        throwable.addSuppressed(extensionPath);
                                    }
                                    continue;
                                }
                                extensionInputStream.close();
                            }
                        }
                        catch (Throwable th) {
                            StringBuilder sb = new StringBuilder();
                            sb.append("Error encountered while loading embedded custom template.");
                            sb.append(System.lineSeparator());
                            sb.append(th.getMessage());
                            sb.append(System.lineSeparator());
                            sb.append("Not loading template " + template + ".");
                            sb.append(System.lineSeparator());
                            String errorString = sb.toString();
                            System.err.println(errorString);
                        }
                    }
                }
                catch (Throwable th) {
                    String errorMessage = "Error encountered while loading custom extensions." + System.lineSeparator();
                    System.err.println(errorMessage);
                    System.err.println(th.getMessage());
                }
            }
        }
        return this._embeddedTemplatesPath;
    }

    private static Collection<String> _getFlags(Class<? extends BaseArgs> clazz, boolean withArguments) {
        ArrayList<String> flags = new ArrayList<String>();
        for (Field field : clazz.getDeclaredFields()) {
            String[] names;
            Parameter annotation = field.getAnnotation(Parameter.class);
            if (annotation == null || (names = annotation.names()) == null || names.length <= 0) continue;
            Class<?> type = field.getType();
            if ((!withArguments || type.equals(Boolean.TYPE)) && (withArguments || !type.equals(Boolean.TYPE))) continue;
            for (String name : names) {
                flags.add(name);
            }
        }
        return flags;
    }

    private Map<String, BaseCommand<? extends BaseArgs>> _getCommands(String profileName) throws Exception {
        if (this._commands == null) {
            ClassLoader serviceLoaderClassLoader = this._serviceLoaderClassLoader;
            this._commands = BladeCLI.getCommandMapByClassLoader(profileName, serviceLoaderClassLoader);
        }
        return this._commands;
    }
}

