/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.command;

import com.liferay.blade.cli.BladeCLI;
import com.liferay.blade.cli.command.BaseCommand;
import com.liferay.blade.cli.command.ListProjectTemplatesArgs;
import com.liferay.blade.cli.util.BladeUtil;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class ListProjectTemplatesCommand
extends BaseCommand<ListProjectTemplatesArgs> {
    @Override
    public void execute() throws Exception {
        this._printTemplates();
    }

    @Override
    public Class<ListProjectTemplatesArgs> getArgsClass() {
        return ListProjectTemplatesArgs.class;
    }

    private void _printTemplates() throws Exception {
        BladeCLI bladeCLI = this.getBladeCLI();
        Map<String, String> templates = BladeUtil.getTemplates(bladeCLI);
        ArrayList<String> templateNames = new ArrayList<String>(BladeUtil.getTemplateNames(this.getBladeCLI()));
        Collections.sort(templateNames);
        Comparator<String> compareLength = Comparator.comparingInt(String::length);
        Stream stream = templateNames.stream();
        String longestString = stream.max(compareLength).get();
        int padLength = longestString.length() + 2;
        for (String name : templateNames) {
            PrintStream out = bladeCLI.out();
            out.print(StringUtils.rightPad(name, padLength));
            bladeCLI.out(templates.get(name));
        }
    }
}

