/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.util;

import java.util.Map;
import java.util.Optional;

public class ProductInfo {
    private String _appServerTomcatVersion;
    private String _bundleUrl;
    private final String _liferayDockerImage;
    private final String _liferayProductVersion;
    private Boolean _promoted = false;
    private final String _releaseDate;
    private String _targetPlatformVersion;

    public ProductInfo(Map<String, String> productMap) {
        this._appServerTomcatVersion = this._safeGet(productMap, "appServerTomcatVersion", "");
        this._bundleUrl = this._safeGet(productMap, "bundleUrl", "");
        this._liferayDockerImage = this._safeGet(productMap, "liferayDockerImage", "");
        this._liferayProductVersion = this._safeGet(productMap, "liferayProductVersion", "");
        this._releaseDate = this._safeGet(productMap, "releaseDate", "");
        this._targetPlatformVersion = this._safeGet(productMap, "targetPlatformVersion", "");
        this._promoted = Boolean.parseBoolean(this._safeGet(productMap, "promoted", "false"));
    }

    public String getAppServerTomcatVersion() {
        return this._appServerTomcatVersion;
    }

    public String getBundleUrl() {
        return this._bundleUrl;
    }

    public String getLiferayDockerImage() {
        return this._liferayDockerImage;
    }

    public String getLiferayProductVersion() {
        return this._liferayProductVersion;
    }

    public String getReleaseDate() {
        return this._releaseDate;
    }

    public String getTargetPlatformVersion() {
        return this._targetPlatformVersion;
    }

    public boolean isPromoted() {
        return this._promoted;
    }

    private String _safeGet(Map<String, String> map, String key, String defVal) {
        return Optional.ofNullable(map).map(m -> (String)m.get(key)).orElse(defVal);
    }
}

