/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.command;

import com.liferay.blade.cli.BladeCLI;
import com.liferay.blade.cli.WorkspaceProvider;
import com.liferay.blade.cli.command.BaseArgs;
import com.liferay.blade.cli.command.ConvertArgs;
import com.liferay.blade.cli.gradle.GradleWorkspaceProvider;
import com.liferay.blade.cli.util.FileUtil;
import com.liferay.blade.cli.util.NodeUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ConvertThemeCommand {
    private static final String _LIFERAY_VERSION_70 = "7.0";
    private static final Pattern _compassImport = Pattern.compile("@import\\s*['\"]compass['\"];");
    private BladeCLI _bladeCLI;
    private ConvertArgs _convertArgs;
    private final List<Path> _convertedPaths = new ArrayList<Path>();
    private File _pluginsSDKThemesDir;
    private File _themesDir;

    public ConvertThemeCommand(BladeCLI bladeCLI, ConvertArgs convertArgs) throws Exception {
        this._bladeCLI = bladeCLI;
        this._convertArgs = convertArgs;
        File baseDir = this._convertArgs.getBase();
        GradleWorkspaceProvider workspaceProviderGradle = (GradleWorkspaceProvider)this._bladeCLI.getWorkspaceProvider(baseDir);
        File projectDir = workspaceProviderGradle.getWorkspaceDir(this._bladeCLI);
        Properties gradleProperties = workspaceProviderGradle.getGradleProperties(projectDir);
        File pluginsSdkDir = this._convertArgs.getSource();
        if (pluginsSdkDir == null) {
            String pluginsSDKDirPath = null;
            if (gradleProperties != null) {
                pluginsSDKDirPath = gradleProperties.getProperty("liferay.workspace.plugins.sdk.dir");
            }
            if (pluginsSDKDirPath == null) {
                pluginsSDKDirPath = "plugins-sdk";
            }
            this._pluginsSDKThemesDir = new File(projectDir, pluginsSDKDirPath + "/themes");
        } else {
            this._pluginsSDKThemesDir = new File(pluginsSdkDir, "themes");
        }
        String themesDirPath = null;
        if (gradleProperties != null) {
            themesDirPath = gradleProperties.getProperty("liferay.workspace.themes.dir");
        }
        if (themesDirPath == null) {
            themesDirPath = "themes";
        }
        this._themesDir = new File(projectDir, themesDirPath);
        this._themesDir.mkdirs();
    }

    public void execute() throws Exception {
        String themeName;
        File baseDir = this._convertArgs.getBase();
        WorkspaceProvider workspaceProvider = this._bladeCLI.getWorkspaceProvider(baseDir);
        if (workspaceProvider == null) {
            this._bladeCLI.error("Please execute this in a Liferay Workspace project.");
            return;
        }
        boolean removeSource = this._convertArgs.isRemoveSource();
        List<String> args = this._convertArgs.getName();
        String string = themeName = !args.isEmpty() ? args.get(0) : null;
        if (themeName == null) {
            ArrayList<String> themes = new ArrayList<String>();
            for (File file : this._pluginsSDKThemesDir.listFiles()) {
                if (!file.isDirectory()) continue;
                if (this._convertArgs.isAll()) {
                    Optional<Path> themePath = this.importTheme(file.getCanonicalPath(), removeSource);
                    if (!themePath.isPresent()) continue;
                    this._convertedPaths.add(themePath.get());
                    continue;
                }
                themes.add(file.getName());
            }
            if (!this._convertArgs.isAll()) {
                if (!themes.isEmpty()) {
                    String exampleTheme = (String)themes.get(0);
                    this._bladeCLI.out("Please provide the theme project name to migrate, e.g. \"blade migrateTheme " + exampleTheme + "\"\n");
                    this._bladeCLI.out("Currently available themes:");
                    this._bladeCLI.out(themes.stream().collect(Collectors.joining(System.lineSeparator())));
                } else {
                    this._bladeCLI.out("Good news! All your themes have already been migrated to " + this._themesDir);
                }
            }
        } else {
            File themeDir = new File(this._pluginsSDKThemesDir, themeName);
            if (themeDir.exists()) {
                Optional<Path> importThemePath = this.importTheme(themeDir.getCanonicalPath(), removeSource);
                if (importThemePath.isPresent()) {
                    this._convertedPaths.add(importThemePath.get());
                }
            } else {
                this._bladeCLI.error("Theme does not exist");
            }
        }
    }

    public List<Path> getConvertedPaths() {
        return this._convertedPaths;
    }

    public Optional<Path> importTheme(String themePath, boolean removeSource) throws Exception {
        File originalTheme = new File(themePath);
        if (originalTheme.exists()) {
            int retCode = NodeUtil.runYo(_LIFERAY_VERSION_70, this._themesDir, new String[]{"liferay-theme:import", "-p", themePath, "-c", String.valueOf(this._compassSupport(themePath)), "--skip-install"}, this._convertArgs.isQuiet());
            if (retCode == 0) {
                BaseArgs baseArgs = this._bladeCLI.getArgs();
                if (!baseArgs.isQuiet()) {
                    this._bladeCLI.out("Theme " + themePath + " migrated successfully");
                }
                if (removeSource) {
                    FileUtil.deleteDir(originalTheme.toPath());
                }
                return Optional.of(new File(this._themesDir, originalTheme.getName())).map(File::toPath);
            }
            this._bladeCLI.error("blade exited with code: " + retCode);
        }
        return Optional.empty();
    }

    private boolean _compassSupport(String themePath) throws Exception {
        File themeDir = new File(themePath);
        File customCss = new File(themeDir, "docroot/_diffs/css/custom.css");
        if (!customCss.exists()) {
            customCss = new File(themeDir, "docroot/_diffs/css/_custom.scss");
        }
        if (!customCss.exists()) {
            return false;
        }
        String css = new String(Files.readAllBytes(customCss.toPath()));
        Matcher matcher = _compassImport.matcher(css);
        return matcher.find();
    }
}

