/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.command;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.liferay.blade.cli.command.CommandType;
import java.io.File;

@Parameters(commandDescription="Options valid for all commands. Must be given before sub command")
public class BaseArgs {
    @Parameter(description="Specify a new base directory (default working directory).", hidden=true, names={"--base"})
    private File _base = new File(System.getProperty("user.dir"));
    @Parameter(description="Get help on a specific command.", help=true, names={"--help"})
    private boolean _help;
    @Parameter(description="Specify the profile to use when invoking the command.", names={"-b", "--build", "-P", "--profile-name"})
    private String _profileName;
    @Parameter(description="Do not print any optional messages to console.", hidden=true, names={"-q", "--quiet"})
    private boolean _quiet;
    @Parameter(description="Force Blade to check for new releases", names={"--refresh-releases"})
    private boolean _refreshReleases;
    @Parameter(description="Print exception stack traces when they occur.", hidden=true, names={"--trace"})
    private boolean _trace;

    public File getBase() {
        return this._base;
    }

    public CommandType getCommandType() {
        return CommandType.GLOBAL;
    }

    public String getProfileName() {
        return this._profileName;
    }

    public boolean isHelp() {
        return this._help;
    }

    public boolean isQuiet() {
        return this._quiet;
    }

    public boolean isRefreshReleases() {
        return this._refreshReleases;
    }

    public boolean isTrace() {
        return this._trace;
    }

    public void setBase(File baseDir) {
        this._base = baseDir.getAbsoluteFile();
    }

    public void setProfileName(String profileName) {
        this._profileName = profileName;
    }

    public void setQuiet(boolean quiet) {
        this._quiet = quiet;
    }

    public void setRefreshReleases(boolean refreshReleases) {
        this._refreshReleases = refreshReleases;
    }
}

