/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.command;

import com.liferay.blade.cli.BladeTest;
import com.liferay.blade.cli.BladeTestResults;
import com.liferay.blade.cli.GradleRunnerUtil;
import com.liferay.blade.cli.TestUtil;
import com.liferay.blade.cli.util.FileUtil;
import com.liferay.blade.cli.util.ReleaseUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Scanner;
import org.gradle.testkit.runner.BuildTask;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class InitCommandTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private static final String _GRADLE_PLUGINS_WORKSPACE_VERSION = "10.0.3";
    private File _extensionsDir = null;
    private File _workspaceDir = null;
    private Path _workspacePath = null;

    @Before
    public void setUp() throws Exception {
        this._workspaceDir = this.temporaryFolder.newFolder(new String[]{"build", "test", "workspace"});
        this._workspacePath = this._workspaceDir.toPath();
        this._extensionsDir = this.temporaryFolder.newFolder(new String[]{".blade", "extensions"});
    }

    @Test
    public void testBladeInitDontLoseGitDirectory() throws Exception {
        File testdir = new File(this.temporaryFolder.getRoot(), "build/testBladeInitDontLoseGitDirectory");
        testdir.mkdirs();
        FileUtil.unzip((File)new File("test-resources/projects/plugins-sdk-with-git.zip"), (File)testdir);
        Assert.assertTrue((boolean)testdir.exists());
        File projectDir = new File(testdir, "plugins-sdk-with-git");
        File pluginsSdkDir = new File(projectDir, "plugins-sdk");
        FileUtil.deleteDirIfExists((Path)pluginsSdkDir.toPath());
        String[] args = new String[]{"--base", projectDir.getPath(), "init", "-u", "-v", "portal-7.4-ga107"};
        TestUtil.runBlade(this._workspaceDir, this._extensionsDir, args);
        File gitdir = new File(projectDir, ".git");
        Assert.assertTrue((boolean)gitdir.exists());
        File oldGitIgnore = new File(projectDir, "plugins-sdk/.gitignore");
        Assert.assertTrue((boolean)oldGitIgnore.exists());
    }

    @Test
    public void testBladeInitEmptyDirectory() throws Exception {
        File emptyDir = this.temporaryFolder.newFolder();
        String[] args = new String[]{"--base", emptyDir.getPath(), "init", "-v", "portal-7.4-ga107"};
        BladeTest bladeTest = this._getBladeTestCustomWorkspace(emptyDir);
        bladeTest.run(args);
        Assert.assertNotNull((Object)bladeTest.getWorkspaceProvider(emptyDir));
    }

    @Test
    public void testBladeInitEmptyDirectoryHandleDot() throws Exception {
        File emptyDir = this.temporaryFolder.newFolder();
        File dotFile = new File(emptyDir.getPath(), ".");
        String pathStringToTest = dotFile.getAbsolutePath();
        String[] args = new String[]{"--base", pathStringToTest, "init", "-v", "portal-7.4-ga107"};
        BladeTest bladeTest = this._getBladeTestCustomWorkspace(emptyDir);
        bladeTest.run(args);
        Assert.assertNotNull((Object)bladeTest.getWorkspaceProvider(emptyDir));
    }

    @Test
    public void testBladeInitEmptyDirectoryHandleTwoDots() throws Exception {
        File emptyDir = this.temporaryFolder.newFolder();
        File dotFile = new File(emptyDir.getPath(), ".");
        String pathStringToTest = dotFile.getAbsolutePath();
        String[] args = new String[]{"--base", pathStringToTest, "init", ".", "-v", "portal-7.4-ga107"};
        BladeTest bladeTest = this._getBladeTestCustomWorkspace(emptyDir);
        bladeTest.run(args);
        Assert.assertNotNull((Object)bladeTest.getWorkspaceProvider(emptyDir));
    }

    @Test
    public void testBladeInitUpgradePluginsSDKTo70() throws Exception {
        File testdir = new File(this.temporaryFolder.getRoot(), "build/testUpgradePluginsSDKTo70");
        testdir.mkdirs();
        FileUtil.unzip((File)new File("test-resources/projects/plugins-sdk-with-git.zip"), (File)testdir);
        Assert.assertTrue((boolean)testdir.exists());
        File projectDir = new File(testdir, "plugins-sdk-with-git");
        File pluginsSdkDir = new File(projectDir, "plugins-sdk");
        FileUtil.deleteDirIfExists((Path)pluginsSdkDir.toPath());
        String[] args = new String[]{"--base", projectDir.getPath(), "init", "-u", "-v", BladeTest.PRODUCT_VERSION_DXP_70};
        BladeTest bladeTest = this._getBladeTestCustomWorkspace(projectDir);
        bladeTest.run(args);
        File buildProperties = new File(projectDir, "plugins-sdk/build.properties");
        Properties props = new Properties();
        props.load(new FileInputStream(buildProperties));
        String version = props.getProperty("lp.version");
        Assert.assertEquals((Object)"7.0.0", (Object)version);
    }

    @Test
    public void testBladeInitWithCustomProfile() throws Exception {
        File tempDir = this.temporaryFolder.newFolder();
        File base = new File(tempDir.getPath());
        String basePath = base.getAbsolutePath();
        String[] args = new String[]{"--base", basePath, "init", "-P", "myprofile", "-v", "portal-7.4-ga107"};
        TestUtil.runBlade(tempDir, this._extensionsDir, args);
        File settingsFile = new File(basePath, ".blade.properties");
        Properties props = new Properties();
        try (FileInputStream fileInputStream = new FileInputStream(settingsFile);){
            props.load(fileInputStream);
            String profileName = props.getProperty("profile.name");
            Assert.assertEquals((Object)"myprofile", (Object)profileName);
        }
    }

    @Test
    public void testDefaultInitWorkspaceDirectoryEmpty() throws Exception {
        String[] args = new String[]{"--base", this._workspaceDir.getPath(), "init", "-v", "portal-7.4-ga107"};
        TestUtil.runBlade(this._workspaceDir, this._extensionsDir, args);
        Assert.assertTrue((boolean)this._workspaceDir.exists());
        Path buildGradlePath = this._workspacePath.resolve("build.gradle");
        Assert.assertTrue((boolean)Files.exists(buildGradlePath, new LinkOption[0]));
        Path modulesPath = this._workspacePath.resolve("modules");
        Assert.assertTrue((boolean)Files.exists(modulesPath, new LinkOption[0]));
        Path comPath = this._workspacePath.resolve("com");
        Assert.assertFalse((boolean)Files.exists(comPath, new LinkOption[0]));
        this._verifyGradleBuild();
    }

    @Test
    public void testDefaultInitWorkspaceDirectoryHasFiles() throws Exception {
        String[] args = new String[]{"--base", this._workspaceDir.getPath(), "init"};
        Path fooPath = this._workspacePath.resolve("foo");
        Files.createFile(fooPath, new FileAttribute[0]);
        Assert.assertTrue((boolean)Files.exists(fooPath, new LinkOption[0]));
        TestUtil.runBlade(this._workspaceDir, this._extensionsDir, false, args);
        Path buildGradlePath = this._workspacePath.resolve("build.gradle");
        Assert.assertFalse((boolean)Files.exists(buildGradlePath, new LinkOption[0]));
    }

    @Test
    public void testDefaultInitWorkspaceDirectoryHasFilesForce() throws Exception {
        String[] args = new String[]{"--base", this._workspaceDir.getPath(), "init", "-f", "-v", "portal-7.4-ga107"};
        TestUtil.runBlade(this._workspaceDir, this._extensionsDir, args);
        Assert.assertTrue((boolean)this._workspaceDir.exists());
        Path buildGradlePath = this._workspacePath.resolve("build.gradle");
        Assert.assertTrue((boolean)Files.exists(buildGradlePath, new LinkOption[0]));
        Path modulesPath = this._workspacePath.resolve("modules");
        Assert.assertTrue((boolean)Files.exists(modulesPath, new LinkOption[0]));
        this._verifyGradleBuild();
    }

    @Test
    public void testDefaultInitWorkspaceDirectoryIsWorkspace() throws Exception {
        String[] args = new String[]{"--base", this._workspaceDir.getPath(), "init", "firstWorkspace", "-v", "portal-7.4-ga107"};
        TestUtil.runBlade(this._workspaceDir, this._extensionsDir, args);
        File firstWorkspace = new File(this._workspaceDir, "firstWorkspace");
        String[] moreArgs = new String[]{"--base", firstWorkspace.getPath(), "init", "nextWorkspace", "-v", "portal-7.4-ga107"};
        TestUtil.runBlade(this._workspaceDir, this._extensionsDir, false, args);
        Assert.assertTrue((String)(firstWorkspace.getName() + " should exist but does not."), (boolean)firstWorkspace.exists());
        File nextWorkspace = new File(this._workspaceDir + File.separator + "firstWorkspace", "nextWorkspace");
        Assert.assertFalse((String)(nextWorkspace.getName() + " should not exist, but it does."), (boolean)nextWorkspace.exists());
        try {
            BladeTestResults bladeTestResults = TestUtil.runBlade(firstWorkspace, this._extensionsDir, moreArgs);
            Assert.assertFalse((String)"There should be no results from the command, but bladeTestResults != null)", (bladeTestResults != null ? 1 : 0) != 0);
        }
        catch (AssertionError e) {
            String message = ((Throwable)((Object)e)).getMessage();
            Assert.assertTrue((String)("should say 'does not support initializing a workspace inside of another workspace', but says: " + message), (boolean)message.contains("does not support initializing a workspace inside of another workspace"));
        }
    }

    @Test
    public void testInitCommandGradleOption() throws Exception {
        String[] args = new String[]{"--base", this._workspaceDir.getPath(), "init", "-b", "gradle", "gradleworkspace", "-v", "portal-7.4-ga107"};
        TestUtil.runBlade(this._workspaceDir, this._extensionsDir, args);
        Path gradleWorkspace = this._workspacePath.resolve("gradleworkspace");
        Assert.assertTrue((boolean)Files.exists(gradleWorkspace, new LinkOption[0]));
        Path pomXmlPath = gradleWorkspace.resolve("pom.xml");
        Assert.assertFalse((boolean)Files.exists(pomXmlPath, new LinkOption[0]));
        Path buildGradlePath = gradleWorkspace.resolve("build.gradle");
        Assert.assertTrue((boolean)Files.exists(buildGradlePath, new LinkOption[0]));
    }

    @Test
    public void testInitCommandListAll() throws Exception {
        String[] args = new String[]{"init", "--list", "--all"};
        BladeTestResults bladeTestResults = TestUtil.runBlade(this._workspaceDir, this._extensionsDir, args);
        String output = bladeTestResults.getOutput();
        Assert.assertTrue((String)output, (boolean)output.contains("dxp-2023.q4.6"));
        Assert.assertTrue((String)output, (boolean)output.contains("dxp-7.4-u110"));
        Assert.assertTrue((String)output, (boolean)output.contains("portal-7.0-ga7"));
    }

    @Test
    public void testInitCommandListMoreOptions() throws Exception {
        String[] args = new String[]{"--base", this._workspaceDir.getPath(), "init", "testworkspace"};
        String responses = "more" + System.lineSeparator() + "dxp-7.2-dxp-5" + System.lineSeparator();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(responses.getBytes());
        BladeTestResults bladeTestResults = TestUtil.runBlade(this._workspaceDir, this._extensionsDir, (InputStream)byteArrayInputStream, true, args);
        String output = bladeTestResults.getOutput();
        Assert.assertTrue((String)output, (boolean)output.contains("dxp-7.3-u34"));
    }

    @Test
    public void testInitCommandListPromoted() throws Exception {
        String[] args = new String[]{"init", "--list"};
        BladeTestResults bladeTestResults = TestUtil.runBlade(this._workspaceDir, this._extensionsDir, args);
        String output = bladeTestResults.getOutput();
        ArrayList<String> lines = new ArrayList<String>();
        try (Scanner scanner = new Scanner(output);){
            while (scanner.hasNextLine()) {
                lines.add(scanner.nextLine());
            }
        }
        String firstLine = (String)lines.get(0);
        Assert.assertEquals((Object)firstLine, (Object)BladeTest.getFirstProductKey(ReleaseUtil.ReleaseEntry::isPromoted));
    }

    @Test
    public void testInitInPluginsSDKDirectory() throws Exception {
        String[] args = new String[]{"--base", this._workspaceDir.getPath(), "init", "-u", "-v", "portal-7.4-ga107"};
        this._makeSDK(this._workspaceDir);
        TestUtil.runBlade(this._workspaceDir, this._extensionsDir, args);
        Path buildGradlePath = this._workspacePath.resolve("build.gradle");
        Assert.assertTrue((boolean)Files.exists(buildGradlePath, new LinkOption[0]));
        Path modulesPath = this._workspacePath.resolve("modules");
        Assert.assertTrue((boolean)Files.exists(modulesPath, new LinkOption[0]));
        Path themesPath = this._workspacePath.resolve("themes");
        Assert.assertTrue((boolean)Files.exists(themesPath, new LinkOption[0]));
        Path portletsPath = this._workspacePath.resolve("portlets");
        Assert.assertFalse((boolean)Files.exists(portletsPath, new LinkOption[0]));
        Path hooksPath = this._workspacePath.resolve("hooks");
        Assert.assertFalse((boolean)Files.exists(hooksPath, new LinkOption[0]));
        Path buildPropertiesPath = this._workspacePath.resolve("build.properties");
        Assert.assertFalse((boolean)Files.exists(buildPropertiesPath, new LinkOption[0]));
        Path buildXmlPath = this._workspacePath.resolve("build.xml");
        Assert.assertFalse((boolean)Files.exists(buildXmlPath, new LinkOption[0]));
        Path pluginBuildPropertiesPath = this._workspacePath.resolve("plugins-sdk/build.properties");
        Assert.assertTrue((boolean)Files.exists(pluginBuildPropertiesPath, new LinkOption[0]));
        Path pluginBuildXmlPath = this._workspacePath.resolve("plugins-sdk/build.xml");
        Assert.assertTrue((boolean)Files.exists(pluginBuildXmlPath, new LinkOption[0]));
    }

    @Test(expected=AssertionError.class)
    public void testInitLegacyProductKey() throws Exception {
        String[] args = new String[]{"--base", this._workspaceDir.getPath(), "init", "-v", "portal-7.0-ga1"};
        TestUtil.runBlade(this._workspaceDir, this._extensionsDir, args);
    }

    @Test
    public void testInitWithLiferayVersion70() throws Exception {
        this._testInitWithLiferayVersion(BladeTest.PRODUCT_VERSION_DXP_70);
    }

    @Test
    public void testInitWithLiferayVersion71() throws Exception {
        this._testInitWithLiferayVersion(BladeTest.PRODUCT_VERSION_DXP_71);
    }

    @Test
    public void testInitWithLiferayVersion72() throws Exception {
        this._testInitWithLiferayVersion(BladeTest.PRODUCT_VERSION_DXP_72);
    }

    @Test
    public void testInitWithLiferayVersion73() throws Exception {
        this._testInitWithLiferayVersion(BladeTest.PRODUCT_VERSION_PORTAL_73);
    }

    @Test(expected=AssertionError.class)
    public void testInitWithLiferayVersionUnset() throws Exception {
        String[] args = new String[]{"--base", this._workspaceDir.getPath(), "init"};
        TestUtil.runBlade(this._workspaceDir, this._extensionsDir, args);
    }

    @Test
    public void testInitWithNameWorkspaceDirectoryEmpty() throws Exception {
        String[] args = new String[]{"--base", this._workspaceDir.getPath(), "init", "newproject", "-v", "portal-7.4-ga107"};
        Path newproject = this._workspacePath.resolve("newproject");
        Files.createDirectories(newproject, new FileAttribute[0]);
        Assert.assertTrue((boolean)Files.exists(newproject, new LinkOption[0]));
        TestUtil.runBlade(this._workspaceDir, this._extensionsDir, args);
        Path buildGradlePath = newproject.resolve("build.gradle");
        Assert.assertTrue((boolean)Files.exists(buildGradlePath, new LinkOption[0]));
        Path modulesPath = newproject.resolve("modules");
        Assert.assertTrue((boolean)Files.exists(modulesPath, new LinkOption[0]));
        Path settingsGradlePath = newproject.resolve("settings.gradle");
        String contents = new String(Files.readAllBytes(settingsGradlePath));
        if (!contents.contains(_GRADLE_PLUGINS_WORKSPACE_VERSION)) {
            StringBuilder sb = new StringBuilder("Error checking com.liferay.gradle.plugins.workspace version.");
            sb.append(System.lineSeparator());
            sb.append("Expected 10.0.3");
            sb.append(System.lineSeparator());
            sb.append(contents);
            Assert.fail((String)String.valueOf(sb));
        }
    }

    @Test
    public void testInitWithNameWorkspaceDirectoryHasFiles() throws Exception {
        String[] args = new String[]{"--base", this._workspaceDir.getPath(), "init", "newproject", "-v", "portal-7.4-ga107"};
        Path newProjectPath = this._workspacePath.resolve("newproject");
        Files.createDirectories(newProjectPath, new FileAttribute[0]);
        Assert.assertTrue((boolean)Files.exists(newProjectPath, new LinkOption[0]));
        Path fooPath = newProjectPath.resolve("foo");
        Files.createFile(fooPath, new FileAttribute[0]);
        Assert.assertTrue((boolean)Files.exists(fooPath, new LinkOption[0]));
        TestUtil.runBlade(this._workspaceDir, this._extensionsDir, false, args);
        Path buildGradlePath = newProjectPath.resolve("build.gradle");
        Assert.assertFalse((boolean)Files.exists(buildGradlePath, new LinkOption[0]));
    }

    @Test
    public void testInitWithNameWorkspaceNotExists() throws Exception {
        String[] args = new String[]{"--base", this._workspaceDir.getPath(), "init", "newproject", "-v", "portal-7.4-ga107"};
        TestUtil.runBlade(this._workspaceDir, this._extensionsDir, args);
        Path buildGradlePath = this._workspacePath.resolve("newproject/build.gradle");
        Assert.assertTrue((boolean)Files.exists(buildGradlePath, new LinkOption[0]));
        Path modulesPath = this._workspacePath.resolve("newproject/modules");
        Assert.assertTrue((boolean)Files.exists(modulesPath, new LinkOption[0]));
    }

    private void _createBundle() throws Exception {
        Path projectPath = this._workspacePath.resolve("modules");
        String[] args = new String[]{"create", "--base", this._workspacePath.toString(), "-t", "mvc-portlet", "-d", projectPath.toString(), "foo"};
        TestUtil.runBlade(this._workspaceDir, this._extensionsDir, args);
        Path path = projectPath.resolve("foo");
        Path bndPath = path.resolve("bnd.bnd");
        Assert.assertTrue((boolean)Files.exists(path, new LinkOption[0]));
        Assert.assertTrue((boolean)Files.exists(bndPath, new LinkOption[0]));
    }

    private BladeTest _getBladeTestCustomWorkspace(File workspaceDir) {
        BladeTest.BladeTestBuilder bladeTestBuilder = BladeTest.builder();
        bladeTestBuilder.setExtensionsDir(this._extensionsDir.toPath());
        bladeTestBuilder.setSettingsDir(workspaceDir.toPath());
        return bladeTestBuilder.build();
    }

    private void _makeSDK(File dir) throws Exception {
        Path dirPath = dir.toPath();
        Path portletsPath = dirPath.resolve("portlets");
        Files.createDirectories(portletsPath, new FileAttribute[0]);
        Assert.assertTrue((boolean)Files.exists(portletsPath, new LinkOption[0]));
        Path hooksPath = dirPath.resolve("hooks");
        Files.createDirectories(hooksPath, new FileAttribute[0]);
        Assert.assertTrue((boolean)Files.exists(hooksPath, new LinkOption[0]));
        Path layouttplPath = dirPath.resolve("layouttpl");
        Files.createDirectories(layouttplPath, new FileAttribute[0]);
        Assert.assertTrue((boolean)Files.exists(layouttplPath, new LinkOption[0]));
        Path themesPath = dirPath.resolve("themes");
        Files.createDirectories(themesPath, new FileAttribute[0]);
        Assert.assertTrue((boolean)Files.exists(themesPath, new LinkOption[0]));
        Path buildPropsPath = dirPath.resolve("build.properties");
        Files.createDirectories(buildPropsPath, new FileAttribute[0]);
        Assert.assertTrue((boolean)Files.exists(buildPropsPath, new LinkOption[0]));
        Path buildXmlPath = dirPath.resolve("build.xml");
        Files.createDirectories(buildXmlPath, new FileAttribute[0]);
        Assert.assertTrue((boolean)Files.exists(buildXmlPath, new LinkOption[0]));
        Path buildCommonXmlPath = dirPath.resolve("build-common.xml");
        Files.createDirectories(buildCommonXmlPath, new FileAttribute[0]);
        Assert.assertTrue((boolean)Files.exists(buildCommonXmlPath, new LinkOption[0]));
        Path buildCommonPluginXmlPath = dirPath.resolve("build-common-plugin.xml");
        Files.createDirectories(buildCommonPluginXmlPath, new FileAttribute[0]);
        Assert.assertTrue((boolean)Files.exists(buildCommonPluginXmlPath, new LinkOption[0]));
    }

    private void _testInitWithLiferayVersion(String liferayVersion) throws Exception {
        String[] args = new String[]{"--base", this._workspaceDir.getPath(), "init", "-v", liferayVersion};
        TestUtil.runBlade(this._workspaceDir, this._extensionsDir, args);
        Path gradlePropertiesPath = this._workspacePath.resolve("gradle.properties");
        String contents = new String(Files.readAllBytes(gradlePropertiesPath));
        Assert.assertTrue((String)contents, (boolean)contents.contains(String.format("liferay.workspace.product=%s", liferayVersion)));
    }

    private void _verifyGradleBuild() throws Exception {
        this._createBundle();
        Path projectPath = this._workspacePath.resolve("modules");
        BuildTask buildTask = GradleRunnerUtil.executeGradleRunner(this._workspacePath.toString(), "jar");
        GradleRunnerUtil.verifyGradleRunnerOutput(buildTask);
        projectPath = projectPath.resolve("foo");
        GradleRunnerUtil.verifyBuildOutput(projectPath.toString(), "foo-1.0.0.jar");
    }
}

