/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.gradle;

import aQute.bnd.version.Version;
import com.liferay.blade.cli.BladeCLI;
import com.liferay.blade.cli.WorkspaceProvider;
import com.liferay.blade.cli.command.BaseArgs;
import com.liferay.blade.cli.util.BladeUtil;
import com.liferay.blade.cli.util.ProductInfo;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GradleWorkspaceProvider
implements WorkspaceProvider {
    public static final Pattern patternDockerImageLiferayVersion = Pattern.compile(".*(?<=liferay/(?:dxp|portal):)(.{3}).*", 40);
    public static final Pattern patternWorkspacePlugin = Pattern.compile(".*apply\\s*plugin\\s*:\\s*['\"]com\\.liferay\\.workspace['\"]\\s*$", 40);
    public static final Pattern patternWorkspacePluginLatestRelease = Pattern.compile(".*name:\\s*\"com\\.liferay\\.gradle\\.plugins\\.workspace\",\\s*version:\\s*\"([latest\\.release|latest\\.integration]+)\".*", 40);
    public static final Pattern patternWorkspacePluginVersion = Pattern.compile(".*name:\\s*\"com\\.liferay\\.gradle\\.plugins\\.workspace\",\\s*version:\\s*\"([0-9\\.]+)\".*", 40);
    private static final String _BUILD_GRADLE_FILE_NAME = "build.gradle";
    private static final String _GRADLE_LOCAL_PROPERTIES_FILE_NAME = "gradle-local.properties";
    private static final String _GRADLE_PROPERTIES_FILE_NAME = "gradle.properties";
    private static final String _SETTINGS_GRADLE_FILE_NAME = "settings.gradle";

    public File getGradleLocalPropertiesFile(File dir) {
        return new File(this.getWorkspaceDir(dir), _GRADLE_LOCAL_PROPERTIES_FILE_NAME);
    }

    public Properties getGradleProperties(File dir) {
        Properties properties = BladeUtil.getProperties(this.getGradlePropertiesFile(dir));
        Properties gradleLocalProperties = BladeUtil.getProperties(this.getGradleLocalPropertiesFile(dir));
        properties.putAll((Map<?, ?>)gradleLocalProperties);
        return properties;
    }

    public File getGradlePropertiesFile(File dir) {
        return new File(this.getWorkspaceDir(dir), _GRADLE_PROPERTIES_FILE_NAME);
    }

    @Override
    public String getLiferayVersion(File workspaceDir) {
        try {
            Properties gradleProperties = this.getGradleProperties(workspaceDir);
            Optional<String> baseLiferayVersion = Optional.ofNullable(gradleProperties.getProperty("liferay.workspace.target.platform.version")).filter(BladeUtil::isNotEmpty);
            if (!baseLiferayVersion.isPresent()) {
                String productKey = gradleProperties.getProperty("liferay.workspace.product");
                Map<String, Object> productInfoMap = BladeUtil.getProductInfos();
                ProductInfo productInfo = new ProductInfo((Map)productInfoMap.get(productKey));
                if (productInfo != null) {
                    baseLiferayVersion = Optional.ofNullable(productInfo.getTargetPlatformVersion()).filter(BladeUtil::isNotEmpty);
                }
            }
            if (!baseLiferayVersion.isPresent()) {
                String dockerImageProperty = gradleProperties.getProperty("liferay.workspace.docker.image.liferay");
                if (BladeUtil.isEmpty(dockerImageProperty)) {
                    return null;
                }
                Matcher matcher = patternDockerImageLiferayVersion.matcher(dockerImageProperty);
                if (matcher.find()) {
                    baseLiferayVersion = Optional.of(matcher.group(1));
                    baseLiferayVersion = dockerImageProperty.contains("dxp") ? Optional.of(baseLiferayVersion.get() + ".10") : Optional.of(baseLiferayVersion.get() + ".0");
                }
            }
            if (baseLiferayVersion.isPresent()) {
                return baseLiferayVersion.get();
            }
        }
        catch (Exception exception) {
            BladeCLI.instance.error(exception);
        }
        return null;
    }

    @Override
    public String getProduct(File workspaceDir) {
        block9: {
            try {
                Properties gradleProperties = this.getGradleProperties(workspaceDir);
                String productKey = gradleProperties.getProperty("liferay.workspace.product");
                if (productKey == null) {
                    String targetPlatformVersion = gradleProperties.getProperty("liferay.workspace.target.platform.version");
                    if (targetPlatformVersion == null) {
                        String dockerImageProperty = gradleProperties.getProperty("liferay.workspace.docker.image.liferay");
                        if (dockerImageProperty == null) {
                            return "portal";
                        }
                        if (dockerImageProperty.contains("dxp")) {
                            return "dxp";
                        }
                    } else {
                        Version version = Version.parseVersion(targetPlatformVersion.replaceAll("-", "."));
                        int microVersion = version.getMicro();
                        if (microVersion >= 10) {
                            return "dxp";
                        }
                    }
                    break block9;
                }
                String product = productKey.substring(0, productKey.indexOf("-"));
                if (Objects.equals(product, "commerce")) {
                    product = "dxp";
                }
                return product;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "portal";
    }

    public File getSettingGradleFile(File dir) {
        return new File(this.getWorkspaceDir(dir), _SETTINGS_GRADLE_FILE_NAME);
    }

    @Override
    public File getWorkspaceDir(BladeCLI blade) {
        BaseArgs args = blade.getArgs();
        return this.getWorkspaceDir(args.getBase());
    }

    @Override
    public File getWorkspaceDir(File dir) {
        File gradleParent = BladeUtil.findParentFile(dir, new String[]{_SETTINGS_GRADLE_FILE_NAME, _GRADLE_PROPERTIES_FILE_NAME}, true);
        if (gradleParent != null && gradleParent.exists()) {
            return gradleParent;
        }
        FilenameFilter gradleFilter = (file, name) -> _SETTINGS_GRADLE_FILE_NAME.equals(name) || _GRADLE_PROPERTIES_FILE_NAME.equals(name);
        File[] matches = dir.listFiles(gradleFilter);
        if (Objects.nonNull(matches) && matches.length > 0) {
            return dir;
        }
        return null;
    }

    @Override
    public boolean isDependencyManagementEnabled(File dir) {
        block6: {
            if (!this.isWorkspace(dir)) {
                return false;
            }
            Properties properties = this.getGradleProperties(dir);
            String targetPlatformVersionKey = "liferay.workspace.target.platform.version";
            boolean targetPlatformEnabled = properties.containsKey(targetPlatformVersionKey);
            try {
                if (!targetPlatformEnabled) {
                    return false;
                }
                String settingsGradleFileContent = BladeUtil.read(this.getSettingGradleFile(dir));
                Matcher matcher = patternWorkspacePluginVersion.matcher(settingsGradleFileContent);
                if (matcher.find()) {
                    Version minVersion = new Version(1, 9, 0);
                    Version pluginVersion = new Version(matcher.group(1));
                    int result = pluginVersion.compareTo(minVersion);
                    if (result >= 0) {
                        return true;
                    }
                    break block6;
                }
                matcher = patternWorkspacePluginLatestRelease.matcher(settingsGradleFileContent);
                return matcher.find();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean isWorkspace(File dir) {
        File workspaceDir = this.getWorkspaceDir(dir);
        if (Objects.isNull(dir) || Objects.isNull(workspaceDir)) {
            return false;
        }
        File gradleFile = new File(workspaceDir, _SETTINGS_GRADLE_FILE_NAME);
        if (!gradleFile.exists()) {
            return false;
        }
        try {
            String script = BladeUtil.read(gradleFile);
            Matcher matcher = patternWorkspacePlugin.matcher(script);
            if (matcher.find()) {
                return true;
            }
            gradleFile = new File(workspaceDir, _BUILD_GRADLE_FILE_NAME);
            script = BladeUtil.read(gradleFile);
            matcher = patternWorkspacePlugin.matcher(script);
            return matcher.find();
        }
        catch (Exception exception) {
            return false;
        }
    }
}

