/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.util;

import com.liferay.blade.cli.BladeCLI;
import com.liferay.blade.cli.Extensions;
import com.liferay.blade.cli.command.SamplesCommand;
import com.liferay.blade.cli.command.validator.WorkspaceProductComparator;
import com.liferay.blade.cli.util.AnsiLinePrinter;
import com.liferay.blade.cli.util.FileUtil;
import com.liferay.blade.cli.util.Pair;
import com.liferay.blade.cli.util.ProductInfo;
import com.liferay.project.templates.ProjectTemplates;
import com.liferay.project.templates.extensions.util.ProjectTemplatesUtil;
import groovy.json.JsonSlurper;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.protocol.RedirectLocations;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.protocol.BasicHttpContext;
import org.gradle.internal.impldep.com.google.common.base.Strings;
import org.osgi.framework.Version;

public class BladeUtil {
    public static final String APP_SERVER_PARENT_DIR_PROPERTY = "app.server.parent.dir";
    public static final String APP_SERVER_TYPE_PROPERTY = "app.server.type";
    private static final String[] _APP_SERVER_PROPERTIES_FILE_NAMES = new String[]{"app.server." + System.getProperty("user.name") + ".properties", "app.server." + System.getenv("COMPUTERNAME") + ".properties", "app.server." + System.getenv("HOST") + ".properties", "app.server." + System.getenv("HOSTNAME") + ".properties", "app.server.properties", "build." + System.getProperty("user.name") + ".properties", "build." + System.getenv("COMPUTERNAME") + ".properties", "build." + System.getenv("HOST") + ".properties", "build." + System.getenv("HOSTNAME") + ".properties", "build.properties"};
    private static final String _DEFAULT_WORKSPACE_CACHE_DIR_NAME = ".liferay/workspace";
    private static final String _GRADLEW_UNIX_FILE_NAME = "gradlew";
    private static final String _GRADLEW_WINDOWS_FILE_NAME = "gradlew.bat";
    private static final String _PRODUCT_INFO_URL = "https://releases.liferay.com/tools/workspace/.product_info.json";
    private static final Pattern _microPattern = Pattern.compile("((([efs])p)|(ga)|(u))([0-9]+)(-[0-9]+)?");
    private static final Pattern _productCommerceVersionPattern = Pattern.compile("^(commerce)-([1-9]\\d|[0-9])\\.([0-9]\\d|\\d).([0-9]\\d|\\d)(-(([1-9]\\d|[0-9])\\.([1-9]\\d|[0-9])$)+)*");
    private static Map<String, Object> _productInfoMap = Collections.emptyMap();
    private static final Pattern _productPortalDXPVersionPattern = Pattern.compile("^(portal|dxp)-([1-9]\\d|[0-9])\\.([0-9]\\d|\\d)-(((([efsd])([pe]))|u|ga)([0-9]\\d*)$)+");
    private static final File _workspaceCacheDir = new File(System.getProperty("user.home"), ".liferay/workspace");

    public static void addGradleWrapper(File destinationDir) throws Exception {
        InputStream inputStream = SamplesCommand.class.getResourceAsStream("/wrapper.zip");
        FileUtil.unzip(inputStream, destinationDir);
        File gradlewFile = new File(destinationDir, _GRADLEW_UNIX_FILE_NAME);
        gradlewFile.setExecutable(true);
    }

    public static boolean canConnect(String host, int port) {
        InetSocketAddress localAddress = new InetSocketAddress(0);
        InetSocketAddress remoteAddress = new InetSocketAddress(host, port);
        return BladeUtil._canConnect(localAddress, remoteAddress);
    }

    public static int compareVersions(Version v1, Version v2) {
        if (v2 == v1) {
            return 0;
        }
        int result = v1.getMajor() - v2.getMajor();
        if (result != 0) {
            return result;
        }
        result = v1.getMinor() - v2.getMinor();
        if (result != 0) {
            return result;
        }
        result = v1.getMicro() - v2.getMicro();
        if (result != 0) {
            return result;
        }
        String s1 = v1.getQualifier();
        return s1.compareTo(v2.getQualifier());
    }

    public static Path downloadFile(String urlString, Path cacheDirPath, String targetFileName) throws Exception {
        URL downladURL = new URL(urlString);
        URI downladURI = downladURL.toURI();
        if (Objects.equals(downladURI.getScheme(), "file")) {
            return Paths.get(downladURI);
        }
        try (CloseableHttpClient closeableHttpClient = BladeUtil.getHttpClient(downladURL.toURI(), null, null);){
            Path path = BladeUtil._downloadFile(closeableHttpClient, downladURI, cacheDirPath, targetFileName);
            return path;
        }
    }

    public static Path downloadGithubProject(String url, String target) throws Exception {
        String zipUrl = url + "/archive/master.zip";
        Path githubCacheDirPath = BladeUtil.getBladeCachePath().resolve("github");
        return BladeUtil.downloadFile(zipUrl, githubCacheDirPath, target);
    }

    public static File findParentFile(File dir, String[] fileNames, boolean checkParents) {
        if (dir == null) {
            return null;
        }
        if (Objects.equals(dir.toString(), ".") || !dir.isAbsolute()) {
            try {
                dir = dir.getCanonicalFile();
            }
            catch (Exception exception) {
                dir = dir.getAbsoluteFile();
            }
        }
        for (String fileName : fileNames) {
            File file = new File(dir, fileName);
            if (!file.exists()) continue;
            return dir;
        }
        if (checkParents) {
            return BladeUtil.findParentFile(dir.getParentFile(), fileNames, checkParents);
        }
        return null;
    }

    public static List<Properties> getAppServerProperties(File dir) {
        File projectRoot = BladeUtil.findParentFile(dir, _APP_SERVER_PROPERTIES_FILE_NAMES, true);
        ArrayList<Properties> properties = new ArrayList<Properties>();
        for (String fileName : _APP_SERVER_PROPERTIES_FILE_NAMES) {
            File file = new File(projectRoot, fileName);
            if (!file.exists()) continue;
            properties.add(BladeUtil.getProperties(file));
        }
        return properties;
    }

    public static Path getBladeCachePath() {
        File userHome = new File(System.getProperty("user.home"));
        Path userHomePath = userHome.toPath();
        return userHomePath.resolve(".blade" + File.separator + "cache");
    }

    public static Path getBladeJarPath() {
        try {
            ProtectionDomain protectionDomain = BladeCLI.class.getProtectionDomain();
            CodeSource codeSource = protectionDomain.getCodeSource();
            URL location = codeSource.getLocation();
            File file = new File(location.toURI());
            return file.toPath();
        }
        catch (URISyntaxException uriSyntaxException) {
            throw new RuntimeException(uriSyntaxException);
        }
    }

    public static String getBundleVersion(Path pathToJar) throws IOException {
        return BladeUtil.getManifestProperty(pathToJar, "Bundle-Version");
    }

    public static Path getCurrentPath() {
        Path currentPath = Paths.get("", new String[0]);
        Path destinationNormalizePath = currentPath.normalize();
        return destinationNormalizePath.toAbsolutePath();
    }

    public static File getGradleWrapper(File dir) {
        File gradleRoot = BladeUtil.findParentFile(dir, new String[]{_GRADLEW_UNIX_FILE_NAME, _GRADLEW_WINDOWS_FILE_NAME}, true);
        if (gradleRoot != null) {
            if (BladeUtil.isWindows()) {
                return new File(gradleRoot, _GRADLEW_WINDOWS_FILE_NAME);
            }
            return new File(gradleRoot, _GRADLEW_UNIX_FILE_NAME);
        }
        return null;
    }

    public static CloseableHttpClient getHttpClient(URI uri, String userName, String password) {
        String proxyPassword;
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        requestConfigBuilder.setCookieSpec(RequestConfig.DEFAULT.getCookieSpec());
        requestConfigBuilder.setRedirectsEnabled(true);
        httpClientBuilder.setDefaultRequestConfig(requestConfigBuilder.build());
        String scheme = uri.getScheme();
        String proxyHost = System.getProperty(scheme + ".proxyHost");
        String proxyPort = System.getProperty(scheme + ".proxyPort");
        String proxyUser = userName;
        if (Objects.isNull(proxyUser)) {
            proxyUser = System.getProperty(scheme + ".proxyUser");
        }
        if (Objects.isNull(proxyPassword = password)) {
            proxyPassword = System.getProperty(scheme + ".proxyPassword");
        }
        if (proxyUser != null && proxyPassword != null) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            if (proxyHost != null && proxyPort != null) {
                credentialsProvider.setCredentials(new AuthScope(proxyHost, Integer.parseInt(proxyPort)), new UsernamePasswordCredentials(proxyUser, proxyPassword.toCharArray()));
            }
            httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        } else if (proxyHost != null && proxyPort != null) {
            httpClientBuilder.setProxy(new HttpHost(proxyHost, Integer.parseInt(proxyPort)));
        }
        httpClientBuilder.useSystemProperties();
        return httpClientBuilder.build();
    }

    public static Map<String, String> getInitTemplates(BladeCLI bladeCLI) throws IOException {
        HashMap<String, String> initTemplates = new HashMap<String, String>();
        initTemplates.put("workspace", "Liferay Workspace built with Gradle or Maven.");
        Path extensions = bladeCLI.getExtensionsPath();
        try {
            DirectoryStream<Path> directoryStream = Files.newDirectoryStream(extensions, "*.project.templates.workspace*");
            for (Path path : directoryStream) {
                String fileName = String.valueOf(path.getFileName());
                String template = ProjectTemplatesUtil.getTemplateName(fileName);
                String bundleDescription = FileUtil.getManifestProperty(path.toFile(), "Bundle-Description");
                initTemplates.put(template, bundleDescription);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return initTemplates;
    }

    public static String getManifestProperty(Path pathToJar, String propertyName) throws IOException {
        File file = pathToJar.toFile();
        try (JarFile jar = new JarFile(file);){
            Manifest manifest = jar.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            String string = attributes.getValue(propertyName);
            return string;
        }
    }

    public static Map<String, Object> getProductInfos() {
        return BladeUtil.getProductInfos(false, null);
    }

    public static synchronized Map<String, Object> getProductInfos(boolean trace, PrintStream printStream) {
        block30: {
            if (!_productInfoMap.isEmpty()) {
                return _productInfoMap;
            }
            JsonSlurper jsonSlurper = new JsonSlurper();
            try {
                Path productInfoPath = BladeUtil.downloadFile(_PRODUCT_INFO_URL, _workspaceCacheDir.toPath(), ".product_info.json");
                try (BufferedReader reader = Files.newBufferedReader(productInfoPath);){
                    _productInfoMap = (Map)jsonSlurper.parse(reader);
                }
            }
            catch (Exception exception1) {
                if (trace && printStream != null) {
                    exception1.printStackTrace(printStream);
                }
                try (InputStream resourceAsStream = BladeUtil.class.getResourceAsStream("/.product_info.json");){
                    _productInfoMap = (Map)jsonSlurper.parse(resourceAsStream);
                }
                catch (Exception exception2) {
                    if (!trace || printStream == null) break block30;
                    exception2.printStackTrace(printStream);
                }
            }
        }
        return _productInfoMap;
    }

    public static Properties getProperties(File file) {
        Properties properties = new Properties();
        try (InputStream inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            properties.load(inputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return properties;
    }

    public static Collection<String> getTemplateNames(BladeCLI blade) throws Exception {
        Map<String, String> templates = BladeUtil.getTemplates(blade);
        return templates.keySet();
    }

    public static Map<String, String> getTemplates(BladeCLI bladeCLI) throws Exception {
        Path extensionsPath = bladeCLI.getExtensionsPath();
        HashSet<File> templatesFiles = new HashSet<File>();
        templatesFiles.add(extensionsPath.toFile());
        Extensions extensions = bladeCLI.getExtensions();
        Path extensionTemplates = extensions.getTemplatesPath();
        templatesFiles.add(extensionTemplates.toFile());
        return ProjectTemplates.getTemplates(templatesFiles);
    }

    public static List<String> getWorkspaceProductKeys(boolean promoted) {
        Map<String, Object> productInfos = BladeUtil.getProductInfos();
        return productInfos.keySet().stream().filter(key -> Objects.nonNull(productInfos.get(key))).map(key -> new Pair<String, ProductInfo>((String)key, new ProductInfo((Map)productInfos.get(key)))).filter(pair -> {
            ProductInfo productInfo = (ProductInfo)pair.second();
            return Objects.nonNull(productInfo.getTargetPlatformVersion()) && (!promoted || productInfo.isPromoted());
        }).sorted(new WorkspaceProductComparator()).map(Pair::first).collect(Collectors.toList());
    }

    public static Set<String> getWorkspaceProductTargetPlatformVersions(boolean promoted) {
        Map<String, Object> productInfos = BladeUtil.getProductInfos();
        return productInfos.entrySet().stream().filter(entry -> Objects.nonNull(productInfos.get(entry.getKey()))).map(entry -> new ProductInfo((Map)productInfos.get(entry.getKey()))).filter(product -> Objects.nonNull(product.getTargetPlatformVersion()) && (!promoted || product.isPromoted())).map(ProductInfo::getTargetPlatformVersion).collect(Collectors.toSet());
    }

    public static boolean hasGradleWrapper(File dir) {
        File gradlew = new File(dir, _GRADLEW_UNIX_FILE_NAME);
        File gradleBat = new File(dir, _GRADLEW_WINDOWS_FILE_NAME);
        if (gradlew.exists() && gradleBat.exists()) {
            return true;
        }
        File parent = dir.getParentFile();
        if (parent != null && parent.exists()) {
            return BladeUtil.hasGradleWrapper(parent);
        }
        return false;
    }

    public static boolean isDirEmpty(Path directory) throws IOException {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(directory);){
            Iterator<Path> iterator = directoryStream.iterator();
            boolean bl = !iterator.hasNext();
            return bl;
        }
    }

    public static boolean isEmpty(List<?> list) {
        return list == null || list.isEmpty();
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static boolean isNotEmpty(List<?> list) {
        return !BladeUtil.isEmpty(list);
    }

    public static boolean isNotEmpty(Object[] array) {
        return !BladeUtil.isEmpty(array);
    }

    public static boolean isNotEmpty(String string) {
        return !BladeUtil.isEmpty(string);
    }

    public static boolean isSafelyRelative(File file, File destDir) {
        Path destPath = destDir.toPath();
        destPath = destPath.toAbsolutePath();
        destPath = destPath.normalize();
        Path path = file.toPath();
        path = path.toAbsolutePath();
        path = path.normalize();
        return path.startsWith(destPath);
    }

    public static boolean isWindows() {
        String osName = System.getProperty("os.name");
        osName = osName.toLowerCase();
        return osName.contains("windows");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isZipValid(File file) {
        try (ZipFile zipFile = new ZipFile(file);){
            boolean bl = true;
            return bl;
        }
        catch (IOException ioException) {
            return false;
        }
    }

    public static String read(File file) throws IOException {
        return new String(Files.readAllBytes(file.toPath()));
    }

    public static void readProcessStream(final InputStream inputStream, final PrintStream printStream) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try (Scanner scanner = new Scanner(inputStream);){
                    while (scanner.hasNextLine()) {
                        String line = scanner.nextLine();
                        if (line == null) continue;
                        AnsiLinePrinter.println(printStream, line);
                    }
                }
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    public static boolean searchZip(Path path, Predicate<String> test) {
        boolean retCode = false;
        if (Files.exists(path, new LinkOption[0]) && !Files.isDirectory(path, new LinkOption[0])) {
            try (ZipFile zipFile = new ZipFile(path.toFile());){
                Stream<? extends ZipEntry> stream = zipFile.stream();
                Collection entryCollection = stream.collect(Collectors.toSet());
                for (ZipEntry zipEntry : entryCollection) {
                    String entryName;
                    if (zipEntry.isDirectory() || !test.test(entryName = zipEntry.getName())) continue;
                    retCode = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return retCode;
    }

    public static void setShell(ProcessBuilder processBuilder, String cmd) {
        Map<String, String> env = processBuilder.environment();
        ArrayList<String> commands = new ArrayList<String>();
        if (BladeUtil.isWindows()) {
            commands.add("cmd.exe");
            commands.add("/c");
        } else {
            env.put("PATH", env.get("PATH") + ":/bin:/usr/local/bin");
            commands.add("sh");
            commands.add("-c");
        }
        commands.add(cmd);
        processBuilder.command(commands);
    }

    public static String simplifyTargetPlatformVersion(String targetPlatformVersion) {
        if (targetPlatformVersion == null) {
            return null;
        }
        String[] segments = targetPlatformVersion.split("\\.");
        StringBuilder sb = new StringBuilder();
        sb.append(segments[0]);
        sb.append('.');
        sb.append(segments[1]);
        sb.append('.');
        String micro = segments[2];
        int dashPosition = micro.indexOf("-");
        if (dashPosition > 0) {
            sb.append(micro, 0, dashPosition);
            if (segments.length == 3) {
                sb.append(".");
                sb.append(micro.substring(dashPosition + 1));
            }
        } else {
            sb.append(micro);
        }
        if (segments.length > 3) {
            sb.append(".");
            String qualifier = segments[3];
            Matcher matcher = _microPattern.matcher(qualifier);
            if (matcher.matches() && matcher.groupCount() >= 5) {
                qualifier = matcher.group(5);
            }
            if (!Strings.isNullOrEmpty(qualifier)) {
                sb.append(qualifier);
            }
        }
        return sb.toString();
    }

    public static Process startProcess(String command, File workingDir) throws Exception {
        return BladeUtil.startProcess(command, workingDir, null);
    }

    public static Process startProcess(String command, File dir, Map<String, String> environment) throws Exception {
        ProcessBuilder processBuilder = BladeUtil._buildProcessBuilder(command, dir, environment, true);
        Process process = processBuilder.start();
        OutputStream outputStream = process.getOutputStream();
        outputStream.close();
        return process;
    }

    public static Process startProcess(String command, File dir, Map<String, String> environment, PrintStream out, PrintStream err) throws Exception {
        ProcessBuilder processBuilder = BladeUtil._buildProcessBuilder(command, dir, environment, false);
        Process process = processBuilder.start();
        BladeUtil.readProcessStream(process.getInputStream(), out);
        BladeUtil.readProcessStream(process.getErrorStream(), err);
        OutputStream outputStream = process.getOutputStream();
        outputStream.close();
        return process;
    }

    public static Process startProcess(String command, File dir, PrintStream out, PrintStream err) throws Exception {
        return BladeUtil.startProcess(command, dir, null, out, err);
    }

    /*
     * Exception decompiling
     */
    public static void tail(Path path, PrintStream printStream) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 10[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean verifyCommerceWorkspaceProduct(String product) {
        Matcher matcher = _productCommerceVersionPattern.matcher(product);
        return matcher.matches();
    }

    public static boolean verifyPortalDxpWorkspaceProduct(String product) {
        Matcher matcher = _productPortalDXPVersionPattern.matcher(product);
        return matcher.matches();
    }

    public static void writePropertyValue(File propertyFile, String key, String value) throws Exception {
        String property = System.lineSeparator() + key + "=" + value;
        Files.write(propertyFile.toPath(), property.getBytes(), StandardOpenOption.APPEND);
    }

    private static ProcessBuilder _buildProcessBuilder(String command, File dir, Map<String, String> environment, boolean inheritIO) {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        Map<String, String> env = processBuilder.environment();
        if (environment != null) {
            env.putAll(environment);
        }
        if (dir != null && dir.exists()) {
            processBuilder.directory(dir);
        }
        BladeUtil.setShell(processBuilder, command);
        if (inheritIO) {
            processBuilder.inheritIO();
        }
        return processBuilder;
    }

    private static boolean _canConnect(InetSocketAddress localAddress, InetSocketAddress remoteAddress) {
        boolean connected = false;
        try (Socket socket = new Socket();){
            socket.bind(localAddress);
            socket.connect(remoteAddress, 3000);
            socket.getInputStream();
            connected = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return connected;
    }

    private static void _checkResponseStatus(HttpResponse httpResponse) throws IOException {
        if (httpResponse.getCode() != 200) {
            throw new IOException(httpResponse.getReasonPhrase());
        }
    }

    private static Path _downloadFile(CloseableHttpClient closeableHttpClient, URI uri, Path cacheDirPath, String targetFileName) throws Exception {
        Date lastModifiedDate;
        HttpHead httpHead = new HttpHead(uri);
        BasicHttpContext httpContext = new BasicHttpContext();
        try (CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute((ClassicHttpRequest)httpHead, httpContext);){
            Header lastModifiedHeader;
            RedirectLocations redirectLocations;
            BladeUtil._checkResponseStatus(closeableHttpResponse);
            Header dispositionHeader = closeableHttpResponse.getFirstHeader("Content-Disposition");
            if (dispositionHeader == null && (redirectLocations = (RedirectLocations)httpContext.getAttribute("http.protocol.redirect-locations")) != null && redirectLocations.size() > 0) {
                uri = redirectLocations.get(redirectLocations.size() - 1);
            }
            lastModifiedDate = (lastModifiedHeader = closeableHttpResponse.getFirstHeader("Last-Modified")) != null ? DateUtils.parseDate(lastModifiedHeader.getValue()) : new Date();
        }
        Files.createDirectories(cacheDirPath, new FileAttribute[0]);
        Path targetPath = cacheDirPath.resolve(targetFileName);
        if (Files.exists(targetPath, new LinkOption[0])) {
            FileTime fileTime = Files.getLastModifiedTime(targetPath, new LinkOption[0]);
            if (fileTime.toMillis() == lastModifiedDate.getTime()) {
                return targetPath;
            }
            Files.delete(targetPath);
        }
        HttpGet httpGet = new HttpGet(uri);
        try (CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute(httpGet);){
            BladeUtil._checkResponseStatus(closeableHttpResponse);
            HttpEntity httpEntity = closeableHttpResponse.getEntity();
            try (InputStream inputStream = httpEntity.getContent();
                 OutputStream outputStream = Files.newOutputStream(targetPath, new OpenOption[0]);){
                byte[] buffer = new byte[10240];
                int read = -1;
                while ((read = inputStream.read(buffer)) >= 0) {
                    outputStream.write(buffer, 0, read);
                }
            }
        }
        Files.setLastModifiedTime(targetPath, FileTime.fromMillis(lastModifiedDate.getTime()));
        return targetPath;
    }
}

