/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.util;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;

public class CopyDirVisitor
extends SimpleFileVisitor<Path> {
    private final CopyOption _copyOption;
    private boolean _deleteSource;
    private final Path _fromPath;
    private final Path _toPath;

    public CopyDirVisitor(Path fromPath, Path toPath, CopyOption copyOption) {
        this._fromPath = fromPath;
        this._toPath = toPath;
        this._copyOption = copyOption;
        this._deleteSource = false;
    }

    public CopyDirVisitor(Path fromPath, Path toPath, CopyOption copyOption, boolean deleteSource) {
        this._fromPath = fromPath;
        this._toPath = toPath;
        this._copyOption = copyOption;
        this._deleteSource = deleteSource;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path file, IOException ioException) throws IOException {
        if (this._deleteSource) {
            FileUtils.forceDelete(file.toFile());
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        Path targetPath = this._toPath.resolve(this._fromPath.relativize(dir));
        if (!Files.exists(targetPath, new LinkOption[0])) {
            Files.createDirectory(targetPath, new FileAttribute[0]);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        Files.copy(file, this._toPath.resolve(this._fromPath.relativize(file)), this._copyOption);
        return FileVisitResult.CONTINUE;
    }
}

