/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.util;

import com.liferay.blade.cli.util.BndPropertiesValue;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;

public class BndProperties
extends Properties {
    private static final int _PAGE_SIZE = 4096;
    private static final Charset _UTF8 = Charset.forName("UTF-8");
    private static final List<String> _keyList = new ArrayList<String>();
    private static final long serialVersionUID = 1L;

    public void addKeyList(String key) {
        if (_keyList.contains(key)) {
            return;
        }
        _keyList.add(key);
    }

    public void addValue(String key, BndPropertiesValue newBdValue) {
        BndPropertiesValue bdValue = (BndPropertiesValue)this.get(key);
        this.addKeyList(key);
        if (bdValue != null) {
            String originalValue = bdValue.getOriginalValue();
            if (originalValue != null && !originalValue.isEmpty()) {
                StringBuilder formatedValueBuilder = new StringBuilder(bdValue.getFormatedValue());
                StringBuilder originalValueBuilder = new StringBuilder(bdValue.getOriginalValue());
                String newOriginalValue = newBdValue.getOriginalValue();
                String[] newOriginalValues = newOriginalValue.split(",");
                BndPropertiesValue inputValue = new BndPropertiesValue();
                for (String newValue : newOriginalValues) {
                    if (originalValue.contains(newValue)) continue;
                    if (bdValue.isMultiLine()) {
                        formatedValueBuilder.append(",\\" + System.getProperty("line.separator"));
                        formatedValueBuilder.append("\t" + newValue);
                        inputValue.setFormatedValue(formatedValueBuilder.toString());
                        continue;
                    }
                    originalValueBuilder.append(",");
                    originalValueBuilder.append(newValue);
                    inputValue.setFormatedValue(originalValueBuilder.toString());
                }
                this.put(key, inputValue);
            } else {
                this.put(key, newBdValue);
            }
        } else {
            this.put(key, newBdValue);
        }
    }

    public String getReader(Reader a) throws IOException {
        StringWriter sw = new StringWriter();
        char[] buffer = new char[4096];
        int size = a.read(buffer);
        while (size > 0) {
            sw.write(buffer, 0, size);
            size = a.read(buffer);
        }
        return sw.toString();
    }

    public void load(File bndFile) throws IOException {
        try (FileInputStream in = new FileInputStream(bndFile);){
            this.load(in);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void load(InputStream inStream) throws IOException {
        String buffer;
        BufferedReader reader = new BufferedReader(new InputStreamReader(inStream, "ISO-8859-1"));
        while ((buffer = reader.readLine()) != null) {
            StringBuilder key;
            int pos;
            String line = this._convert(buffer.getBytes(), _UTF8);
            char c = '\u0000';
            for (pos = 0; pos < line.length() && Character.isWhitespace(c = line.charAt(pos)); ++pos) {
            }
            if (line.length() - pos == 0 || line.charAt(pos) == '#' || line.charAt(pos) == '!') continue;
            int start = pos;
            boolean needsEscape = false;
            if (line.indexOf(92, pos) != -1) {
                needsEscape = true;
            }
            StringBuilder stringBuilder = key = needsEscape ? new StringBuilder() : null;
            block14: while (pos < line.length() && !Character.isWhitespace(c = line.charAt(pos++)) && c != '=' && c != ':') {
                if (needsEscape && c == '\\') {
                    if (pos == line.length()) {
                        line = reader.readLine();
                        if (line == null) {
                            line = "";
                        }
                        for (pos = 0; pos < line.length() && Character.isWhitespace(c = line.charAt(pos)); ++pos) {
                        }
                        continue;
                    }
                    c = line.charAt(pos++);
                    switch (c) {
                        case 'n': {
                            key.append('\n');
                            continue block14;
                        }
                        case 't': {
                            key.append('\t');
                            continue block14;
                        }
                        case 'r': {
                            key.append('\r');
                            continue block14;
                        }
                        case 'u': {
                            if (pos + 4 > line.length()) continue block14;
                            char uni = (char)Integer.parseInt(line.substring(pos, pos + 4), 16);
                            key.append(uni);
                            pos += 4;
                            continue block14;
                        }
                    }
                    key.append(c);
                    continue;
                }
                if (!needsEscape) continue;
                key.append(c);
            }
            boolean delim = false;
            if (c == ':' || c == '=') {
                delim = true;
            }
            String keyString = needsEscape ? key.toString() : (delim || Character.isWhitespace(c) ? line.substring(start, pos - 1) : line.substring(start, pos));
            while (pos < line.length() && Character.isWhitespace(c = line.charAt(pos))) {
                ++pos;
            }
            if (!(delim || c != ':' && c != '=')) {
                ++pos;
                while (pos < line.length() && Character.isWhitespace(c = line.charAt(pos))) {
                    ++pos;
                }
            }
            BndPropertiesValue bnd = new BndPropertiesValue();
            if (!needsEscape) {
                bnd.setOriginalValue(line.substring(pos));
                bnd.setFormatedValue(line.substring(pos));
                this.addKeyList(keyString);
                this.put(keyString, bnd);
                continue;
            }
            StringBuilder element = new StringBuilder(line.length() - pos);
            StringBuilder formatedElement = new StringBuilder(line.substring(pos));
            block18: while (pos < line.length()) {
                if ((c = line.charAt(pos++)) == '\\') {
                    if (pos == line.length()) {
                        bnd.setMultiLine(true);
                        formatedElement.append(System.getProperty("line.separator"));
                        line = reader.readLine();
                        formatedElement.append(line);
                        if (line == null) break;
                        for (pos = 0; pos < line.length() && Character.isWhitespace(c = line.charAt(pos)); ++pos) {
                        }
                        element.ensureCapacity(line.length() - pos + element.length());
                        continue;
                    }
                    c = line.charAt(pos++);
                    switch (c) {
                        case 'n': {
                            element.append('\n');
                            formatedElement.append('\n');
                            continue block18;
                        }
                        case 't': {
                            element.append('\t');
                            formatedElement.append('\t');
                            continue block18;
                        }
                        case 'r': {
                            element.append('\r');
                            formatedElement.append('\r');
                            continue block18;
                        }
                        case 'u': {
                            if (pos + 4 > line.length()) continue block18;
                            char uni = (char)Integer.parseInt(line.substring(pos, pos + 4), 16);
                            element.append(uni);
                            pos += 4;
                            continue block18;
                        }
                    }
                    element.append(c);
                    continue;
                }
                element.append(c);
            }
            bnd.setOriginalValue(element.toString());
            bnd.setFormatedValue(formatedElement.toString());
            this.addKeyList(keyString);
            this.put(keyString, bnd);
        }
    }

    @Override
    public void store(OutputStream out, String header) throws IOException {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(out));
        if (header != null) {
            writer.println("#" + header);
            Calendar calender = Calendar.getInstance();
            writer.println("#" + calender.getTime());
        }
        StringBuilder s = new StringBuilder();
        for (String keyString : _keyList) {
            this._formatForOutput(keyString, s, true);
            s.append(": ");
            Object value = this.get(keyString);
            if (value instanceof BndPropertiesValue) {
                BndPropertiesValue bndValue = (BndPropertiesValue)value;
                writer.println(s.append(bndValue.getFormatedValue()));
                continue;
            }
            this._formatForOutput((String)value, s, false);
            writer.println(s);
        }
        writer.flush();
    }

    private String _convert(byte[] buffer, Charset charset) throws IOException {
        CharBuffer cb;
        ByteBuffer bb;
        CharsetDecoder decoder = charset.newDecoder();
        CoderResult result = decoder.decode(bb = ByteBuffer.wrap(buffer), cb = CharBuffer.allocate(buffer.length * 4), true);
        if (!result.isError()) {
            return new String(cb.array(), 0, cb.position());
        }
        throw new CharacterCodingException();
    }

    private void _formatForOutput(String str, StringBuilder buffer, boolean key) {
        if (key) {
            buffer.setLength(0);
            buffer.ensureCapacity(str.length());
        } else {
            buffer.ensureCapacity(buffer.length() + str.length());
        }
        boolean head = true;
        int size = str.length();
        for (int i = 0; i < size; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\n': {
                    buffer.append("\\n");
                    break;
                }
                case '\r': {
                    buffer.append("\\r");
                    break;
                }
                case '\t': {
                    buffer.append("\\t");
                    break;
                }
                case ' ': {
                    buffer.append(head ? "\\ " : " ");
                    break;
                }
                case '!': 
                case '#': {
                    buffer.append('\\');
                    buffer.append(c);
                    break;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        String hex = Integer.toHexString(c);
                        buffer.append("\\u0000".substring(0, 6 - hex.length()));
                        buffer.append(hex);
                        break;
                    }
                    buffer.append(c);
                }
            }
            if (c == ' ') continue;
            head = key;
        }
    }
}

