/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.command;

import aQute.bnd.version.Version;
import com.liferay.blade.cli.BladeCLI;
import com.liferay.blade.cli.BladeSettings;
import com.liferay.blade.cli.WorkspaceProvider;
import com.liferay.blade.cli.command.BaseArgs;
import com.liferay.blade.cli.command.BaseCommand;
import com.liferay.blade.cli.command.InitArgs;
import com.liferay.blade.cli.gradle.GradleExec;
import com.liferay.blade.cli.util.BladeUtil;
import com.liferay.blade.cli.util.ProductInfo;
import com.liferay.project.templates.ProjectTemplates;
import com.liferay.project.templates.extensions.ProjectTemplatesArgs;
import com.liferay.project.templates.extensions.util.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;

public class InitCommand
extends BaseCommand<InitArgs> {
    private static final String[] _SDK_6_GA5_FILES = new String[]{"app-servers.gradle", "build.gradle", "build-plugins.gradle", "build-themes.gradle", "sdk.gradle", "settings.gradle", "util.gradle", "versions.gradle"};
    private static List<String> _legacyProductKeys = Arrays.asList("portal-7.0-ga1", "portal-7.0-ga2", "portal-7.0-ga3", "portal-7.0-ga4", "portal-7.0-ga5", "portal-7.0-ga6");

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void execute() throws Exception {
        String customInitTemplateName;
        Set<String> templateNames;
        String liferayVersion;
        Object productInfoObject;
        String workspaceProductKey;
        boolean mavenBuild;
        String profileName;
        boolean pluginsSDK;
        File temp;
        File destDir;
        BaseArgs args;
        String name;
        InitArgs initArgs;
        BladeCLI bladeCLI;
        block30: {
            File baseDir;
            block29: {
                bladeCLI = this.getBladeCLI();
                initArgs = (InitArgs)this.getArgs();
                if (initArgs.isList()) {
                    List<String> keys = BladeUtil.getWorkspaceProductKeys(!initArgs.isAll());
                    keys.forEach(bladeCLI::out);
                    return;
                }
                name = initArgs.getName();
                baseDir = initArgs.getBase();
                args = bladeCLI.getArgs();
                if (baseDir == null) {
                    baseDir = args.getBase();
                }
                Path correctPath = baseDir.toPath();
                if (Objects.nonNull(name)) {
                    correctPath = correctPath.resolve(name);
                }
                correctPath = correctPath.normalize();
                destDir = correctPath.toFile();
                temp = null;
                pluginsSDK = this._isPluginsSDK(destDir);
                this._trace("Using destDir " + destDir);
                if (destDir.exists() && !destDir.isDirectory()) {
                    this._addError(destDir.getAbsolutePath() + " is not a directory.");
                    return;
                }
                profileName = initArgs.getProfileName();
                mavenBuild = Objects.equals(profileName, "maven");
                if (!destDir.exists()) break block29;
                if (pluginsSDK) {
                    if (!this._isPluginsSDK70(destDir)) {
                        if (!initArgs.isUpgrade()) {
                            this._addError("Unable to run blade init in Plugins SDK 6.2, please add -u (--upgrade) if you want to upgrade to 7.0");
                            return;
                        }
                        if (mavenBuild) {
                            this._addError("Upgrading Plugins SDK in Liferay Maven Workspace not supported.");
                            return;
                        }
                        this._trace("Found plugins-sdk 6.2, upgraded to 7.0, moving contents to new subdirectory and initing workspace.");
                        for (String fileName : _SDK_6_GA5_FILES) {
                            File file = new File(destDir, fileName);
                            if (!file.exists()) continue;
                            file.delete();
                        }
                    }
                    this._trace("Found Plugins SDK, moving contents to new subdirectory and initing workspace.");
                    Path tempDir = Files.createTempDirectory("orignal-sdk", new FileAttribute[0]);
                    temp = tempDir.toFile();
                    this._moveContentsToDirectory(destDir, temp);
                    break block30;
                } else {
                    String[] files = destDir.list();
                    if (files != null && files.length > 0) {
                        if (!initArgs.isForce()) {
                            this._addError(destDir.getAbsolutePath() + " contains files, please move them before continuing or use -f (--force) option to init workspace.");
                            return;
                        }
                        this._trace("Files found, continuing init.");
                    }
                }
                break block30;
            }
            WorkspaceProvider workspaceProvider = bladeCLI.getWorkspaceProvider(baseDir);
            if (workspaceProvider != null) {
                this._addError("blade does not support initializing a workspace inside of another workspace.");
                return;
            }
        }
        ProjectTemplatesArgs projectTemplatesArgs = new ProjectTemplatesArgs();
        List<File> archetypesDirs = projectTemplatesArgs.getArchetypesDirs();
        Path customTemplatesPath = bladeCLI.getExtensionsPath();
        archetypesDirs.add(customTemplatesPath.toFile());
        if (name == null || Objects.equals(name, ".")) {
            name = destDir.getName();
        }
        File destParentDir = destDir.getParentFile();
        projectTemplatesArgs.setDestinationDir(destParentDir);
        if (initArgs.isForce() || initArgs.isUpgrade()) {
            projectTemplatesArgs.setForce(true);
        }
        projectTemplatesArgs.setGradle(!mavenBuild);
        Map<String, Object> productInfos = BladeUtil.getProductInfos(initArgs.isTrace(), bladeCLI.error());
        if (!mavenBuild) {
            workspaceProductKey = this._getDefaultProductKey(initArgs);
            if (_legacyProductKeys.contains(workspaceProductKey)) {
                this._addError("This version of blade does not support " + workspaceProductKey + ". Please use blade 3.9.2 to initialize a workspace with this version. https://bit.ly/3lVgTeH");
                return;
            }
            productInfoObject = productInfos.get(workspaceProductKey);
            if (productInfoObject == null) {
                this._addError("Unable to get product info for selected version " + workspaceProductKey);
                return;
            }
            ProductInfo productInfo = new ProductInfo((Map)productInfoObject);
            Version targetPlatformVersion = this._makeCompatibleVersion(productInfo.getTargetPlatformVersion());
            liferayVersion = new String(targetPlatformVersion.getMajor() + "." + targetPlatformVersion.getMinor() + "." + targetPlatformVersion.getMicro());
        } else {
            workspaceProductKey = this._setProductAndVersionForMaven(productInfos, initArgs);
            liferayVersion = initArgs.getLiferayVersion();
        }
        productInfoObject = productInfos.get(workspaceProductKey);
        if (productInfoObject == null) {
            this._addError("Unable to get product info for selected version " + workspaceProductKey);
            return;
        }
        if (Objects.equals(initArgs.getLiferayProduct(), "commerce")) {
            initArgs.setLiferayProduct("dxp");
        }
        projectTemplatesArgs.setLiferayVersion(liferayVersion);
        projectTemplatesArgs.setMaven(mavenBuild);
        projectTemplatesArgs.setName(name);
        if (mavenBuild) {
            projectTemplatesArgs.setLiferayProduct(initArgs.getLiferayProduct());
        }
        String template = "workspace";
        Map<String, String> initTemplates = BladeUtil.getInitTemplates(bladeCLI);
        if (profileName != null && (templateNames = initTemplates.keySet()).contains(customInitTemplateName = "workspace-" + profileName)) {
            template = customInitTemplateName;
        }
        projectTemplatesArgs.setTemplate(template);
        new ProjectTemplates(projectTemplatesArgs);
        if (mavenBuild) {
            FileUtil.deleteFiles(destDir.toPath(), "gradle.properties", "gradle-local.properties");
        } else {
            BladeUtil.writePropertyValue(new File(destDir, "gradle.properties"), "liferay.workspace.product", workspaceProductKey);
            this._setWorkspacePluginVersion(destDir.toPath(), "2.5.3");
        }
        if (pluginsSDK) {
            File gitFile;
            if (initArgs.isUpgrade() && !mavenBuild) {
                GradleExec gradleExec = new GradleExec(bladeCLI);
                gradleExec.executeTask("upgradePluginsSDK");
            }
            if ((gitFile = new File(temp, ".git")).exists()) {
                File destGitFile = new File(destDir, ".git");
                this._moveContentsToDirectory(gitFile, destGitFile);
                FileUtil.deleteDir(gitFile.toPath());
            }
            File pluginsSdkDir = new File(destDir, "plugins-sdk");
            this._moveContentsToDirectory(temp, pluginsSdkDir);
            FileUtil.deleteDir(temp.toPath());
        }
        args.setBase(destDir);
        BladeSettings settings = bladeCLI.getBladeSettings();
        if (profileName == null) {
            profileName = "gradle";
        }
        settings.setProfileName(profileName);
        settings.save();
    }

    @Override
    public Class<InitArgs> getArgsClass() {
        return InitArgs.class;
    }

    private void _addError(String msg) {
        this.getBladeCLI().addErrors("init", Collections.singleton(msg));
    }

    private String _getDefaultProductKey(InitArgs initArgs) throws Exception {
        String liferayVersion = initArgs.getLiferayVersion();
        if (liferayVersion.startsWith("portal") || liferayVersion.startsWith("dxp") || liferayVersion.startsWith("commerce")) {
            return initArgs.getLiferayVersion();
        }
        List<String> productInfoKeys = BladeUtil.getWorkspaceProductKeys(false);
        Optional<String> defaultVersion = productInfoKeys.stream().filter(value -> value.startsWith(initArgs.getLiferayProduct() + "-" + initArgs.getLiferayVersion())).findFirst();
        if (!defaultVersion.isPresent()) {
            return initArgs.getLiferayVersion();
        }
        return defaultVersion.get();
    }

    private boolean _isPluginsSDK(File dir) {
        if (dir == null || !dir.exists() || !dir.isDirectory()) {
            return false;
        }
        List<String> names = Arrays.asList(dir.list());
        return names != null && names.contains("portlets") && names.contains("hooks") && names.contains("layouttpl") && names.contains("themes") && names.contains("build.properties") && names.contains("build.xml") && names.contains("build-common.xml") && names.contains("build-common-plugin.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _isPluginsSDK70(File dir) {
        if (dir == null || !dir.exists() || !dir.isDirectory()) {
            return false;
        }
        File buildProperties = new File(dir, "build.properties");
        Properties properties = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(buildProperties);
            properties.load(in);
            String sdkVersionValue = (String)properties.get("lp.version");
            if (sdkVersionValue.equals("7.0.0")) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    private Version _makeCompatibleVersion(String targetPlatformVersion) {
        int dash = targetPlatformVersion.indexOf("-");
        Version productTargetPlatformVersion = null;
        productTargetPlatformVersion = dash != -1 ? Version.parseVersion(targetPlatformVersion.substring(0, dash)) : Version.parseVersion(targetPlatformVersion);
        return productTargetPlatformVersion;
    }

    private void _moveContentsToDirectory(final File src, File dest) throws Exception {
        Path srcPath = src.toPath();
        final Path source = srcPath.toAbsolutePath();
        Path destPath = dest.toPath();
        final Path target = destPath.toAbsolutePath();
        Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException ioException) throws IOException {
                File file = dir.toFile();
                String dirName = file.getName();
                if (!dirName.equals(src.getName())) {
                    Files.delete(dir);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes basicFileAttributes) throws IOException {
                Path targetDir = target.resolve(source.relativize(dir));
                if (!Files.exists(targetDir, new LinkOption[0])) {
                    Files.createDirectory(targetDir, new FileAttribute[0]);
                }
                File file = dir.toFile();
                if (BladeUtil.isWindows() && !file.canWrite()) {
                    Files.setAttribute(dir, "dos:readonly", false, new LinkOption[0]);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                Path targetFile = target.resolve(source.relativize(path));
                if (!Files.exists(targetFile, new LinkOption[0])) {
                    Files.copy(path, targetFile, new CopyOption[0]);
                }
                File file = path.toFile();
                if (BladeUtil.isWindows() && !file.canWrite()) {
                    Files.setAttribute(path, "dos:readonly", false, new LinkOption[0]);
                }
                Files.delete(path);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private String _setProductAndVersionForMaven(Map<String, Object> productInfos, InitArgs initArgs) throws Exception {
        String possibleProductKey = this._getDefaultProductKey(initArgs);
        if (possibleProductKey.startsWith("portal") || possibleProductKey.startsWith("dxp") || possibleProductKey.startsWith("commerce")) {
            Object productInfoObject = productInfos.get(possibleProductKey);
            if (Objects.nonNull(productInfoObject)) {
                ProductInfo productInfo = new ProductInfo((Map)productInfoObject);
                initArgs.setLiferayVersion(productInfo.getTargetPlatformVersion());
                String[] productKeyValues = possibleProductKey.split("-");
                initArgs.setLiferayProduct(productKeyValues[0]);
                return possibleProductKey;
            }
        } else {
            for (Map.Entry<String, Object> entryKey : productInfos.entrySet()) {
                ProductInfo productInfo = new ProductInfo((Map)entryKey.getValue());
                if (!Objects.equals(possibleProductKey, productInfo.getTargetPlatformVersion())) continue;
                possibleProductKey = entryKey.getKey();
                String[] productKeyValues = possibleProductKey.split("-");
                initArgs.setLiferayProduct(productKeyValues[0]);
                return possibleProductKey;
            }
        }
        return null;
    }

    private void _setWorkspacePluginVersion(Path path, String version) throws Exception {
        Path settingsPath = path.resolve("settings.gradle");
        String content = new String(Files.readAllBytes(settingsPath));
        String updated = content.replaceFirst("2\\.5\\.[0-9]", version);
        Files.write(settingsPath, updated.getBytes(), new OpenOption[0]);
    }

    private void _trace(String msg) {
        this.getBladeCLI().trace("%s: %s", "init", msg);
    }
}

