/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli;

import com.liferay.blade.cli.util.FileUtil;
import com.liferay.blade.cli.util.FileWatcher;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class FileWatcherTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private Path _testDir = null;
    private Path _testfile = null;
    private Path _testsecondfile = null;

    @After
    public void cleanUp() throws Exception {
        if (Files.exists(this._testDir, new LinkOption[0])) {
            FileUtil.deleteDir((Path)this._testDir);
            Assert.assertFalse((boolean)Files.exists(this._testDir, new LinkOption[0]));
        }
    }

    @Before
    public void setUp() throws Exception {
        File testDir = this.temporaryFolder.newFolder(new String[]{"build", "watch"});
        this._testDir = testDir.toPath();
        this._testfile = this._testDir.resolve("file.txt");
        Files.createFile(this._testfile, new FileAttribute[0]);
        this._testsecondfile = this._testDir.resolve("second.txt");
        Files.createFile(this._testsecondfile, new FileAttribute[0]);
    }

    @Ignore
    @Test
    public void testFileWatcherMultipleFiles() throws Exception {
        Files.write(this._testfile, "foobar".getBytes(), new OpenOption[0]);
        final HashMap<Path, Boolean> changed = new HashMap<Path, Boolean>();
        changed.put(this._testfile, false);
        changed.put(this._testsecondfile, false);
        final CountDownLatch latch = new CountDownLatch(2);
        FileWatcher.Consumer<Path> consumer = new FileWatcher.Consumer<Path>(){

            public void consume(Path modified) {
                changed.put(modified, true);
                latch.countDown();
            }
        };
        Thread t = new Thread((FileWatcher.Consumer)consumer){
            final /* synthetic */ FileWatcher.Consumer val$consumer;
            {
                this.val$consumer = consumer;
            }

            @Override
            public void run() {
                try {
                    new FileWatcher(FileWatcherTest.this._testDir, false, this.val$consumer);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        t.setDaemon(true);
        t.start();
        Thread.sleep(2000L);
        Files.write(this._testfile, "touch".getBytes(), new OpenOption[0]);
        Files.write(this._testsecondfile, "second file content".getBytes(), new OpenOption[0]);
        latch.await();
        for (Map.Entry entry : changed.entrySet()) {
            Assert.assertTrue((boolean)((Boolean)entry.getValue()));
        }
    }

    @Ignore
    @Test
    public void testFileWatcherSingleFile() throws Exception {
        final boolean[] changed = new boolean[1];
        final CountDownLatch latch = new CountDownLatch(1);
        FileWatcher.Consumer<Path> consumer = new FileWatcher.Consumer<Path>(){

            public void consume(Path modified) {
                changed[0] = true;
                latch.countDown();
            }
        };
        Assert.assertFalse((boolean)changed[0]);
        Thread t = new Thread((FileWatcher.Consumer)consumer){
            final /* synthetic */ FileWatcher.Consumer val$consumer;
            {
                this.val$consumer = consumer;
            }

            @Override
            public void run() {
                try {
                    new FileWatcher(FileWatcherTest.this._testDir, FileWatcherTest.this._testfile, false, this.val$consumer);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        t.setDaemon(true);
        t.start();
        Thread.sleep(1000L);
        Files.write(this._testfile, "touch".getBytes(), new OpenOption[0]);
        latch.await();
        Assert.assertTrue((boolean)changed[0]);
    }
}

