/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli;

import com.liferay.blade.cli.TestUtil;
import com.liferay.blade.cli.gradle.GradleWorkspaceProvider;
import com.liferay.blade.cli.util.BladeUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Properties;
import java.util.regex.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TargetPlatformTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File _extensionsDir = null;
    private File _gradlePropertiesFile = null;
    private File _gradleWorkspaceDir = null;
    private File _settingsGradleFile = null;

    @Before
    public void setUp() throws Exception {
        this._extensionsDir = this.temporaryFolder.newFolder(new String[]{".blade", "extensions"});
        this._gradleWorkspaceDir = this.temporaryFolder.newFolder("gradle-workspace");
        String[] args = new String[]{"init", "--base", this._gradleWorkspaceDir.getAbsolutePath(), "-v", "portal-7.3-ga6"};
        TestUtil.runBlade(this._gradleWorkspaceDir, this._extensionsDir, args);
        GradleWorkspaceProvider workspaceProviderGradle = new GradleWorkspaceProvider();
        this._gradlePropertiesFile = workspaceProviderGradle.getGradlePropertiesFile(this._gradleWorkspaceDir);
        this._settingsGradleFile = workspaceProviderGradle.getSettingGradleFile(this._gradleWorkspaceDir);
    }

    @Test
    public void testTargetPlatformEnabled() throws Exception {
        this._setTargetPlatformVersionProperty("7.1.0");
        this._setWorkspacePluginVersion("1.10.2");
        String[] args = new String[]{"--base", this._gradleWorkspaceDir.getAbsolutePath(), "create", "-t", "api", "test-api"};
        TestUtil.runBlade(this._gradleWorkspaceDir, this._extensionsDir, args);
        File projectDir = new File(this._gradleWorkspaceDir, "modules/test-api");
        File buildGradleFile = new File(projectDir, "build.gradle");
        String buildScriptContents = BladeUtil.read((File)buildGradleFile);
        boolean containsVersion = buildScriptContents.contains("compileOnly group: \"org.osgi\", name: \"org.osgi.core\", version:");
        Assert.assertFalse((String)"osgi.core dependency should not have a version", (boolean)containsVersion);
    }

    private void _setTargetPlatformVersionProperty(String version) throws IOException {
        GradleWorkspaceProvider workspaceProviderGradle = new GradleWorkspaceProvider();
        Properties properties = workspaceProviderGradle.getGradleProperties(this._gradlePropertiesFile);
        properties.setProperty("liferay.workspace.target.platform.version", version);
        try (OutputStream outputStream = Files.newOutputStream(this._gradlePropertiesFile.toPath(), new OpenOption[0]);){
            properties.store(outputStream, "");
        }
    }

    private void _setWorkspacePluginVersion(String version) throws IOException {
        String settingsScript = BladeUtil.read((File)this._settingsGradleFile);
        Matcher matcher = GradleWorkspaceProvider.patternWorkspacePluginVersion.matcher(settingsScript);
        Assert.assertTrue((String)settingsScript, (boolean)matcher.matches());
        String pluginVersion = matcher.group(1);
        String newSettingsScript = settingsScript.replaceFirst(pluginVersion, version);
        byte[] bytes = newSettingsScript.getBytes();
        try (OutputStream outputStream = Files.newOutputStream(this._settingsGradleFile.toPath(), new OpenOption[0]);){
            outputStream.write(bytes);
        }
    }
}

