/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.gradle;

import com.liferay.blade.cli.gradle.GradleWorkspaceProvider;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class WorkspaceProvideGradleTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testIsWorkspace1() throws Exception {
        File root = this.temporaryFolder.getRoot();
        Path workspace = root.toPath();
        workspace = workspace.resolve("workspace");
        Files.createDirectories(workspace, new FileAttribute[0]);
        Path gradlePath = workspace.resolve("settings.gradle");
        String plugin = "apply plugin: \"com.liferay.workspace\"";
        Files.write(gradlePath, plugin.getBytes(), new OpenOption[0]);
        GradleWorkspaceProvider workspaceProviderGradle = new GradleWorkspaceProvider();
        Assert.assertTrue((boolean)workspaceProviderGradle.isWorkspace(workspace.toFile()));
    }

    @Test
    public void testIsWorkspace2() throws Exception {
        File root = this.temporaryFolder.getRoot();
        Path workspace = root.toPath();
        workspace = workspace.resolve("workspace");
        Files.createDirectories(workspace, new FileAttribute[0]);
        Path gradleFile = workspace.resolve("settings.gradle");
        String plugin = "apply plugin: 'com.liferay.workspace'";
        Files.write(gradleFile, plugin.getBytes(), new OpenOption[0]);
        GradleWorkspaceProvider workspaceProviderGradle = new GradleWorkspaceProvider();
        Assert.assertTrue((boolean)workspaceProviderGradle.isWorkspace(workspace.toFile()));
    }

    @Test
    public void testIsWorkspace3() throws Exception {
        File root = this.temporaryFolder.getRoot();
        Path workspace = root.toPath();
        workspace = workspace.resolve("workspace");
        Files.createDirectories(workspace, new FileAttribute[0]);
        Path buildFile = workspace.resolve("build.gradle");
        Path settingsFile = workspace.resolve("settings.gradle");
        Files.createFile(settingsFile, new FileAttribute[0]);
        String plugin = "\napply   plugin:   \n\"com.liferay.workspace\"";
        Files.write(buildFile, plugin.getBytes(), new OpenOption[0]);
        GradleWorkspaceProvider workspaceProviderGradle = new GradleWorkspaceProvider();
        Assert.assertTrue((boolean)workspaceProviderGradle.isWorkspace(workspace.toFile()));
    }
}

