/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli;

import com.liferay.blade.cli.util.FileUtil;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.zip.ZipException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ZipSlipTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private Path _rootPath = null;

    @Before
    public void setUp() throws Exception {
        File tempDir = this.temporaryFolder.getRoot();
        this._rootPath = tempDir.toPath();
    }

    @Test
    public void testNoZipSlipZip() throws Exception {
        this._testZip("no-zip-slip.zip");
        Path expectedAPath = this._rootPath.resolve("afile");
        Assert.assertTrue((String)("Expected file " + expectedAPath + " not found."), (boolean)Files.exists(expectedAPath, new LinkOption[0]));
        Path expectedBPath = this._rootPath.resolve("b/bfile");
        Assert.assertTrue((String)("Expected file " + expectedBPath + " not found."), (boolean)Files.exists(expectedBPath, new LinkOption[0]));
        Path expectedEPath = this._rootPath.resolve("c/d/efile");
        Assert.assertTrue((String)("Expected file " + expectedEPath + " not found."), (boolean)Files.exists(expectedEPath, new LinkOption[0]));
    }

    @Test(expected=ZipException.class)
    public void testZipSlipZip() throws Exception {
        this._testZip("zip-slip.zip");
    }

    private void _testZip(String fileName) throws Exception {
        Path zipPath = this._rootPath.resolve(fileName);
        Files.copy(this.getClass().getResourceAsStream(fileName), zipPath, new CopyOption[0]);
        FileUtil.unzip((File)zipPath.toFile(), (File)this._rootPath.toFile());
    }
}

